/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest.mappers;

import java.util.Locale;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;
import org.opensearch.indices.pollingingest.ShardUpdateMessage;
import org.opensearch.indices.pollingingest.mappers.DefaultIngestionMessageMapper;
import org.opensearch.indices.pollingingest.mappers.RawPayloadIngestionMessageMapper;

public interface IngestionMessageMapper {
    public ShardUpdateMessage mapAndProcess(IngestionShardPointer var1, Message var2) throws IllegalArgumentException;

    public static IngestionMessageMapper create(String mapperTypeString, int shardId) {
        MapperType mapperType = MapperType.fromString(mapperTypeString);
        switch (mapperType.ordinal()) {
            case 0: {
                return new DefaultIngestionMessageMapper();
            }
            case 1: {
                return new RawPayloadIngestionMessageMapper(shardId);
            }
        }
        throw new IllegalArgumentException("Unknown mapper type: " + String.valueOf((Object)mapperType));
    }

    @ExperimentalApi
    public static enum MapperType {
        DEFAULT("default"),
        RAW_PAYLOAD("raw_payload");

        private final String name;

        private MapperType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static MapperType fromString(String value) {
            for (MapperType type : MapperType.values()) {
                if (!type.name.equalsIgnoreCase(value)) continue;
                return type;
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown ingestion mapper type: %s. Valid values are: default, raw_payload", value));
        }
    }
}

