/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ons.Message;
import oracle.ons.Node;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.SubscribePermission;
import oracle.ons.Subscriber;

class SubscriptionProxy {
    private final Map<Integer, WeakReference<Subscriber>> frontendSubscribers = new ConcurrentHashMap<Integer, WeakReference<Subscriber>>();
    private final NotificationNetwork network;
    private final Map<String, Long> notificationHistory = new HashMap<String, Long>();
    private final Queue<String> notificationHistoryTimeouts = new LinkedList<String>();
    private final Object notificationHistoryLock = new Object();
    private final String subscriptionKey;
    protected final Message subscriptionMessage;
    private volatile Notification registrationNotification = null;

    public SubscriptionProxy(NotificationNetwork notificationNetwork, Subscriber subscriber) {
        this.add(subscriber);
        this.subscriptionKey = subscriber.getSubscriptionKey();
        this.subscriptionMessage = subscriber.getSubscriptionMessage();
        this.network = notificationNetwork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(Notification notification) throws InterruptedException {
        Object object;
        ++this.network.messageReceived;
        String string = notification.id();
        if (string != null) {
            long l = System.currentTimeMillis();
            object = this.notificationHistoryLock;
            synchronized (object) {
                long l2;
                if (this.notificationHistory.containsKey(string)) {
                    ++this.network.messageDropped;
                    return;
                }
                this.notificationHistory.put(string, l);
                this.notificationHistoryTimeouts.add(string);
                l -= this.network.config.getNotificationWindow();
                while (!this.notificationHistoryTimeouts.isEmpty() && (l2 = this.notificationHistory.get(string = this.notificationHistoryTimeouts.peek()).longValue()) < l) {
                    this.notificationHistory.remove(string);
                    this.notificationHistoryTimeouts.remove();
                }
            }
        }
        for (WeakReference<Subscriber> weakReference : this.frontendSubscribers.values()) {
            object = (Subscriber)weakReference.get();
            if (object == null) continue;
            ((Subscriber)object).put(notification);
        }
    }

    public void add(Subscriber subscriber) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.frontendSubscribers.put(subscriber.id, new WeakReference<Subscriber>(subscriber));
        if (this.registrationNotification != null) {
            try {
                subscriber.put(this.registrationNotification);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    synchronized void setRegistrationNotification(Notification notification) {
        this.registrationNotification = notification;
        for (WeakReference<Subscriber> weakReference : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)weakReference.get();
            if (subscriber == null || subscriber.isOpen()) continue;
            try {
                subscriber.put(notification);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void remove(Subscriber subscriber) {
        this.frontendSubscribers.remove(subscriber.id);
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public boolean isEmpty() {
        return this.frontendSubscribers.isEmpty();
    }

    protected void setServerSubscriberInfo(Node node, String string) {
        for (WeakReference<Subscriber> weakReference : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)weakReference.get();
            if (subscriber == null) continue;
            subscriber.setServerSubscriberInfo(node, string);
        }
    }
}

