/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.DefaultSelectable;
import com.jidesoft.swing.Selectable;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.text.Position;

public class CheckBoxListWithSelectable
extends JList
implements ItemSelectable {
    protected CheckBoxListCellRenderer _listCellRenderer;
    public static final String PROPERTY_CHECKBOX_ENABLED = "checkBoxEnabled";
    public static final String PROPERTY_CLICK_IN_CHECKBOX_ONLY = "clickInCheckBoxOnly";
    private boolean _checkBoxEnabled = true;
    private boolean _clickInCheckBoxOnly = true;

    public CheckBoxListWithSelectable() {
        this.init();
    }

    public CheckBoxListWithSelectable(Vector<?> listData) {
        super(CheckBoxListWithSelectable.wrap(listData));
        this.init();
    }

    public CheckBoxListWithSelectable(Object[] listData) {
        super(CheckBoxListWithSelectable.wrap(listData));
        this.init();
    }

    public CheckBoxListWithSelectable(ListModel dataModel) {
        super(CheckBoxListWithSelectable.wrap(dataModel));
        this.init();
    }

    protected void init() {
        this.setSelectionMode(2);
        this._listCellRenderer = this.createCellRenderer();
        Handler handle = this.createHandler();
        this.addMouseListener(handle);
        this.addKeyListener(handle);
    }

    protected CheckBoxListCellRenderer createCellRenderer() {
        return new CheckBoxListCellRenderer();
    }

    protected Handler createHandler() {
        return new Handler(this);
    }

    public void setSelectedObjects(Object[] elements) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : elements) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    public void setSelectedObjects(Vector<?> objects) {
        HashMap<Object, String> selected = new HashMap<Object, String>();
        for (Object element : objects) {
            selected.put(element, "");
        }
        this.setSelectedObjects(selected);
    }

    public ListCellRenderer getCellRenderer() {
        if (this._listCellRenderer != null) {
            this._listCellRenderer.setActualListRenderer(super.getCellRenderer());
            return this._listCellRenderer;
        }
        return super.getCellRenderer();
    }

    public ListCellRenderer getActualCellRenderer() {
        if (this._listCellRenderer != null) {
            return this._listCellRenderer.getActualListRenderer();
        }
        return super.getCellRenderer();
    }

    private void setSelectedObjects(Map<Object, String> selected) {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object elementAt = this.getModel().getElementAt(i);
            if (!(elementAt instanceof Selectable)) continue;
            Selectable selectable = (Selectable)elementAt;
            if (selectable instanceof DefaultSelectable) {
                elementAt = ((DefaultSelectable)selectable).getObject();
            }
            if (selected.get(elementAt) != null) {
                selectable.setSelected(true);
                this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
                selected.remove(elementAt);
                if (selected.size() != 0) continue;
                break;
            }
            if (!selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    private static ListModel wrap(ListModel dataModel) {
        for (int i = 0; i < dataModel.getSize(); ++i) {
            if (dataModel.getElementAt(i) instanceof Selectable) continue;
            throw new IllegalArgumentException("The ListModel contains an element which is not an instance of Selectable at index " + i + ".");
        }
        return dataModel;
    }

    private static Selectable[] wrap(Object[] objects) {
        if (objects instanceof Selectable[]) {
            return (Selectable[])objects;
        }
        Selectable[] elements = new Selectable[objects.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = new DefaultSelectable(objects[i]);
        }
        return elements;
    }

    private static Vector<?> wrap(Vector<?> objects) {
        Vector<Selectable> elements = new Vector<Selectable>();
        for (Object o : objects) {
            if (o instanceof Selectable) {
                elements.add((Selectable)o);
                continue;
            }
            elements.add(new DefaultSelectable(o));
        }
        return elements;
    }

    public boolean isClickInCheckBoxOnly() {
        return this._clickInCheckBoxOnly;
    }

    public void setClickInCheckBoxOnly(boolean clickInCheckBoxOnly) {
        if (clickInCheckBoxOnly != this._clickInCheckBoxOnly) {
            boolean old = this._clickInCheckBoxOnly;
            this._clickInCheckBoxOnly = clickInCheckBoxOnly;
            this.firePropertyChange(PROPERTY_CLICK_IN_CHECKBOX_ONLY, old, this._clickInCheckBoxOnly);
        }
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.listenerList.add(ItemListener.class, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.listenerList.remove(ItemListener.class, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    protected void fireItemStateChanged(ItemEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ItemEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            if (e == null) {
                e = new ItemEvent(this, 701, event.getItem(), event.getStateChange());
            }
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        Vector<Object> elements = new Vector<Object>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Selectable selectable;
            Object elementAt = this.getModel().getElementAt(i);
            if (!(elementAt instanceof Selectable) || !(selectable = (Selectable)elementAt).isSelected()) continue;
            if (selectable instanceof DefaultSelectable) {
                elements.add(((DefaultSelectable)selectable).getObject());
                continue;
            }
            elements.add(selectable);
        }
        return elements.toArray();
    }

    public void selectAll() {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Selectable selectable;
            Object elementAt = this.getModel().getElementAt(i);
            if (!(elementAt instanceof Selectable) || !(selectable = (Selectable)elementAt).isEnabled() || selectable.isSelected()) continue;
            selectable.setSelected(true);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 1));
        }
        this.repaint();
    }

    public void selectNone() {
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Selectable selectable;
            Object elementAt = this.getModel().getElementAt(i);
            if (!(elementAt instanceof Selectable) || !(selectable = (Selectable)elementAt).isEnabled() || !selectable.isSelected()) continue;
            selectable.setSelected(false);
            this.fireItemStateChanged(new ItemEvent(this, 701, selectable, 2));
        }
        this.repaint();
    }

    public void setListData(Vector listData) {
        super.setListData(CheckBoxListWithSelectable.wrap(listData));
    }

    public void setListData(Object[] listData) {
        super.setListData(CheckBoxListWithSelectable.wrap(listData));
    }

    @Override
    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    public boolean isCheckBoxEnabled() {
        return this._checkBoxEnabled;
    }

    public boolean isCheckBoxVisible(int index) {
        return true;
    }

    public void setCheckBoxEnabled(boolean checkBoxEnabled) {
        if (checkBoxEnabled != this._checkBoxEnabled) {
            Boolean oldValue = this._checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            Boolean newValue = checkBoxEnabled ? Boolean.TRUE : Boolean.FALSE;
            this._checkBoxEnabled = checkBoxEnabled;
            this.firePropertyChange(PROPERTY_CHECKBOX_ENABLED, oldValue, newValue);
            this.repaint();
        }
    }

    protected static class Handler
    implements MouseListener,
    KeyListener {
        protected CheckBoxListWithSelectable _list;
        int _hotspot;

        public Handler(CheckBoxListWithSelectable list) {
            this._hotspot = new JCheckBox().getPreferredSize().width;
            this._list = list;
        }

        protected boolean clicksInCheckBox(MouseEvent e) {
            int index = this._list.locationToIndex(e.getPoint());
            Rectangle bounds = this._list.getCellBounds(index, index);
            if (bounds != null) {
                if (this._list.getComponentOrientation().isLeftToRight()) {
                    return e.getX() < bounds.x + this._hotspot;
                }
                return e.getX() > bounds.x + bounds.width - this._hotspot;
            }
            return false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
                return;
            }
            if (!this._list.isClickInCheckBoxOnly() || this.clicksInCheckBox(e)) {
                int index = this._list.locationToIndex(e.getPoint());
                this.toggleSelection(index);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!this._list.isCheckBoxEnabled() || !this._list.isEnabled()) {
                return;
            }
            if (e.getModifiers() == 0 && e.getKeyChar() == ' ') {
                this.toggleSelections();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        protected void toggleSelections() {
            int[] indices = this._list.getSelectedIndices();
            ListModel model = this._list.getModel();
            for (int index : indices) {
                Object element = model.getElementAt(index);
                if (!(element instanceof Selectable) || !((Selectable)element).isEnabled()) continue;
                ((Selectable)element).invertSelected();
                boolean selected = ((Selectable)element).isSelected();
                this._list.fireItemStateChanged(new ItemEvent(this._list, 701, element, selected ? 1 : 2));
            }
            this._list.repaint();
        }

        protected void toggleSelection(int index) {
            ListModel model = this._list.getModel();
            if (index >= 0) {
                Object element = model.getElementAt(index);
                if (element instanceof Selectable && ((Selectable)element).isEnabled()) {
                    ((Selectable)element).invertSelected();
                    boolean selected = ((Selectable)element).isSelected();
                    this._list.fireItemStateChanged(new ItemEvent(this._list, 701, element, selected ? 1 : 2));
                }
                this._list.repaint();
            }
        }

        protected void toggleSelection() {
            int index = this._list.getSelectedIndex();
            this.toggleSelection(index);
        }
    }
}

