/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0000\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"isTypeVisibilityBroken", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkTypeArguments", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Z)Z", "checkers"})
public final class FirTypeVisibilityHelpersKt {
    public static final boolean isTypeVisibilityBroken(@NotNull CheckerContext context2, @NotNull ConeKotlinType $this$isTypeVisibilityBroken, boolean checkTypeArguments) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter($this$isTypeVisibilityBroken, "<this>");
        FirVisibilityChecker visibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession());
        FirClassSymbol<?> classSymbol = ToSymbolUtilsKt.toClassSymbol((SessionHolder)context2, $this$isTypeVisibilityBroken);
        FirFileSymbol containingFile = context2.getContainingFileSymbol();
        if (classSymbol == null || containingFile == null) {
            return false;
        }
        if (!FirVisibilityCheckerKt.isClassLikeVisible(visibilityChecker, (FirClassLikeSymbol)classSymbol, context2.getSession(), containingFile, context2.getContainingDeclarations())) {
            return true;
        }
        if (checkTypeArguments) {
            for (ConeTypeProjection typeArgument : $this$isTypeVisibilityBroken.getTypeArguments()) {
                if (!(typeArgument instanceof ConeKotlinTypeProjection) || !FirTypeVisibilityHelpersKt.isTypeVisibilityBroken(context2, ((ConeKotlinTypeProjection)typeArgument).getType(), true)) continue;
                return true;
            }
        }
        return false;
    }
}

