/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class PathExecLazyValue {
    @NotNull
    public static Supplier<Boolean> create(@NotNull String name2) {
        if (name2 == null) {
            PathExecLazyValue.$$$reportNull$$$0(0);
        }
        if (Strings.containsAnyChar(name2, "/\\")) {
            throw new IllegalArgumentException(name2);
        }
        return new SynchronizedClearableLazy<Boolean>(() -> {
            String path = EnvironmentUtil.getValue("PATH");
            if (path != null) {
                for (String dir2 : StringUtil.tokenize(path, File.pathSeparator)) {
                    if (!new File(dir2, name2).canExecute()) continue;
                    return true;
                }
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/io/PathExecLazyValue", "create"));
    }
}

