/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class LDAPDn {
    private final LdapName ldapName;

    private LDAPDn() {
        this.ldapName = new LdapName(Collections.emptyList());
    }

    private LDAPDn(LdapName ldapName) {
        this.ldapName = ldapName;
    }

    public static LDAPDn fromLdapName(LdapName ldapName) {
        return new LDAPDn(ldapName);
    }

    public static LDAPDn fromString(String dnString) {
        if (dnString.trim().isEmpty()) {
            return new LDAPDn();
        }
        try {
            return new LDAPDn(new LdapName(dnString));
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Invalid DN:" + dnString, e);
        }
    }

    public LdapName getLdapName() {
        return this.ldapName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LDAPDn)) {
            return false;
        }
        return this.ldapName.equals(((LDAPDn)obj).ldapName);
    }

    public int hashCode() {
        return this.ldapName.hashCode();
    }

    public String toString() {
        return this.ldapName.toString();
    }

    public RDN getFirstRdn() {
        if (this.ldapName.size() > 0) {
            return new RDN(this.ldapName.getRdn(this.ldapName.size() - 1));
        }
        return null;
    }

    public LDAPDn getParentDn() {
        if (this.ldapName.size() > 0) {
            LdapName parent = (LdapName)this.ldapName.getPrefix(this.ldapName.size() - 1);
            return new LDAPDn(parent);
        }
        return null;
    }

    public boolean isDescendantOf(LDAPDn expectedParentDn) {
        LDAPDn parent = this.getParentDn();
        if (parent == null) {
            return false;
        }
        return parent.ldapName.startsWith(expectedParentDn.ldapName);
    }

    public void addFirst(String rdnName, String rdnValue) {
        try {
            this.ldapName.add(rdnName + "=" + Rdn.escapeValue(rdnValue));
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Invalid RDN name=" + rdnName + " value=" + rdnValue, e);
        }
    }

    public void addFirst(RDN entry) {
        this.ldapName.add(entry.rdn);
    }

    public static class RDN {
        private Rdn rdn;

        private RDN(Rdn rdn) {
            this.rdn = rdn;
        }

        public List<String> getAllKeys() {
            try {
                Attributes attrs = this.rdn.toAttributes();
                ArrayList<String> result = new ArrayList<String>(attrs.size());
                NamingEnumeration<? extends Attribute> ne = attrs.getAll();
                while (ne.hasMore()) {
                    result.add(ne.next().getID());
                }
                return result;
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }

        public String getAttrValue(String attrName) {
            try {
                Object value;
                Attribute attr = this.rdn.toAttributes().get(attrName);
                if (attr != null && (value = attr.get()) != null) {
                    return value.toString();
                }
                return null;
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }

        public void setAttrValue(String attrName, String newAttrValue) {
            try {
                Attributes attrs = this.rdn.toAttributes();
                Attribute attr = attrs.get(attrName);
                if (attr != null) {
                    attr.clear();
                    attr.add(newAttrValue);
                } else {
                    attrs.put(attrName, newAttrValue);
                }
                this.rdn = new Rdn(attrs);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }

        public boolean removeAttrValue(String attrName) {
            try {
                Attributes attrs = this.rdn.toAttributes();
                if (attrs.remove(attrName) != null) {
                    this.rdn = new Rdn(attrs);
                    return true;
                }
                return false;
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }

        public String toString() {
            return this.rdn.toString();
        }

        public String toString(boolean escaped) {
            if (escaped) {
                return this.toString();
            }
            StringBuilder builder = new StringBuilder();
            try {
                NamingEnumeration<? extends Attribute> attrs = this.rdn.toAttributes().getAll();
                while (attrs.hasMore()) {
                    Attribute attr = attrs.next();
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMore()) {
                        builder.append(attr.getID()).append("=").append(values.next().toString()).append("+");
                    }
                }
                builder.setLength(builder.length() - 1);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
            return builder.toString();
        }
    }
}

