/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.keycloak.broker.saml.SAMLEndpoint;
import org.keycloak.common.Version;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.endpoints.LogoutEndpoint;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.clientregistration.oidc.OIDCClientRegistrationProvider;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.utils.StringUtil;

public class Urls {
    public static URI adminConsoleRoot(URI baseUri, String realmName) {
        return UriBuilder.fromUri((URI)baseUri).path(AdminRoot.class).path("{realm}/console/").build(new Object[]{realmName});
    }

    public static UriBuilder accountBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getAccountService");
    }

    public static URI identityProviderAuthnResponse(URI baseUri, String providerAlias, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "getEndpoint").build(new Object[]{realmName, providerAlias});
    }

    public static URI identityProviderAuthnResponse(URI baseUri, String providerAlias, String realmName, String client_id) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "getEndpoint").path(SAMLEndpoint.class, "redirectBindingIdpInitiated").build(new Object[]{realmName, providerAlias, client_id});
    }

    public static URI identityProviderAuthnRequest(URI baseUri, String providerAlias, String realmName, String accessCode, String clientId, String tabId, String clientData, String loginHint) {
        UriBuilder uriBuilder = Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "performLogin");
        if (accessCode != null) {
            uriBuilder.replaceQueryParam("session_code", new Object[]{accessCode});
        }
        if (clientId != null) {
            uriBuilder.replaceQueryParam("client_id", new Object[]{clientId});
        }
        if (tabId != null) {
            uriBuilder.replaceQueryParam("tab_id", new Object[]{tabId});
        }
        if (clientData != null) {
            uriBuilder.replaceQueryParam("client_data", new Object[]{clientData});
        }
        if (loginHint != null) {
            uriBuilder.replaceQueryParam("login_hint", new Object[]{loginHint});
        }
        return uriBuilder.build(new Object[]{realmName, providerAlias});
    }

    public static URI identityProviderLinkRequest(URI baseUri, String providerAlias, String realmName) {
        UriBuilder uriBuilder = Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").replaceQuery(null).path(IdentityBrokerService.class, "clientInitiatedAccountLinking");
        return uriBuilder.build(new Object[]{realmName, providerAlias});
    }

    public static URI identityProviderRetrieveToken(URI baseUri, String providerAlias, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "retrieveToken").build(new Object[]{realmName, providerAlias});
    }

    public static URI identityProviderAuthnRequest(URI baseURI, String providerAlias, String realmName) {
        return Urls.identityProviderAuthnRequest(baseURI, providerAlias, realmName, null, null, null, null, null);
    }

    public static URI identityProviderAfterFirstBrokerLogin(URI baseUri, String realmName, String accessCode, String clientId, String tabId, String clientData) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "afterFirstBrokerLogin").replaceQueryParam("session_code", new Object[]{accessCode}).replaceQueryParam("client_id", new Object[]{clientId}).replaceQueryParam("tab_id", new Object[]{tabId}).replaceQueryParam("client_data", new Object[]{clientData}).build(new Object[]{realmName});
    }

    public static URI identityProviderAfterPostBrokerLogin(URI baseUri, String realmName, String accessCode, String clientId, String tabId, String clientData) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "afterPostBrokerLoginFlow").replaceQueryParam("session_code", new Object[]{accessCode}).replaceQueryParam("client_id", new Object[]{clientId}).replaceQueryParam("client_data", new Object[]{clientData}).replaceQueryParam("tab_id", new Object[]{tabId}).build(new Object[]{realmName});
    }

    public static URI logoutConfirm(URI baseUri, String realmName) {
        return Urls.realmLogout(baseUri).path(LogoutEndpoint.class, "logoutConfirmAction").build(new Object[]{realmName});
    }

    public static URI loginActionsDetachedInfo(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "detachedInfo").build(new Object[]{realmName});
    }

    public static UriBuilder requiredActionBase(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "requiredAction");
    }

    public static URI loginResetCredentials(URI baseUri, String realmName) {
        return Urls.loginResetCredentialsBuilder(baseUri).build(new Object[]{realmName});
    }

    public static UriBuilder actionTokenBuilder(URI baseUri, String tokenString, String clientId, String tabId, String clientData) {
        UriBuilder res = Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "executeActionToken").queryParam("key", new Object[]{tokenString}).queryParam("client_id", new Object[]{clientId}).queryParam("tab_id", new Object[]{tabId});
        if (StringUtil.isNotBlank((String)clientData)) {
            res = res.queryParam("client_data", new Object[]{clientData});
        }
        return res;
    }

    public static UriBuilder loginResetCredentialsBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path("reset-credentials");
    }

    public static URI loginUsernameReminder(URI baseUri, String realmName) {
        return Urls.loginUsernameReminderBuilder(baseUri).build(new Object[]{realmName});
    }

    public static UriBuilder loginUsernameReminderBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "usernameReminder");
    }

    public static String realmIssuer(URI baseUri, String realmName) {
        return Urls.realmBase(baseUri).path("{realm}").build(new Object[]{realmName}).toString();
    }

    public static UriBuilder realmBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(RealmsResource.class);
    }

    public static URI realmLoginPage(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "authenticate").build(new Object[]{realmName});
    }

    public static URI realmLoginRestartPage(URI baseUri, String realmId, boolean skipLogout) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "restartSession").queryParam("skip_logout", new Object[]{String.valueOf(skipLogout)}).build(new Object[]{realmId});
    }

    private static UriBuilder realmLogout(URI baseUri) {
        return Urls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "logout");
    }

    public static URI tokenEndpoint(URI baseUri, String realmName) {
        return Urls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "token").build(new Object[]{realmName});
    }

    public static URI realmRegisterAction(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "processRegister").build(new Object[]{realmName});
    }

    public static URI realmRegisterPage(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "registerPage").build(new Object[]{realmName});
    }

    public static URI realmInstalledAppUrnCallback(URI baseUri, String realmName) {
        return Urls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "installedAppUrnCallback").build(new Object[]{realmName});
    }

    public static URI realmOauthAction(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "processConsent").build(new Object[]{realmName});
    }

    public static URI firstBrokerLoginProcessor(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "firstBrokerLoginGet").build(new Object[]{realmName});
    }

    public static URI themeRoot(URI baseUri) {
        return Urls.themeBase(baseUri).path(Version.RESOURCES_VERSION).build(new Object[0]);
    }

    public static UriBuilder loginActionsBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getLoginActionsService");
    }

    private static UriBuilder tokenBase(URI baseUri) {
        return Urls.realmBase(baseUri).path("{realm}/protocol/openid-connect");
    }

    private static UriBuilder themeBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(ThemeResource.class);
    }

    public static URI samlRequestEndpoint(URI baseUri, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getProtocol").build(new Object[]{realmName, "saml"});
    }

    public static URI clientRegistration(URI baseUri, String realm, String protocol, String clientId) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getClientsService").path(ClientRegistrationService.class, "provider").path(OIDCClientRegistrationProvider.class, "getOIDC").build(new Object[]{realm, protocol, clientId});
    }
}

