/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.I2CPort;
import gnu.io.I2CPortEvent;
import gnu.io.I2CPortEventListener;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

final class I2C
extends I2CPort {
    private int fd;
    static boolean dsrFlag;
    private final I2COutputStream out = new I2COutputStream();
    private final I2CInputStream in = new I2CInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout = 0;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private I2CPortEventListener SPEventListener;
    private MonitorThread monThread;
    private int dataAvailable = 0;

    private static native void Initialize();

    public I2C(String string) throws PortInUseException {
        this.fd = this.open(string);
    }

    private native int open(String var1) throws PortInUseException;

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public void setI2CPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        this.nativeSetI2CPortParams(n, n2, n3, n4);
        this.speed = n;
        this.dataBits = n2;
        this.stopBits = n3;
        this.parity = n4;
    }

    private native void nativeSetI2CPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    @Override
    public int getBaudRate() {
        return this.speed;
    }

    @Override
    public int getDataBits() {
        return this.dataBits;
    }

    @Override
    public int getStopBits() {
        return this.stopBits;
    }

    @Override
    public int getParity() {
        return this.parity;
    }

    @Override
    public void setFlowControlMode(int n) {
        try {
            this.setflowcontrol(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.flowmode = n;
    }

    @Override
    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    @Override
    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    @Override
    public void disableReceiveFraming() {
    }

    @Override
    public boolean isReceiveFramingEnabled() {
        return false;
    }

    @Override
    public int getReceiveFramingByte() {
        return 0;
    }

    public native int NativegetReceiveTimeout();

    public native boolean NativeisReceiveTimeoutEnabled();

    public native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    @Override
    public void disableReceiveTimeout() {
        this.enableReceiveTimeout(0);
    }

    @Override
    public void enableReceiveTimeout(int n) {
        if (n >= 0) {
            this.timeout = n;
            this.NativeEnableReceiveTimeoutThreshold(n, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid timeout");
        }
    }

    @Override
    public boolean isReceiveTimeoutEnabled() {
        return this.NativeisReceiveTimeoutEnabled();
    }

    @Override
    public int getReceiveTimeout() {
        return this.NativegetReceiveTimeout();
    }

    @Override
    public void enableReceiveThreshold(int n) {
        if (n >= 0) {
            this.threshold = n;
            this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
        } else {
            System.out.println("Invalid Threshold");
        }
    }

    @Override
    public void disableReceiveThreshold() {
        this.enableReceiveThreshold(0);
    }

    @Override
    public int getReceiveThreshold() {
        return this.threshold;
    }

    @Override
    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 0;
    }

    @Override
    public void setInputBufferSize(int n) {
        this.InputBuffer = n;
    }

    @Override
    public int getInputBufferSize() {
        return this.InputBuffer;
    }

    @Override
    public void setOutputBufferSize(int n) {
        this.OutputBuffer = n;
    }

    @Override
    public int getOutputBufferSize() {
        return this.OutputBuffer;
    }

    @Override
    public native boolean isDTR();

    @Override
    public native void setDTR(boolean var1);

    @Override
    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    @Override
    public native boolean isCTS();

    @Override
    public native boolean isDSR();

    @Override
    public native boolean isCD();

    @Override
    public native boolean isRI();

    @Override
    public native boolean isRTS();

    @Override
    public native void sendBreak(int var1);

    private native void writeByte(int var1) throws IOException;

    private native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    private native void drain() throws IOException;

    private native int nativeavailable() throws IOException;

    private native int readByte() throws IOException;

    private native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    public void sendEvent(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.dataAvailable = 1;
                if (this.monThread.Data) break;
                return;
            }
            case 2: {
                if (this.monThread.Output) break;
                return;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return;
            }
            case 5: {
                if (this.monThread.RI) break;
                return;
            }
            case 6: {
                if (this.monThread.CD) break;
                return;
            }
            case 7: {
                if (this.monThread.OE) break;
                return;
            }
            case 8: {
                if (this.monThread.PE) break;
                return;
            }
            case 9: {
                if (this.monThread.FE) break;
                return;
            }
            case 10: {
                if (this.monThread.BI) break;
                return;
            }
            default: {
                System.err.println("unknown event:" + n);
                return;
            }
        }
        I2CPortEvent i2CPortEvent = new I2CPortEvent(this, n, !bl, bl);
        if (this.SPEventListener != null) {
            this.SPEventListener.I2CEvent(i2CPortEvent);
        }
    }

    @Override
    public void addEventListener(I2CPortEventListener i2CPortEventListener) throws TooManyListenersException {
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = i2CPortEventListener;
        this.monThread = new MonitorThread();
        this.monThread.start();
    }

    @Override
    public void removeEventListener() {
        this.SPEventListener = null;
        if (this.monThread != null) {
            this.monThread.interrupt();
            this.monThread = null;
        }
    }

    @Override
    public void notifyOnDataAvailable(boolean bl) {
        this.monThread.Data = bl;
    }

    @Override
    public void notifyOnOutputEmpty(boolean bl) {
        this.monThread.Output = bl;
    }

    @Override
    public void notifyOnCTS(boolean bl) {
        this.monThread.CTS = bl;
    }

    @Override
    public void notifyOnDSR(boolean bl) {
        this.monThread.DSR = bl;
    }

    @Override
    public void notifyOnRingIndicator(boolean bl) {
        this.monThread.RI = bl;
    }

    @Override
    public void notifyOnCarrierDetect(boolean bl) {
        this.monThread.CD = bl;
    }

    @Override
    public void notifyOnOverrunError(boolean bl) {
        this.monThread.OE = bl;
    }

    @Override
    public void notifyOnParityError(boolean bl) {
        this.monThread.PE = bl;
    }

    @Override
    public void notifyOnFramingError(boolean bl) {
        this.monThread.FE = bl;
    }

    @Override
    public void notifyOnBreakInterrupt(boolean bl) {
        this.monThread.BI = bl;
    }

    private native void nativeClose();

    @Override
    public void close() {
        this.setDTR(false);
        this.setDSR(false);
        this.nativeClose();
        super.close();
        this.fd = 0;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
    }

    static {
        System.loadLibrary("rxtxI2C");
        I2C.Initialize();
        dsrFlag = false;
    }

    class I2COutputStream
    extends OutputStream {
        I2COutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            I2C.this.writeByte(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            I2C.this.writeArray(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            I2C.this.writeArray(byArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
            I2C.this.drain();
        }
    }

    class I2CInputStream
    extends InputStream {
        I2CInputStream() {
        }

        @Override
        public int read() throws IOException {
            I2C.this.dataAvailable = 0;
            return I2C.this.readByte();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            I2C.this.dataAvailable = 0;
            int n4 = 0;
            int[] nArray = new int[]{byArray.length, I2C.this.InputBuffer, n2};
            for (n3 = 0; nArray[n3] == 0 && n3 < nArray.length; ++n3) {
            }
            n4 = nArray[n3];
            while (n3 < nArray.length) {
                if (nArray[n3] > 0) {
                    n4 = Math.min(n4, nArray[n3]);
                }
                ++n3;
            }
            if ((n4 = Math.min(n4, I2C.this.threshold)) == 0) {
                n4 = 1;
            }
            int n5 = this.available();
            int n6 = I2C.this.readArray(byArray, n, n4);
            return n6;
        }

        @Override
        public int available() throws IOException {
            return I2C.this.nativeavailable();
        }
    }

    class MonitorThread
    extends Thread {
        private boolean CTS = false;
        private boolean DSR = false;
        private boolean RI = false;
        private boolean CD = false;
        private boolean OE = false;
        private boolean PE = false;
        private boolean FE = false;
        private boolean BI = false;
        private boolean Data = false;
        private boolean Output = false;

        MonitorThread() {
        }

        @Override
        public void run() {
            I2C.this.eventLoop();
        }
    }
}

