## Some notes about the --keyboard-layout-mapping feature ##

This new configuration item was added to handle a special TrueCrypt and VeraCrypt "feature" which is automatically active during the setup of encryption for a system partition or an entire system drive. Due to BIOS requirements, the user's keyboard layout is always set to the US keyboard layout during the pre-boot stage (no matter which layout is actually in use). In other words, in the pre-boot stage, when TC/VC asks the user to enter the password, the layout is actually set to the US keyboard layout.

To avoid conflicts with the real keyboard layout configured in the OS, both TC and VC have a little trick: they set the OS keyboard layout to US keyboard layout while the password prompt window is opened. You can actually verify this in the language task bar while the password prompt window is open. It will switch from whatever is configured to English, and after the window is closed, the original keyboard layout is restored.

This has a serious impact on cracking the password. For example, my German keyboard layout is a "QWERTZ" keyboard layout. The US keyboard, however used a "QWERTY" layout. The difference is that the position of the "y" and "z" letter is exchanged. If it was just that, this wouldn't be much of a problem - but almost all the special symbols are mapped very differently. (I won't go into the details; you might want to compare it yourself for fun.)

And when it comes to non-Latin based languages, this behaviour gets completely out of control. Just one example: If the user enters the password بين التخصصات (interdisciplinary) on an Arabic keyboard, the password we need to guess is: fdk hgjowwhj[g.

To deal with all of this, a hashcat user needs to know exactly which keyboard was enabled when the password was entered into the password window during setup. For German, I've added an example keyboard layout to the newly created folder "layouts", which now ships with the binary and on GitHub master. For instance, if you know a German keyboard was used, you can now add "--keyboard-layout-mapping layouts/de.hckmap" to the commandline.

Unfortunately, since I don't own all of the existing keyboards, it will be necessary for hashcat users to contribute the rest of the missing mapping tables - ideally, as a GitHub PR. Almost every language I know has special keyboard layouts. There's even a difference between the UK and US layouts.

Here's how you can help. To create a language-specific mapping table, open a text editor, and press every key on the keyboard, starting from the top left to the top right. Press Enter after every key. Use only keys which represent a real character, and ignore control keys such as Backspace, Caps Lock, etc. Then move to the next row below and repeat the process from the left to the right, and so on until you reach the space character. At that point, repeat exactly the same sequence, but with Shift pressed. When done, add a Tab after each character (Tab is used as separator character). Then switch the keyboard layout to English and repeat the entire process exactly in the same order, adding each character after the tab character. Hashcat fully supports all multibyte characters up to 32 bits on both sides of the mapping table (even if the right side side will be always a single byte character). As an example, see the layouts/de.hckmap file.

Note that when it comes to Alt/AltGr, this behavior is exploitable. TC/VC does not accept those modifier keys. If a user uses AltGr while entering the password, a window appears that tells the user that the use of this key is not allowed. For instance, on my German keyboard layout, I need to use AltGr+q to get the "@" character. As a consequence of this, we know that the TC/VC password cannot include any of the characters ("@", "[", "]", "\", "€", "|", "{", "}", "~") if the user was using a German keyboard to enter the password.

At the same time, we can guarantee that "@" will never be listed on the left side of the mapping table - because the only characters that can appear there are the ones that are are reachable only without any modifier or by using shift (but not AltGr). If we combine these concepts, we could add some code to reject all passwords which contain at least one character not listed in a mapping table. This is not yet implemented - but I'll add it if hashcat users agree that there is value in it.
