/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import org.gradle.internal.jvm.Jvm;
import org.gradle.process.internal.health.memory.MBeanAttributeProvider;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusSnapshot;

public class MBeanOsMemoryInfo
implements OsMemoryInfo {
    private final MBeanAttributeProvider mBeanAttributeProvider;

    public MBeanOsMemoryInfo(MBeanAttributeProvider mBeanAttributeProvider) {
        this.mBeanAttributeProvider = mBeanAttributeProvider;
    }

    @Override
    public OsMemoryStatus getOsSnapshot() {
        String totalMemoryAttribute = Jvm.current().isIbmJvm() ? "TotalPhysicalMemory" : "TotalPhysicalMemorySize";
        long total = this.mBeanAttributeProvider.getMbeanAttribute("java.lang:type=OperatingSystem", totalMemoryAttribute, Long.class);
        long free = this.mBeanAttributeProvider.getMbeanAttribute("java.lang:type=OperatingSystem", "FreePhysicalMemorySize", Long.class);
        if (total == -1L) {
            throw new UnsupportedOperationException("Unable to retrieve total physical memory from MBean");
        }
        if (free == -1L) {
            throw new UnsupportedOperationException("Unable to retrieve free physical memory from MBean");
        }
        return new OsMemoryStatusSnapshot(total, free);
    }
}

