/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.components.HighlightablePropertyControl;
import org.freeplane.core.resources.components.PropertyAdapter;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.util.TextUtils;

public class SeparatorProperty
implements HighlightablePropertyControl {
    private static final AffineTransform FONT_TRANSFORM = AffineTransform.getScaleInstance(1.5, 1.5);
    private final String label;
    private final String name;
    private JComponent separator;
    private JLabel labelComponent;

    public SeparatorProperty(String name, String label) {
        this.name = name;
        this.label = label;
    }

    @Override
    public String getTooltip() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void appendToForm(DefaultFormBuilder builder) {
        block1: {
            Component child;
            Component[] componentArray;
            int n;
            int n2;
            String labelKey = this.getLabel();
            String text = TextUtils.getOptionalText(labelKey);
            if (builder.getColumn() > 1) {
                builder.nextLine();
            }
            this.separator = builder.appendSeparator(text);
            if (text == null || (n2 = 0) >= (n = (componentArray = this.separator.getComponents()).length) || !((child = componentArray[n2]) instanceof JLabel)) break block1;
            this.labelComponent = (JLabel)child;
            TranslatedElement.TEXT.setKey(this.labelComponent, labelKey);
            this.labelComponent.setFont(this.labelComponent.getFont().deriveFont(FONT_TRANSFORM));
        }
    }

    @Override
    public void setEnabled(boolean pEnabled) {
    }

    public void scrollRectToVisible() {
        Container viewport = SwingUtilities.getAncestorOfClass(JViewport.class, this.separator);
        if (viewport != null) {
            Rectangle bounds = new Rectangle(this.separator.getWidth(), viewport.getHeight());
            this.separator.scrollRectToVisible(bounds);
        }
    }

    @Override
    public void highlight() {
        if (this.labelComponent != null) {
            PropertyAdapter.highlight(this.labelComponent);
        }
        this.scrollRectToVisible();
    }
}

