from esphome.components.mipi import DriverChip, delay
from esphome.config_validation import UNDEFINED

from .st7701s import st7701s

# fmt: off
wave_4_3 = DriverChip(
    "ESP32-S3-TOUCH-LCD-4.3",
    swap_xy=UNDEFINED,
    initsequence=(),
    width=800,
    height=480,
    pclk_frequency="16MHz",
    reset_pin={"ch422g": None, "number": 3},
    enable_pin={"ch422g": None, "number": 2},
    de_pin=5,
    hsync_pin={"number": 46, "ignore_strapping_warning": True},
    vsync_pin={"number": 3, "ignore_strapping_warning": True},
    pclk_pin=7,
    pclk_inverted=True,
    hsync_front_porch=210,
    hsync_pulse_width=30,
    hsync_back_porch=30,
    vsync_front_porch=4,
    vsync_pulse_width=4,
    vsync_back_porch=4,
    data_pins={
        "red": [1, 2, 42, 41, 40],
        "green": [39, 0, 45, 48, 47, 21],
        "blue": [14, 38, 18, 17, 10],
    },
)

wave_4_3.extend(
    "WAVESHARE-5-1024X600",
    width=1024,
    height=600,
    hsync_back_porch=145,
    hsync_front_porch=170,
    hsync_pulse_width=30,
    vsync_back_porch=23,
    vsync_front_porch=12,
    vsync_pulse_width=2,
)

wave_4_3.extend(
    "ESP32-S3-TOUCH-LCD-7-800X480",
    enable_pin=[{"ch422g": None, "number": 2}, {"ch422g": None, "number": 6}],
    hsync_back_porch=8,
    hsync_front_porch=8,
    hsync_pulse_width=4,
    vsync_back_porch=16,
    vsync_front_porch=16,
    vsync_pulse_width=4,
)

st7701s.extend(
    "WAVESHARE-4-480X480",
    data_rate="2MHz",
    spi_mode="MODE3",
    pixel_mode="18bit",
    width=480,
    height=480,
    invert_colors=True,
    cs_pin=42,
    de_pin=40,
    hsync_pin=38,
    vsync_pin=39,
    pclk_pin=41,
    pclk_frequency="12MHz",
    pclk_inverted=False,
    data_pins={
        "red": [46, 3, 8, 18, 17],
        "green": [14, 13, 12, 11, 10, 9],
        "blue": [5, 45, 48, 47, 21],
    },
)

st7701s.extend(
    "WAVESHARE-3.16-320X820",
    width=320,
    height=820,
    de_pin=40,
    hsync_pin=38,
    vsync_pin=39,
    pclk_pin=41,
    cs_pin={
        "number": 0,
        "ignore_strapping_warning": True,
    },
    pclk_frequency="18MHz",
    reset_pin=16,
    hsync_back_porch=30,
    hsync_front_porch=30,
    hsync_pulse_width=6,
    vsync_back_porch=20,
    vsync_front_porch=20,
    vsync_pulse_width=40,
    data_pins={
        "red": [17, 46, 3, 8, 18],
        "green": [14, 13, 12, 11, 10, 9],
        "blue": [21, 5, 45, 48, 47],
    },
    initsequence=(
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x13),
        (0xEF, 0x08),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x10),
        (0xC0, 0xE5, 0x02),
        (0xC1, 0x15, 0x0A),
        (0xC2, 0x07, 0x02),
        (0xCC, 0x10),
        (0xB0, 0x00, 0x08, 0x51, 0x0D, 0xCE, 0x06, 0x00, 0x08, 0x08, 0x24, 0x05, 0xD0, 0x0F, 0x6F, 0x36, 0x1F),
        (0xB1, 0x00, 0x10, 0x4F, 0x0C, 0x11, 0x05, 0x00, 0x07, 0x07, 0x18, 0x02, 0xD3, 0x11, 0x6E, 0x34, 0x1F),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x11),
        (0xB0, 0x4D),
        (0xB1, 0x37),
        (0xB2, 0x87),
        (0xB3, 0x80),
        (0xB5, 0x4A),
        (0xB7, 0x85),
        (0xB8, 0x21),
        (0xB9, 0x00, 0x13),
        (0xC0, 0x09),
        (0xC1, 0x78),
        (0xC2, 0x78),
        (0xD0, 0x88),
        (0xE0, 0x80, 0x00, 0x02),
        (0xE1, 0x0F, 0xA0, 0x00, 0x00, 0x10, 0xA0, 0x00, 0x00, 0x00, 0x60, 0x60),
        (0xE2, 0x30, 0x30, 0x60, 0x60, 0x45, 0xA0, 0x00, 0x00, 0x46, 0xA0, 0x00, 0x00, 0x00),
        (0xE3, 0x00, 0x00, 0x33, 0x33),
        (0xE4, 0x44, 0x44),
        (0xE5, 0x0F, 0x4A, 0xA0, 0xA0, 0x11, 0x4A, 0xA0, 0xA0, 0x13, 0x4A, 0xA0, 0xA0, 0x15, 0x4A, 0xA0, 0xA0),
        (0xE6, 0x00, 0x00, 0x33, 0x33),
        (0xE7, 0x44, 0x44),
        (0xE8, 0x10, 0x4A, 0xA0, 0xA0, 0x12, 0x4A, 0xA0, 0xA0, 0x14, 0x4A, 0xA0, 0xA0, 0x16, 0x4A, 0xA0, 0xA0),
        (0xEB, 0x02, 0x00, 0x4E, 0x4E, 0xEE, 0x44, 0x00),
        (0xED, 0xFF, 0xFF, 0x04, 0x56, 0x72, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x27, 0x65, 0x40, 0xFF, 0xFF),
        (0xEF, 0x08, 0x08, 0x08, 0x40, 0x3F, 0x64),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x13),
        (0xE8, 0x00, 0x0E),
        (0xE8, 0x00, 0x0C),
        delay(10),
        (0xE8, 0x00, 0x00),
        (0xFF, 0x77, 0x01, 0x00, 0x00, 0x00),
    )
)
