/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.snippets;

import io.cucumber.core.snippets.Joiner;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class IdentifierGenerator {
    private static final String BETWEEN_LOWER_AND_UPPER = "(?<=\\p{Ll})(?=\\p{Lu})";
    private static final String BEFORE_UPPER_AND_LOWER = "(?<=\\p{L})(?=\\p{Lu}\\p{Ll})";
    private static final Pattern SPLIT_CAMEL_CASE = Pattern.compile("(?<=\\p{Ll})(?=\\p{Lu})|(?<=\\p{L})(?=\\p{Lu}\\p{Ll})");
    private static final Pattern SPLIT_WHITESPACE = Pattern.compile("\\s");
    private static final Pattern SPLIT_UNDERSCORE = Pattern.compile("_");
    private static final char SUBST = ' ';
    private final Joiner joiner;

    IdentifierGenerator(Joiner joiner) {
        this.joiner = joiner;
    }

    String generate(String sentence) {
        if (sentence.isEmpty()) {
            throw new IllegalArgumentException("Cannot create function name from empty sentence");
        }
        List<String> words = Stream.of(sentence).map(this::replaceIllegalCharacters).map(String::trim).flatMap(SPLIT_WHITESPACE::splitAsStream).flatMap(SPLIT_CAMEL_CASE::splitAsStream).flatMap(SPLIT_UNDERSCORE::splitAsStream).collect(Collectors.toList());
        return this.joiner.concatenate(words);
    }

    private String replaceIllegalCharacters(String sentence) {
        StringBuilder sanitized = new StringBuilder();
        sanitized.append(Character.isJavaIdentifierStart(sentence.charAt(0)) ? sentence.charAt(0) : (char)' ');
        for (int i = 1; i < sentence.length(); ++i) {
            if (Character.isJavaIdentifierPart(sentence.charAt(i))) {
                sanitized.append(sentence.charAt(i));
                continue;
            }
            if (sanitized.charAt(sanitized.length() - 1) == ' ' || i == sentence.length() - 1) continue;
            sanitized.append(' ');
        }
        return sanitized.toString();
    }
}

