/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.runner;

import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.ScenarioScoped;
import io.cucumber.core.runner.CamelCaseStringConverter;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import java.lang.reflect.Type;
import java.util.Map;

class CoreDefaultDataTableEntryTransformerDefinition
implements DefaultDataTableEntryTransformerDefinition {
    protected final DefaultDataTableEntryTransformerDefinition delegate;
    private final TableEntryByTypeTransformer transformer;

    private CoreDefaultDataTableEntryTransformerDefinition(DefaultDataTableEntryTransformerDefinition delegate) {
        this.delegate = delegate;
        TableEntryByTypeTransformer transformer = delegate.tableEntryByTypeTransformer();
        this.transformer = delegate.headersToProperties() ? new ConvertingTransformer(transformer) : transformer;
    }

    public static CoreDefaultDataTableEntryTransformerDefinition create(DefaultDataTableEntryTransformerDefinition definition) {
        if (definition instanceof ScenarioScoped) {
            return new ScenarioCoreDefaultDataTableEntryTransformerDefinition(definition);
        }
        return new CoreDefaultDataTableEntryTransformerDefinition(definition);
    }

    @Override
    public boolean headersToProperties() {
        return this.delegate.headersToProperties();
    }

    @Override
    public TableEntryByTypeTransformer tableEntryByTypeTransformer() {
        return this.transformer;
    }

    @Override
    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.delegate.isDefinedAt(stackTraceElement);
    }

    @Override
    public String getLocation() {
        return this.delegate.getLocation();
    }

    private static class ConvertingTransformer
    implements TableEntryByTypeTransformer {
        private final CamelCaseStringConverter converter = new CamelCaseStringConverter();
        private final TableEntryByTypeTransformer delegate;

        ConvertingTransformer(TableEntryByTypeTransformer delegate) {
            this.delegate = delegate;
        }

        public Object transform(Map<String, String> entryValue, Type toValueType, TableCellByTypeTransformer cellTransformer) throws Throwable {
            return this.delegate.transform(this.converter.toCamelCase(entryValue), toValueType, cellTransformer);
        }
    }

    private static class ScenarioCoreDefaultDataTableEntryTransformerDefinition
    extends CoreDefaultDataTableEntryTransformerDefinition
    implements ScenarioScoped {
        ScenarioCoreDefaultDataTableEntryTransformerDefinition(DefaultDataTableEntryTransformerDefinition delegate) {
            super(delegate);
        }

        @Override
        public void dispose() {
            if (this.delegate instanceof ScenarioScoped) {
                ScenarioScoped scenarioScoped = (ScenarioScoped)((Object)this.delegate);
                scenarioScoped.dispose();
            }
        }
    }
}

