/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.handlers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class TaskClearHistoryHandler
implements DBRRunnableWithProgress {
    private static final Log log = Log.getLog(TaskClearHistoryHandler.class);

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DBPProject project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        DBTTaskManager manager = project.getTaskManager();
        try {
            monitor.beginTask("Clear task run history", 2);
            monitor.subTask("Cancel running tasks");
            manager.cancelRunningTasks();
            monitor.worked(1);
            monitor.subTask("Delete task run records");
            Files.walkFileTree(manager.getStatisticsFolder(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    log.trace((Object)("Deleting " + String.valueOf(file)));
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    log.trace((Object)("Deleting " + String.valueOf(dir)));
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            monitor.worked(1);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
        }
    }
}

