/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;

public class RenamedDataEntryWriter
implements DataEntryWriter {
    private final ClassPool classPool;
    private final Map packagePrefixMap;
    private final DataEntryWriter dataEntryWriter;

    public RenamedDataEntryWriter(ClassPool classPool, Map packagePrefixMap, DataEntryWriter dataEntryWriter) {
        this.classPool = classPool;
        this.packagePrefixMap = packagePrefixMap;
        this.dataEntryWriter = dataEntryWriter;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(this.renamedDataEntry(dataEntry));
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createOutputStream(this.renamedDataEntry(dataEntry));
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter pw, String prefix) {
        this.dataEntryWriter.println(pw, prefix);
    }

    private DataEntry renamedDataEntry(DataEntry dataEntry) {
        String dataEntryName = dataEntry.getName();
        for (int suffixIndex = dataEntryName.length() - 1; suffixIndex > 0; --suffixIndex) {
            char c = dataEntryName.charAt(suffixIndex);
            if (Character.isLetterOrDigit(c)) continue;
            String className = dataEntryName.substring(0, suffixIndex);
            if (c == '/') break;
            Clazz clazz = this.classPool.getClass(className);
            if (clazz == null) continue;
            String newClassName = clazz.getName();
            if (!className.equals(newClassName)) {
                String newDataEntryName = newClassName + dataEntryName.substring(suffixIndex);
                return new RenamedDataEntry(dataEntry, newDataEntryName);
            }
            return dataEntry;
        }
        String packagePrefix = dataEntryName;
        do {
            String newPackagePrefix;
            if ((newPackagePrefix = (String)this.packagePrefixMap.get(packagePrefix = ClassUtil.internalPackagePrefix(packagePrefix))) == null) continue;
            if (!packagePrefix.equals(newPackagePrefix)) {
                String newDataEntryName = newPackagePrefix + dataEntryName.substring(packagePrefix.length());
                return new RenamedDataEntry(dataEntry, newDataEntryName);
            }
            return dataEntry;
        } while (packagePrefix.length() > 0);
        return dataEntry;
    }
}

