/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.wicket.Page;
import org.apache.wicket.markup.head.PageHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.ResourceAggregator;

public class PriorityFirstComparator
implements Comparator<ResourceAggregator.RecordedHeaderItem>,
Serializable {
    private final boolean renderPageFirst;

    public PriorityFirstComparator(boolean renderPageFirst) {
        this.renderPageFirst = renderPageFirst;
    }

    @Override
    public int compare(ResourceAggregator.RecordedHeaderItem o1, ResourceAggregator.RecordedHeaderItem o2) {
        HeaderItemType o2Type;
        HeaderItemType o1Type = this.getItemType(o1);
        if (o1Type != (o2Type = this.getItemType(o2))) {
            return o1Type.ordinal() - o2Type.ordinal();
        }
        if (o1Type == HeaderItemType.PRIORITY) {
            return this.inversedComponentOrder(o1, o2);
        }
        return this.compareWithinGroup(o1, o2);
    }

    protected int compareWithinGroup(ResourceAggregator.RecordedHeaderItem item1, ResourceAggregator.RecordedHeaderItem item2) {
        return 0;
    }

    protected int inversedComponentOrder(ResourceAggregator.RecordedHeaderItem item1, ResourceAggregator.RecordedHeaderItem item2) {
        return item1.getMinDepth() - item2.getMinDepth();
    }

    protected HeaderItemType getItemType(ResourceAggregator.RecordedHeaderItem item) {
        if (item.getItem() instanceof PriorityHeaderItem) {
            return HeaderItemType.PRIORITY;
        }
        if (this.renderPageFirst) {
            if (item.getItem() instanceof PageHeaderItem) {
                return HeaderItemType.PAGE;
            }
            for (ResourceAggregator.RecordedHeaderItemLocation curLocation : item.getLocations()) {
                if (!(curLocation.getRenderBase() instanceof Page)) continue;
                return HeaderItemType.PAGE;
            }
        }
        return HeaderItemType.COMPONENT;
    }

    protected static enum HeaderItemType {
        PRIORITY,
        PAGE,
        COMPONENT;

    }
}

