/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxSubmitLink
extends AbstractSubmitLink {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AjaxSubmitLink.class);
    private final Form<?> form;

    public AjaxSubmitLink(String id) {
        this(id, (Form<?>)null);
    }

    public AjaxSubmitLink(String id, Form<?> form) {
        super(id, form);
        this.form = form;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxFormSubmitBehavior("click"));
    }

    protected AjaxFormSubmitBehavior newAjaxFormSubmitBehavior(String event) {
        return new AjaxFormSubmitBehavior(this.form, event){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onError(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onError(target);
            }

            @Override
            protected Form<?> findForm() {
                return AjaxSubmitLink.this.getForm();
            }

            @Override
            public boolean getDefaultProcessing() {
                return AjaxSubmitLink.this.getDefaultFormProcessing();
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                attributes.setPreventDefault(true);
                super.updateAjaxAttributes(attributes);
                AjaxSubmitLink.this.updateAjaxAttributes(attributes);
            }

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onSubmit(target);
            }

            @Override
            protected void onAfterSubmit(AjaxRequestTarget target) {
                AjaxSubmitLink.this.onAfterSubmit(target);
            }

            @Override
            public boolean getStatelessHint(Component component) {
                return AjaxSubmitLink.this.getStatelessHint();
            }
        };
    }

    protected void onSubmit(AjaxRequestTarget target) {
    }

    protected void onAfterSubmit(AjaxRequestTarget target) {
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isEnabledInHierarchy()) {
            String tagName = tag.getName();
            if (tagName.equalsIgnoreCase("a") || tagName.equalsIgnoreCase("link") || tagName.equalsIgnoreCase("area")) {
                tag.put("href", "#");
            } else if (tagName.equalsIgnoreCase("button")) {
                tag.put("type", "button");
            } else if (tagName.equalsIgnoreCase("input") && "submit".equalsIgnoreCase(tag.getAttribute("type"))) {
                tag.getAttributes().put("type", "button");
            }
        } else {
            this.disableLink(tag);
        }
    }

    @Override
    public final void onError() {
        logger.warn("unexpected invocation of #onError() on {}", (Object)this);
    }

    protected void onError(AjaxRequestTarget target) {
    }

    @Override
    public final void onSubmit() {
        logger.warn("unexpected invocation of #onSubmit() on {}", (Object)this);
    }

    @Override
    public final void onAfterSubmit() {
        logger.warn("unexpected invocation of #onAfterSubmit() on {}", (Object)this);
    }

    @Override
    protected boolean getStatelessHint() {
        return false;
    }
}

