/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import org.apache.openjpa.jdbc.meta.strats.NumberVersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.JavaTypes;

public class MultiColumnVersionStrategy
extends NumberVersionStrategy {
    private static final long serialVersionUID = 1L;
    public static final String ALIAS = "version-numbers";
    private Number[] _initials = null;
    private Integer[] _javaTypes;

    @Override
    public void initialize() {
        if (this._initials == null) {
            Column[] cols = this.vers.getColumns();
            this._initials = new Number[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                this._initials[i] = this.nextValue(0, this.getJavaType(i));
            }
        }
        super.initialize();
    }

    public void setInitialValues(Number[] initial) {
        this._initials = new Number[initial.length];
        System.arraycopy(initial, 0, this._initials, 0, initial.length);
    }

    public Number[] getInitialValues() {
        return this._initials;
    }

    @Override
    public String getAlias() {
        return ALIAS;
    }

    @Override
    protected int getJavaType() {
        return 11;
    }

    @Override
    protected int getJavaType(int i) {
        if (this._javaTypes == null) {
            this._javaTypes = new Integer[this.vers.getMappingInfo().getColumns().size()];
        }
        if (this._javaTypes[i] == null) {
            Column col = this.vers.getMappingInfo().getColumns().get(i);
            if (!StringUtil.isEmpty(col.getTypeName())) {
                Class<?> javaType = Schemas.getJavaType(col.getType(), col.getSize(), col.getDecimalDigits());
                this._javaTypes[i] = JavaTypes.getTypeCode(javaType);
            } else {
                this._javaTypes[i] = 5;
            }
        }
        return this._javaTypes[i];
    }

    @Override
    protected Object nextVersion(Object version) {
        if (version == null) {
            return this._initials;
        }
        Object[] values = (Object[])version;
        Number[] result = new Number[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.nextValue(values[i], this.getJavaType(i));
        }
        return result;
    }

    Number nextValue(Object number, int javaTypeCode) {
        Integer result = number == null ? 1 : ((Number)number).intValue() + 1;
        return (Number)JavaTypes.convert(String.valueOf(result), javaTypeCode);
    }
}

