/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.cluster;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.catalina.ha.ClusterMessageBase;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.TomEERuntimeException;

public class DeployMessage
extends ClusterMessageBase {
    public static final String TOMEE_CLUSTER_DEPLOY_SEND_ARCHIVE = "tomee.cluster.deploy.send-archive";
    private String file;
    private byte[] archive;

    public DeployMessage(String path) {
        this.file = path;
        if (SystemInstance.get().getOptions().get(TOMEE_CLUSTER_DEPLOY_SEND_ARCHIVE, false)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(path);
                IO.copy((InputStream)fis, (OutputStream)baos);
                this.archive = baos.toByteArray();
            }
            catch (Exception e) {
                try {
                    throw new TomEERuntimeException(e);
                }
                catch (Throwable throwable) {
                    IO.close(fis);
                    IO.close((Closeable)baos);
                    throw throwable;
                }
            }
            IO.close((Closeable)fis);
            IO.close((Closeable)baos);
        }
    }

    public String getFile() {
        return this.file;
    }

    public byte[] getArchive() {
        return this.archive;
    }

    public String getUniqueId() {
        return "DEPLOY-" + this.file;
    }
}

