/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.impl.BaseTrustEngineSecurityHandler;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;

public abstract class BaseSAMLXMLSignatureSecurityHandler
extends BaseTrustEngineSecurityHandler<Signature> {
    @Nullable
    private SAMLPeerEntityContext peerContext;
    @Nullable
    private SAMLProtocolContext samlProtocolContext;
    @Nullable
    private String samlProtocol;
    @Nullable
    private QName samlRole;
    @Nullable
    private SignatureValidationParameters signatureValidationParameters;

    @Nullable
    protected SAMLPeerEntityContext getSAMLPeerEntityContext() {
        return this.peerContext;
    }

    @Nullable
    protected SAMLProtocolContext getSAMLProtocolContext() {
        return this.samlProtocolContext;
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.peerContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        QName qName = this.samlRole = this.peerContext != null ? this.peerContext.getRole() : null;
        if (this.samlRole == null) {
            throw new MessageHandlerException("SAMLPeerEntityContext was missing or unpopulated");
        }
        this.samlProtocolContext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class);
        String string = this.samlProtocol = this.samlProtocolContext != null ? this.samlProtocolContext.getProtocol() : null;
        if (this.samlProtocol == null) {
            throw new MessageHandlerException("SAMLProtocolContext was missing or unpopulated");
        }
        if (this.signatureValidationParameters == null) {
            SecurityParametersContext secParams = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class);
            this.signatureValidationParameters = secParams != null ? secParams.getSignatureValidationParameters() : null;
        }
        return true;
    }

    @Nullable
    protected TrustEngine<Signature> resolveTrustEngine(@Nonnull MessageContext messageContext) {
        if (this.signatureValidationParameters == null) {
            SecurityParametersContext secParams = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class);
            SignatureValidationParameters signatureValidationParameters = this.signatureValidationParameters = secParams != null ? secParams.getSignatureValidationParameters() : null;
        }
        if (this.signatureValidationParameters != null) {
            return this.signatureValidationParameters.getSignatureTrustEngine();
        }
        return null;
    }

    @Nonnull
    protected CriteriaSet buildCriteriaSet(@Nullable String entityID, @Nonnull MessageContext messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!Strings.isNullOrEmpty((String)entityID)) {
            assert (entityID != null);
            criteriaSet.add((Object)new EntityIdCriterion(entityID));
        }
        assert (this.samlRole != null);
        criteriaSet.add((Object)new EntityRoleCriterion(this.samlRole));
        assert (this.samlProtocol != null);
        criteriaSet.add((Object)new ProtocolCriterion(this.samlProtocol));
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        if (this.signatureValidationParameters != null) {
            criteriaSet.add((Object)new SignatureValidationParametersCriterion(this.signatureValidationParameters));
        }
        return criteriaSet;
    }
}

