/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.util.Arrays;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.slice.SliceImplHelper;
import org.apache.openjpa.slice.SliceInfo;
import org.apache.openjpa.util.ImplHelper;

public class SlicePersistence {
    public static final String HINT_TARGET = "openjpa.hint.slice.Target";

    public static String getSlice(Object obj) {
        if (obj == null) {
            return null;
        }
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, null);
        if (pc == null) {
            return null;
        }
        OpenJPAStateManager sm = (OpenJPAStateManager)pc.pcGetStateManager();
        SliceInfo info = SliceImplHelper.getSliceInfo(sm);
        if (info == null) {
            return null;
        }
        Object[] names = info.getSlices();
        return info.isReplicated() ? Arrays.toString(names) : names[0];
    }

    public static boolean isReplicated(Object obj) {
        if (obj == null) {
            return false;
        }
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(obj, null);
        if (pc == null) {
            return false;
        }
        OpenJPAStateManager sm = (OpenJPAStateManager)pc.pcGetStateManager();
        SliceInfo info = SliceImplHelper.getSliceInfo(sm);
        if (info == null) {
            return false;
        }
        return info.isReplicated();
    }
}

