/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.cdi;

import jakarta.batch.operations.BatchRuntimeException;
import jakarta.batch.operations.JobOperator;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.batchee.container.cdi.BatchProducerBean;
import org.apache.batchee.container.cdi.JobOpProducerBean;

public class BatchCDIInjectionExtension
implements Extension {
    private static final Logger logger;
    private static final boolean CDI_1_1_AVAILABLE;
    private static final Method CDI_CURRENT_METHOD;
    private static final Method CDI_GET_BEAN_MANAGER_METHOD;
    private static BatchCDIInjectionExtension bmpSingleton;
    private volatile Map<ClassLoader, BeanManagerInfo> bmInfos = new ConcurrentHashMap<ClassLoader, BeanManagerInfo>();
    private Boolean foundJobOp = false;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        bbd.addAnnotatedType(bm.createAnnotatedType(BatchProducerBean.class), BatchProducerBean.class.getSimpleName());
    }

    public void setBeanManager(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (bmpSingleton == null) {
            bmpSingleton = this;
        }
        if (!CDI_1_1_AVAILABLE) {
            BeanManagerInfo bmi = this.getBeanManagerInfo(BatchCDIInjectionExtension.loader());
            bmi.loadTimeBm = beanManager;
        }
    }

    public void cleanupFinalBeanManagers(@Observes AfterDeploymentValidation adv) {
        if (!CDI_1_1_AVAILABLE) {
            for (BeanManagerInfo bmi : BatchCDIInjectionExtension.bmpSingleton.bmInfos.values()) {
                bmi.finalBm = null;
            }
        }
    }

    public void cleanupStoredBeanManagerOnShutdown(@Observes BeforeShutdown beforeShutdown) {
        if (CDI_1_1_AVAILABLE || bmpSingleton == null) {
            return;
        }
        BatchCDIInjectionExtension.bmpSingleton.bmInfos.remove(BatchCDIInjectionExtension.loader());
    }

    private static ClassLoader loader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static BatchCDIInjectionExtension getInstance() {
        return bmpSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanManager getBeanManager() {
        if (CDI_1_1_AVAILABLE) {
            try {
                return (BeanManager)CDI_GET_BEAN_MANAGER_METHOD.invoke(CDI_CURRENT_METHOD.invoke(null, new Object[0]), new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException && e.getCause() instanceof IllegalStateException) {
                    return null;
                }
                throw new BatchRuntimeException("unable to resolve BeanManager");
            }
        }
        BeanManagerInfo bmi = this.getBeanManagerInfo(BatchCDIInjectionExtension.loader());
        BeanManager result = bmi.finalBm;
        if (result == null && bmi.cdi == null) {
            BatchCDIInjectionExtension batchCDIInjectionExtension = this;
            synchronized (batchCDIInjectionExtension) {
                result = BatchCDIInjectionExtension.resolveBeanManagerViaJndi();
                if (result == null) {
                    result = bmi.loadTimeBm;
                }
                if (result == null) {
                    bmi.cdi = false;
                    return null;
                }
                bmi.cdi = true;
                bmi.finalBm = result;
            }
        }
        return result;
    }

    private static BeanManager resolveBeanManagerViaJndi() {
        try {
            return (BeanManager)BeanManager.class.cast(new InitialContext().lookup("java:comp/BeanManager"));
        }
        catch (NamingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanManagerInfo getBeanManagerInfo(ClassLoader cl) {
        BeanManagerInfo bmi = BatchCDIInjectionExtension.bmpSingleton.bmInfos.get(cl);
        if (bmi == null) {
            BatchCDIInjectionExtension batchCDIInjectionExtension = this;
            synchronized (batchCDIInjectionExtension) {
                for (ClassLoader key : BatchCDIInjectionExtension.bmpSingleton.bmInfos.keySet()) {
                    if (key.getParent() != cl) continue;
                    return BatchCDIInjectionExtension.bmpSingleton.bmInfos.get(key);
                }
                bmi = BatchCDIInjectionExtension.bmpSingleton.bmInfos.get(cl);
                if (bmi == null) {
                    bmi = new BeanManagerInfo();
                    BatchCDIInjectionExtension.bmpSingleton.bmInfos.put(cl, bmi);
                }
            }
        }
        return bmi;
    }

    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        if (!this.foundJobOp.booleanValue() && processBeanEvent.getBean().getTypes().contains(JobOperator.class)) {
            if (processBeanEvent.getBean().getBeanClass().equals(JobOpProducerBean.class)) {
                logger.log(Level.FINE, "BatchCDIInjectionExtension.processBean() detecting our own JobOpProducerBean");
            } else {
                logger.log(Level.FINE, "BatchCDIInjectionExtension.processBean() Found JobOperator of class: " + processBeanEvent.getBean().getBeanClass());
                this.foundJobOp = true;
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (this.foundJobOp.booleanValue()) {
            logger.log(Level.FINE, "Deferring to other detected JobOperator Bean");
            return;
        }
        logger.log(Level.FINE, "Didn't find JobOperator Bean, registering one");
        abd.addBean((Bean)new JobOpProducerBean(bm));
    }

    static {
        boolean cdi11Available;
        Method getBmMethod;
        Method currentMethod;
        logger = Logger.getLogger(BatchCDIInjectionExtension.class.getName());
        bmpSingleton = null;
        try {
            Class<?> cdi = Class.forName("jakarta.enterprise.inject.spi.CDI", false, BatchCDIInjectionExtension.loader());
            currentMethod = cdi.getDeclaredMethod("current", new Class[0]);
            getBmMethod = cdi.getDeclaredMethod("getBeanManager", new Class[0]);
            cdi11Available = true;
        }
        catch (Exception e) {
            currentMethod = null;
            getBmMethod = null;
            cdi11Available = false;
        }
        CDI_CURRENT_METHOD = currentMethod;
        CDI_GET_BEAN_MANAGER_METHOD = getBmMethod;
        CDI_1_1_AVAILABLE = cdi11Available;
    }

    private static class BeanManagerInfo {
        private BeanManager loadTimeBm = null;
        private BeanManager finalBm = null;
        private Boolean cdi = null;

        private BeanManagerInfo() {
        }
    }
}

