/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Flowable5CompatibilityContext;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;

public class Flowable5Util {
    public static final String V5_ENGINE_TAG = "v5";

    public static boolean isJobHandledByV5Engine(JobInfo jobInfo) {
        if (!(jobInfo instanceof Job)) {
            return false;
        }
        final Job job = (Job)jobInfo;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        boolean isFlowable5ProcessDefinition = Flowable5Util.isFlowable5ProcessDefinitionId(processEngineConfiguration, job.getProcessDefinitionId());
        if (isFlowable5ProcessDefinition) {
            return (Boolean)processEngineConfiguration.getCommandExecutor().execute((Command)new Command<Boolean>(){

                public Boolean execute(CommandContext commandContext) {
                    CommandContextUtil.getProcessEngineConfiguration(commandContext).getFlowable5CompatibilityHandler().executeJobWithLockAndRetry(job);
                    return true;
                }
            });
        }
        return false;
    }

    public static boolean isFlowable5ProcessDefinitionId(CommandContext commandContext, String processDefinitionId) {
        if (processDefinitionId == null) {
            return false;
        }
        try {
            ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
            if (processDefinition == null) {
                return false;
            }
            return Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext);
        }
        catch (FlowableObjectNotFoundException e) {
            return false;
        }
    }

    public static boolean isFlowable5ProcessDefinitionId(ProcessEngineConfigurationImpl processEngineConfiguration, final String processDefinitionId) {
        if (processDefinitionId == null) {
            return false;
        }
        ProcessDefinitionCacheEntry cacheEntry = (ProcessDefinitionCacheEntry)processEngineConfiguration.getProcessDefinitionCache().get(processDefinitionId);
        if (cacheEntry != null) {
            ProcessDefinition processDefinition = cacheEntry.getProcessDefinition();
            return Flowable5Util.isFlowable5ProcessDefinition(processDefinition, processEngineConfiguration);
        }
        return (Boolean)processEngineConfiguration.getCommandExecutor().execute((Command)new Command<Boolean>(){

            public Boolean execute(CommandContext commandContext) {
                return Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, processDefinitionId);
            }
        });
    }

    public static boolean isFlowable5Deployment(Deployment deployment, CommandContext commandContext) {
        return Flowable5Util.isFlowable5Deployment(deployment, CommandContextUtil.getProcessEngineConfiguration(commandContext));
    }

    public static boolean isFlowable5Deployment(Deployment deployment, ProcessEngineConfigurationImpl processEngineConfiguration) {
        return Flowable5Util.isV5Entity(deployment.getEngineVersion(), deployment.getId(), "deployment", processEngineConfiguration);
    }

    public static boolean isFlowable5ProcessDefinition(ProcessDefinition processDefinition, CommandContext commandContext) {
        return Flowable5Util.isFlowable5ProcessDefinition(processDefinition, CommandContextUtil.getProcessEngineConfiguration(commandContext));
    }

    public static boolean isFlowable5ProcessDefinition(ProcessDefinition processDefinition, ProcessEngineConfigurationImpl processEngineConfiguration) {
        return Flowable5Util.isV5Entity(processDefinition.getEngineVersion(), processDefinition.getId(), "process definition", processEngineConfiguration);
    }

    public static boolean isV5Entity(String tag, String id, String entityType, ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (Flowable5Util.isVersion5Tag(tag)) {
            if (!processEngineConfiguration.isFlowable5CompatibilityEnabled() || processEngineConfiguration.getFlowable5CompatibilityHandler() == null) {
                throw new FlowableException(entityType + " with id " + id + " has a v5 tag and flowable 5 compatibility is not enabled");
            }
            return true;
        }
        if (tag != null) {
            throw new FlowableException("Invalid 'engine' for " + entityType + " with id " + id + " : " + tag);
        }
        return false;
    }

    public static boolean isVersion5Tag(String tag) {
        return V5_ENGINE_TAG.equals(tag) || "activiti-5".equals(tag);
    }

    public static Flowable5CompatibilityHandler getFlowable5CompatibilityHandler() {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        Flowable5CompatibilityHandler flowable5CompatibilityHandler = null;
        if (processEngineConfiguration != null) {
            flowable5CompatibilityHandler = processEngineConfiguration.getFlowable5CompatibilityHandler();
        }
        if (flowable5CompatibilityHandler == null) {
            flowable5CompatibilityHandler = Flowable5CompatibilityContext.getFallbackFlowable5CompatibilityHandler();
        }
        if (flowable5CompatibilityHandler == null) {
            throw new FlowableException("Found Flowable 5 process definition, but no compatibility handler on the classpath");
        }
        return flowable5CompatibilityHandler;
    }
}

