/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity.data.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.HistoricProcessInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityImpl;
import org.flowable.engine.impl.persistence.entity.data.AbstractProcessDataManager;
import org.flowable.engine.impl.persistence.entity.data.HistoricProcessInstanceDataManager;

public class MybatisHistoricProcessInstanceDataManager
extends AbstractProcessDataManager<HistoricProcessInstanceEntity>
implements HistoricProcessInstanceDataManager {
    public MybatisHistoricProcessInstanceDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends HistoricProcessInstanceEntity> getManagedEntityClass() {
        return HistoricProcessInstanceEntityImpl.class;
    }

    public HistoricProcessInstanceEntity create() {
        return new HistoricProcessInstanceEntityImpl();
    }

    @Override
    public HistoricProcessInstanceEntity create(ExecutionEntity processInstanceExecutionEntity) {
        return new HistoricProcessInstanceEntityImpl(processInstanceExecutionEntity);
    }

    @Override
    public List<String> findHistoricProcessInstanceIdsByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectList("selectHistoricProcessInstanceIdsByProcessDefinitionId", (Object)processDefinitionId);
    }

    @Override
    public List<HistoricProcessInstance> findHistoricProcessInstancesBySuperProcessInstanceId(String superProcessInstanceId) {
        return this.getDbSqlSession().selectList("selectHistoricProcessInstanceIdsBySuperProcessInstanceId", (Object)superProcessInstanceId);
    }

    @Override
    public List<String> findHistoricProcessInstanceIdsBySuperProcessInstanceIds(Collection<String> superProcessInstanceIds) {
        return this.getDbSqlSession().selectList("selectHistoricProcessInstanceIdsBySuperProcessInstanceIds", (Object)this.createSafeInValuesList(superProcessInstanceIds));
    }

    @Override
    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.setSafeInValueLists(historicProcessInstanceQuery);
        return (Long)this.getDbSqlSession().selectOne("selectHistoricProcessInstanceCountByQueryCriteria", (Object)historicProcessInstanceQuery);
    }

    @Override
    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.setSafeInValueLists(historicProcessInstanceQuery);
        return this.getDbSqlSession().selectList("selectHistoricProcessInstancesByQueryCriteria", (ListQueryParameterObject)historicProcessInstanceQuery, this.getManagedEntityClass());
    }

    @Override
    public List<HistoricProcessInstance> findHistoricProcessInstancesAndVariablesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.setSafeInValueLists(historicProcessInstanceQuery);
        return this.getDbSqlSession().selectList("selectHistoricProcessInstancesWithVariablesByQueryCriteria", (ListQueryParameterObject)historicProcessInstanceQuery, this.getManagedEntityClass());
    }

    @Override
    public List<HistoricProcessInstance> findHistoricProcessInstancesByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricProcessInstanceByNativeQuery", parameterMap);
    }

    @Override
    public long findHistoricProcessInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricProcessInstanceCountByNativeQuery", parameterMap);
    }

    @Override
    public void deleteHistoricProcessInstances(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        this.getDbSqlSession().delete("bulkDeleteHistoricProcessInstances", (Object)historicProcessInstanceQuery, HistoricProcessInstanceEntityImpl.class);
    }

    @Override
    public void bulkDeleteHistoricProcessInstances(Collection<String> processInstanceIds) {
        this.getDbSqlSession().delete("bulkDeleteHistoricProcessInstancesByIds", (Object)this.createSafeInValuesList(processInstanceIds), HistoricProcessInstanceEntityImpl.class);
    }

    protected void setSafeInValueLists(HistoricProcessInstanceQueryImpl processInstanceQuery) {
        if (processInstanceQuery.getInvolvedGroups() != null) {
            processInstanceQuery.setSafeInvolvedGroups(this.createSafeInValuesList(processInstanceQuery.getInvolvedGroups()));
        }
        if (processInstanceQuery.getOrQueryObjects() != null && !processInstanceQuery.getOrQueryObjects().isEmpty()) {
            for (HistoricProcessInstanceQueryImpl orProcessInstanceQuery : processInstanceQuery.getOrQueryObjects()) {
                this.setSafeInValueLists(orProcessInstanceQuery);
            }
        }
    }
}

