/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityManager;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class SubProcessInstanceStartHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public SubProcessInstanceStartHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("subprocess-instance-start");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        String activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId");
        HistoricActivityInstanceEntity activityInstance = this.findHistoricActivityInstance(commandContext, AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"), activityId);
        return activityInstance != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String executionId;
        HistoricActivityInstanceEntity activityInstance;
        HistoricProcessInstanceEntityManager historicProcessInstanceEntityManager = this.processEngineConfiguration.getHistoricProcessInstanceEntityManager();
        String id = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id");
        String processInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId");
        HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)historicProcessInstanceEntityManager.findById(id);
        if (historicProcessInstance == null) {
            HistoricProcessInstanceEntity subProcessInstance = historicProcessInstanceEntityManager.create();
            subProcessInstance.setId(id);
            subProcessInstance.setProcessInstanceId(processInstanceId);
            subProcessInstance.setBusinessKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"businessKey"));
            subProcessInstance.setBusinessStatus(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"businessStatus"));
            subProcessInstance.setProcessDefinitionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionId"));
            subProcessInstance.setProcessDefinitionKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionKey"));
            subProcessInstance.setProcessDefinitionName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionName"));
            String versionString = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processDefinitionVersion");
            subProcessInstance.setProcessDefinitionVersion(versionString != null ? Integer.valueOf(versionString) : 0);
            subProcessInstance.setDeploymentId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deploymentId"));
            subProcessInstance.setStartTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"startTime"));
            subProcessInstance.setStartUserId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"startUserId"));
            subProcessInstance.setStartActivityId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"startActivityId"));
            subProcessInstance.setSuperProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"superProcessInstanceId"));
            subProcessInstance.setCallbackId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"callbackId"));
            subProcessInstance.setCallbackType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"callbackType"));
            subProcessInstance.setReferenceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"referenceId"));
            subProcessInstance.setReferenceType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"referenceType"));
            subProcessInstance.setPropagatedStageInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"propagatedStageInstanceId"));
            subProcessInstance.setTenantId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"tenantId"));
            historicProcessInstanceEntityManager.insert(subProcessInstance, false);
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_CREATED, subProcessInstance));
        }
        if ((activityInstance = this.findHistoricActivityInstance(commandContext, executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"), activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId"))) != null) {
            activityInstance.setCalledProcessInstanceId(processInstanceId);
        }
    }
}

