/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import java.security.AccessControlException;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ErrorTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class RestClientExceptionMapper
implements ResponseExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientExceptionMapper.class);

    public Exception fromResponse(Response response) {
        int statusCode = response.getStatus();
        String message = response.getHeaderString("X-Application-Error-Info");
        SyncopeClientCompositeException scce = RestClientExceptionMapper.checkSyncopeClientCompositeException(response);
        Object ex = scce != null ? (scce.getExceptions().size() == 1 ? (Exception)scce.getExceptions().iterator().next() : scce) : (statusCode == Response.Status.UNAUTHORIZED.getStatusCode() ? new AccessControlException(StringUtils.isBlank((CharSequence)message) ? "Remote unauthorized exception" : message) : (statusCode == Response.Status.FORBIDDEN.getStatusCode() ? new ForbiddenException(StringUtils.isBlank((CharSequence)message) ? "Remote forbidden exception" : message) : (statusCode == Response.Status.BAD_REQUEST.getStatusCode() ? (StringUtils.isBlank((CharSequence)message) ? new BadRequestException() : new BadRequestException(message)) : new WebServiceException(String.format("Remote exception with status code: %s", Response.Status.fromStatusCode((int)statusCode).name())))));
        LOG.error("Exception thrown", (Throwable)ex);
        return ex;
    }

    private static SyncopeClientCompositeException checkSyncopeClientCompositeException(Response response) {
        SyncopeClientCompositeException compException = SyncopeClientException.buildComposite();
        List errors = null;
        try {
            ErrorTO error = (ErrorTO)response.readEntity(ErrorTO.class);
            if (error != null) {
                errors = List.of(error);
            }
        }
        catch (Exception e) {
            LOG.debug("Could not read {}, attempting to read composite...", (Object)ErrorTO.class.getName(), (Object)e);
        }
        if (errors == null) {
            try {
                errors = (List)response.readEntity((GenericType)new GenericType<List<ErrorTO>>(){});
            }
            catch (Exception e) {
                LOG.debug("Could not read {} list, attempting to read headers...", (Object)ErrorTO.class.getName(), (Object)e);
            }
        }
        if (errors == null) {
            List exTypesInHeaders = (List)response.getStringHeaders().get((Object)"X-Application-Error-Code");
            if (exTypesInHeaders == null) {
                LOG.debug("No X-Application-Error-Code provided");
                return null;
            }
            List exInfos = (List)response.getStringHeaders().get((Object)"X-Application-Error-Info");
            HashSet handledExceptions = new HashSet();
            exTypesInHeaders.forEach(exTypeAsString -> {
                ClientExceptionType exceptionType = null;
                try {
                    exceptionType = ClientExceptionType.fromHeaderValue((String)exTypeAsString);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Unexpected value of X-Application-Error-Code: " + exTypeAsString, (Throwable)e);
                }
                if (exceptionType != null) {
                    handledExceptions.add(exTypeAsString);
                    SyncopeClientException clientException = SyncopeClientException.build((ClientExceptionType)exceptionType);
                    if (exInfos != null && !exInfos.isEmpty()) {
                        for (String element : exInfos) {
                            if (!element.startsWith(exceptionType.name())) continue;
                            clientException.getElements().add(StringUtils.substringAfter((String)element, (String)":"));
                        }
                    }
                    compException.addException(clientException);
                }
            });
            exTypesInHeaders.removeAll(handledExceptions);
            if (!exTypesInHeaders.isEmpty()) {
                LOG.error("Unmanaged exceptions: " + String.valueOf(exTypesInHeaders));
            }
        } else {
            for (ErrorTO error : errors) {
                SyncopeClientException clientException = SyncopeClientException.build((ClientExceptionType)error.getType());
                clientException.getElements().addAll(error.getElements());
                compException.addException(clientException);
            }
        }
        if (compException.hasExceptions()) {
            return compException;
        }
        return null;
    }
}

