/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCJWKSDAO;
import org.apache.syncope.core.persistence.api.entity.am.OIDCJWKS;
import org.apache.syncope.core.provisioning.api.data.OIDCJWKSDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class OIDCJWKSLogic
extends AbstractTransactionalLogic<OIDCJWKSTO> {
    protected final OIDCJWKSDataBinder binder;
    protected final OIDCJWKSDAO dao;

    public OIDCJWKSLogic(OIDCJWKSDataBinder binder, OIDCJWKSDAO dao) {
        this.binder = binder;
        this.dao = dao;
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_READ') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public OIDCJWKSTO get() {
        return Optional.ofNullable(this.dao.get()).map(arg_0 -> ((OIDCJWKSDataBinder)this.binder).getOIDCJWKSTO(arg_0)).orElseThrow(() -> new NotFoundException("OIDC JWKS not found"));
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_GENERATE') or hasRole('ANONYMOUS')")
    public OIDCJWKSTO generate(String jwksKeyId, String jwksType, int jwksKeySize) {
        OIDCJWKS jwks = this.dao.get();
        if (jwks == null) {
            return this.binder.getOIDCJWKSTO(this.dao.save(this.binder.create(jwksKeyId, jwksType, jwksKeySize)));
        }
        throw new DuplicateException("OIDC JWKS already set");
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_DELETE')")
    public void delete() {
        this.dao.delete();
    }

    protected OIDCJWKSTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        OIDCJWKS jwks = this.dao.get();
        if (jwks == null) {
            throw new UnresolvedReferenceException();
        }
        return this.binder.getOIDCJWKSTO(jwks);
    }

    @PreAuthorize(value="hasRole('OIDC_JWKS_SET') or hasRole('ANONYMOUS')")
    public OIDCJWKSTO set(OIDCJWKSTO entityTO) {
        OIDCJWKS jwks = this.dao.get();
        jwks.setJson(entityTO.getJson());
        return this.binder.getOIDCJWKSTO(this.dao.save(jwks));
    }
}

