/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.batch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.syncope.common.rest.api.batch.BatchPayloadGenerator;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.core.persistence.api.dao.BatchDAO;
import org.apache.syncope.core.persistence.api.entity.Batch;
import org.apache.syncope.core.rest.cxf.batch.BatchItemRequest;
import org.apache.syncope.core.rest.cxf.batch.BatchItemResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class BatchProcess
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(BatchProcess.class);
    @Autowired
    private BatchDAO batchDAO;
    private String boundary;
    private String scheme;
    private String serverName;
    private int serverPort;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String characterEncoding;
    private String baseURI;
    private List<BatchRequestItem> batchRequestItems;
    private DestinationRegistry destinationRegistry;
    private ServletConfig servletConfig;
    private HttpServletRequest servletRequest;
    private Authentication authentication;

    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public void setBatchRequestItems(List<BatchRequestItem> batchRequestItems) {
        this.batchRequestItems = batchRequestItems;
    }

    public void setDestinationRegistry(DestinationRegistry destinationRegistry) {
        this.destinationRegistry = destinationRegistry;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public void setServletRequest(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public void run() {
        SecurityContextHolder.getContext().setAuthentication(this.authentication);
        ArrayList batchResponseItems = new ArrayList(this.batchRequestItems.size());
        this.batchRequestItems.forEach(reqItem -> {
            LOG.debug("Batch Request item:\n{}", reqItem);
            AbstractHTTPDestination dest = this.destinationRegistry.getDestinationForPath(reqItem.getRequestURI(), true);
            if (dest == null) {
                dest = this.destinationRegistry.checkRestfulRequest(reqItem.getRequestURI());
            }
            LOG.debug("Destination found for {}: {}", (Object)reqItem.getRequestURI(), (Object)dest);
            BatchResponseItem resItem = new BatchResponseItem();
            batchResponseItems.add(resItem);
            if (dest == null) {
                resItem.setStatus(404);
            } else {
                BatchItemRequest request = new BatchItemRequest(this.scheme, this.serverName, this.serverPort, this.contextPath, this.servletPath, this.pathInfo, this.characterEncoding, this.baseURI, this.servletRequest, (BatchRequestItem)reqItem);
                BatchItemResponse response = new BatchItemResponse();
                try {
                    dest.invoke(this.servletConfig, this.servletConfig.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response);
                    resItem.setStatus(response.getStatus());
                    resItem.setHeaders(response.getHeaders());
                    String output = new String(response.getUnderlyingOutputStream().toByteArray());
                    if (output.length() > 0) {
                        resItem.setContent(output);
                    }
                    LOG.debug("Returned:\nstatus: {}\nheaders: {}\nbody:\n{}", new Object[]{response.getStatus(), response.getHeaders(), output});
                }
                catch (IOException e) {
                    LOG.error("Invocation of {} failed", (Object)dest.getPath(), (Object)e);
                    resItem.setStatus(500);
                }
            }
            LOG.debug("Batch Response item:\n{}", (Object)resItem);
        });
        String results = BatchPayloadGenerator.generate(batchResponseItems, (String)("--" + this.boundary));
        Batch batch = this.batchDAO.find(this.boundary);
        if (batch == null) {
            LOG.error("Could not find batch {}, cannot save results hence reporting here:\n{}", (Object)this.boundary, (Object)results);
        } else {
            batch.setResults(results);
            this.batchDAO.save(batch);
        }
    }
}

