/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.adaptors.x509.util.X509CertificateCredentialJsonDeserializer;
import org.apereo.cas.adaptors.x509.util.X509CertificateCredentialJsonSerializer;
import org.apereo.cas.authentication.credential.AbstractCredential;
import org.apereo.cas.util.crypto.CertUtils;

@JsonSerialize(using=X509CertificateCredentialJsonSerializer.class)
@JsonDeserialize(using=X509CertificateCredentialJsonDeserializer.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class X509CertificateCredential
extends AbstractCredential {
    private static final long serialVersionUID = 631753409512746474L;
    private final X509Certificate[] certificates;
    private X509Certificate certificate;

    public X509CertificateCredential(X509Certificate[] certificates) {
        this.certificates = Arrays.copyOf(certificates, certificates.length);
    }

    public X509Certificate[] getCertificates() {
        return Arrays.copyOf(this.certificates, this.certificates.length);
    }

    public X509Certificate getCertificate() {
        return (X509Certificate)ObjectUtils.defaultIfNull((Object)this.certificate, (Object)this.certificates[0]);
    }

    public String getId() {
        if (this.certificate != null) {
            return CertUtils.toString((X509Certificate)this.certificate);
        }
        if (this.certificates.length > 0) {
            return CertUtils.toString((X509Certificate)this.certificates[0]);
        }
        return "unknown";
    }

    @Generated
    public String toString() {
        return "X509CertificateCredential()";
    }

    @Generated
    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }
}

