/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.error.TypedMessageErrorHandler;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandlerErrorStrategyAdapter
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(MessageHandlerErrorStrategyAdapter.class);
    @Nonnull
    private MessageHandler wrappedHandler;
    @Nonnull
    @NonnullElements
    private List<TypedMessageErrorHandler> errorHandlers;
    private boolean rethrowIfHandled;
    private boolean rethrowIfNotHandled;

    public MessageHandlerErrorStrategyAdapter(@Nonnull MessageHandler messageHandler, @Nonnull @NonnullElements List<TypedMessageErrorHandler> typedErrorHandlers) {
        this.wrappedHandler = (MessageHandler)Constraint.isNotNull((Object)messageHandler, (String)"Wrapped MessageHandler cannot be null");
        this.errorHandlers = List.copyOf((Collection)Constraint.isNotNull(typedErrorHandlers, (String)"List of TypedMessageErroHandlers cannot be null"));
        this.rethrowIfHandled = false;
        this.rethrowIfNotHandled = true;
    }

    public void setRethrowIfHandled(boolean flag) {
        this.rethrowIfHandled = flag;
    }

    public void setRethrowIfNotHandled(boolean flag) {
        this.rethrowIfNotHandled = flag;
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        try {
            this.wrappedHandler.invoke(messageContext);
        }
        catch (Throwable t) {
            this.log.trace("Wrapped message handler threw error", t);
            for (TypedMessageErrorHandler errorHandler : this.errorHandlers) {
                if (!errorHandler.handlesError(t)) continue;
                this.log.trace("Handler indicates it can handle the error: {}", (Object)errorHandler.getClass().getName());
                boolean handled = errorHandler.handleError(t, messageContext);
                this.log.trace("Handler's indication whether it actually handled the error: {}", (Object)handled);
                if (handled) {
                    if (this.rethrowIfHandled) {
                        this.log.trace("Based on config, rethrowing the handled error");
                        throw t;
                    }
                    this.log.trace("Based on config, swallowing the handled error");
                    return;
                }
                this.log.trace("Handler indicates it did NOT handle the error, continuing with remaining handlers");
            }
            this.log.trace("No error handler handled the thrown error");
            if (this.rethrowIfNotHandled) {
                this.log.trace("Based on config, rethrowing the unhandled error");
                throw t;
            }
            this.log.trace("Based on config, swallowing the unhandled error");
        }
    }
}

