/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.local.ObjectPoolEntry;
import org.identityconnectors.framework.impl.api.local.ObjectPoolHandler;

public class ObjectPool<T> {
    private static final Log LOG = Log.getLog(ObjectPool.class);
    private final Set<PooledObject> activeObjects;
    private final ConcurrentLinkedQueue<PooledObject> idleObjects = new ConcurrentLinkedQueue();
    private final Semaphore totalPermit;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ObjectPoolHandler<T> handler;
    private final ObjectPoolConfiguration poolConfiguration;
    private String poolName;
    private volatile boolean isShutdown = false;
    private volatile boolean isDisposing = false;

    public ObjectPool(ObjectPoolHandler<T> handler, ObjectPoolConfiguration config) {
        Assertions.nullCheck(handler, (String)"handler");
        Assertions.nullCheck((Object)config, (String)"config");
        this.handler = handler;
        this.poolConfiguration = this.handler.validate(config);
        this.activeObjects = new HashSet<PooledObject>(this.poolConfiguration.getMaxObjects());
        this.totalPermit = new Semaphore(this.poolConfiguration.getMaxObjects());
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public boolean isDisposing() {
        return this.isDisposing;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnObject(PooledObject pooled) throws InterruptedException {
        if (this.isShutdown() || this.isDisposing() || this.poolConfiguration.getMaxIdle() < 1) {
            this.dispose(pooled);
            LOG.ok("Returned object to pool {0}, disposing immediately: {1}", new Object[]{this.getPoolName(), pooled});
        } else {
            try {
                for (PooledObject entry : this.idleObjects) {
                    if (this.poolConfiguration.getMaxIdle() > this.idleObjects.size() && !entry.isOlderThan(this.poolConfiguration.getMinEvictableIdleTimeMillis()) || !this.idleObjects.remove(entry)) continue;
                    this.dispose(entry);
                    LOG.ok("Disposed pool {0} entry (too many idle objects): {1}", new Object[]{this.getPoolName(), entry});
                }
            }
            finally {
                pooled.setActive(false);
                pooled.setNew(false);
                this.idleObjects.add(pooled);
                this.signalNotEmpty();
            }
        }
        LOG.ok("returned object to {0}: {1}", new Object[]{this, pooled});
    }

    public ObjectPoolEntry<T> borrowObject() {
        PooledObject rv = null;
        try {
            do {
                if ((rv = this.borrowObjectNoTest()) != null && this.poolConfiguration.getMaxIdleTimeMillis() > 0L && rv.isOlderThan(this.poolConfiguration.getMaxIdleTimeMillis())) {
                    LOG.ok("Disposed pool {0} entry (max idle time expired): {1}", new Object[]{this.getPoolName(), rv});
                    this.dispose(rv);
                    rv = null;
                    continue;
                }
                try {
                    this.handler.testObject(rv.getPooledObject());
                }
                catch (Exception e) {
                    if (null == rv) continue;
                    this.dispose(rv);
                    if (rv.isNew()) {
                        throw ConnectorException.wrap((Throwable)e);
                    }
                    rv = null;
                }
            } while (null == rv);
            rv.setActive(true);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e, "Failed to borrow object from pool.", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
        LOG.ok("Borrowed object from pool {0}: {1}", new Object[]{this, rv});
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PooledObject borrowObjectNoTest() throws InterruptedException {
        if (this.isShutdown()) {
            throw new IllegalStateException("Object pool already shutdown");
        }
        PooledObject pooledConn = this.borrowIdleObject();
        if (null != pooledConn) return pooledConn;
        long nanos = TimeUnit.SECONDS.toNanos(this.poolConfiguration.getMaxWait());
        ReentrantLock lock = this.takeLock;
        lock.lockInterruptibly();
        try {
            do {
                if (this.totalPermit.tryAcquire()) {
                    try {
                        PooledObject pooledObject = this.makeObject();
                        return pooledObject;
                    }
                    catch (RuntimeException e) {
                        this.totalPermit.release();
                        throw e;
                    }
                    catch (Error e) {
                        this.totalPermit.release();
                        throw e;
                    }
                }
                try {
                    nanos = this.notEmpty.awaitNanos(nanos);
                }
                catch (InterruptedException ie) {
                    this.notEmpty.signal();
                    throw ConnectorException.wrap((Throwable)ie);
                }
                if (nanos <= 0L) {
                    throw new ConnectorException("TimeOut");
                }
                pooledConn = this.borrowIdleObject();
                if (null == pooledConn) continue;
                PooledObject pooledObject = pooledConn;
                return pooledObject;
            } while (nanos > 0L);
            return pooledConn;
        }
        finally {
            lock.unlock();
        }
    }

    private PooledObject borrowIdleObject() throws InterruptedException {
        PooledObject pooledConn = this.idleObjects.poll();
        while (pooledConn != null) {
            int size = this.idleObjects.size();
            if (this.poolConfiguration.getMinIdle() >= size + 1 || this.poolConfiguration.getMaxIdle() >= size && !pooledConn.isOlderThan(this.poolConfiguration.getMinEvictableIdleTimeMillis())) {
                return pooledConn;
            }
            this.dispose(pooledConn);
            pooledConn = this.idleObjects.poll();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAllObjects() {
        ReentrantLock lock = this.takeLock;
        try {
            lock.lockInterruptibly();
            this.isDisposing = true;
            LOG.ok("Disposing all objects from {0}", new Object[]{this});
            PooledObject entry = this.idleObjects.poll();
            while (entry != null) {
                try {
                    this.dispose(entry);
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e, "Interrupted disposal of PooledObject object {0}", new Object[]{entry});
                }
                entry = this.idleObjects.poll();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Error disposing of all objects from pool {0}: {1}", new Object[]{this, e.getMessage()});
        }
        finally {
            lock.unlock();
        }
    }

    public void shutdown() {
        this.isShutdown = true;
        try {
            this.disposeAllObjects();
        }
        finally {
            this.handler.shutdown();
        }
    }

    public Statistics getStatistics() {
        return new Statistics(this.idleObjects.size(), this.activeObjects.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledObject makeObject() {
        Set<PooledObject> set = this.activeObjects;
        synchronized (set) {
            PooledObject pooledConn = new PooledObject(this.handler.makeObject());
            this.activeObjects.add(pooledConn);
            return pooledConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(PooledObject entry) throws InterruptedException {
        ReentrantLock lock = this.takeLock;
        lock.lockInterruptibly();
        try {
            Set<PooledObject> set = this.activeObjects;
            synchronized (set) {
                this.activeObjects.remove(entry);
                this.handler.disposeObject(entry.getPooledObject());
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Unexpected error from disposeObject() method: {0}", new Object[]{e.getMessage()});
        }
        finally {
            this.totalPermit.release();
            this.notEmpty.signal();
            lock.unlock();
        }
    }

    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectPool(");
        sb.append(this.poolName);
        if (this.isDisposing) {
            sb.append(", DISPOSING");
        }
        if (this.isShutdown) {
            sb.append(", SHUTTING DOWN");
        }
        sb.append(", idle=").append(this.idleObjects.size());
        sb.append(", active=").append(this.activeObjects.size());
        sb.append(")");
        return sb.toString();
    }

    private class PooledObject
    implements ObjectPoolEntry<T> {
        private final T object;
        private boolean isActive;
        private long lastStateChangeTimestamp;
        private boolean isNew;

        public PooledObject(T object) {
            this.object = object;
            this.isNew = true;
            this.touch();
        }

        @Override
        public T getPooledObject() {
            return this.object;
        }

        @Override
        public void close() throws IOException {
            try {
                ObjectPool.this.returnObject(this);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e, "Failed to close/dispose PooledObject object {0} from pool {1}: {2}", new Object[]{this, ObjectPool.this.getPoolName(), e.getMessage()});
            }
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNew(boolean n) {
            this.isNew = n;
        }

        public void setActive(boolean v) {
            if (this.isActive != v) {
                this.touch();
                this.isActive = v;
            }
        }

        private void touch() {
            this.lastStateChangeTimestamp = System.currentTimeMillis();
        }

        public boolean isOlderThan(long maxAge) {
            return maxAge < System.currentTimeMillis() - this.lastStateChangeTimestamp;
        }

        public String toString() {
            return "PooledObject(object=" + this.object + ", isActive=" + this.isActive + ", lastStateChangeTimestamp=" + this.lastStateChangeTimestamp + ", isNew=" + this.isNew + ")";
        }
    }

    public static final class Statistics {
        private final int numIdle;
        private final int numActive;

        private Statistics(int numIdle, int numActive) {
            this.numIdle = numIdle;
            this.numActive = numActive;
        }

        public int getNumIdle() {
            return this.numIdle;
        }

        public int getNumActive() {
            return this.numActive - this.numIdle;
        }

        public String toString() {
            return "Statistics(numIdle=" + this.numIdle + ", numActive=" + this.numActive + ")";
        }
    }
}

