/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.facebook;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.apis.facebook.FacebookAccessTokenErrorResponse;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.model.Response;
import java.io.IOException;

public class FacebookAccessTokenJsonExtractor
extends OAuth2AccessTokenJsonExtractor {
    protected FacebookAccessTokenJsonExtractor() {
    }

    public static FacebookAccessTokenJsonExtractor instance() {
        return InstanceHolder.INSTANCE;
    }

    public void generateError(Response response) throws IOException {
        JsonNode errorNode = OAuth2AccessTokenJsonExtractor.OBJECT_MAPPER.readTree(response.getBody()).get("error");
        throw new FacebookAccessTokenErrorResponse(errorNode.get("message").asText(), errorNode.get("type").asText(), errorNode.get("code").asInt(), errorNode.get("fbtrace_id").asText(), response);
    }

    private static class InstanceHolder {
        private static final FacebookAccessTokenJsonExtractor INSTANCE = new FacebookAccessTokenJsonExtractor();

        private InstanceHolder() {
        }
    }
}

