/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.reports.ReportConfWrapper;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.tasks.CrontabPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.MIMETypesLoader;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class ReportWizardBuilder
extends BaseAjaxWizardBuilder<ReportTO> {
    private static final long serialVersionUID = 5945391813567245081L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final ImplementationRestClient implementationRestClient;
    protected final ReportRestClient reportRestClient;
    protected final MIMETypesLoader mimeTypesLoader;
    protected final Model<ReportConfWrapper> conf = new Model();
    protected CrontabPanel crontabPanel;

    public ReportWizardBuilder(ReportTO reportTO, ImplementationRestClient implementationRestClient, ReportRestClient reportRestClient, MIMETypesLoader mimeTypesLoader, PageReference pageRef) {
        super(reportTO, pageRef);
        this.implementationRestClient = implementationRestClient;
        this.reportRestClient = reportRestClient;
        this.mimeTypesLoader = mimeTypesLoader;
    }

    protected Serializable onApplyInternal(ReportTO modelObject) {
        if (this.conf.getObject() != null) {
            try {
                ImplementationTO implementation = this.implementationRestClient.read("REPORT_DELEGATE", modelObject.getJobDelegate());
                if (implementation.getEngine() == ImplementationEngine.JAVA) {
                    BeanWrapper confWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)((ReportConfWrapper)this.conf.getObject()).getConf());
                    ((ReportConfWrapper)this.conf.getObject()).getSCondWrapper().forEach((fieldName, pair) -> confWrapper.setPropertyValue(fieldName, (Object)SearchUtils.buildFIQL((List)pair.getRight(), (AbstractFiqlSearchConditionBuilder)pair.getLeft())));
                    implementation.setBody(MAPPER.writeValueAsString((Object)((ReportConfWrapper)this.conf.getObject()).getConf()));
                    this.implementationRestClient.update(implementation);
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        modelObject.setCronExpression(this.crontabPanel.getCronExpression());
        if (modelObject.getKey() == null) {
            this.reportRestClient.create(modelObject);
        } else {
            this.reportRestClient.update(modelObject);
        }
        return modelObject;
    }

    protected void setConf(String jobDelegate) {
        try {
            ImplementationTO implementation = this.implementationRestClient.read("REPORT_DELEGATE", jobDelegate);
            if (implementation.getEngine() == ImplementationEngine.JAVA) {
                this.conf.setObject((Serializable)new ReportConfWrapper());
                ((ReportConfWrapper)this.conf.getObject()).setConf((ReportConf)MAPPER.readValue(implementation.getBody(), ReportConf.class));
            } else {
                this.conf.setObject(null);
            }
        }
        catch (Exception e) {
            LOG.error("Could not read or parse {}", (Object)jobDelegate, (Object)e);
        }
    }

    protected WizardModel buildModelSteps(ReportTO modelObject, WizardModel wizardModel) {
        Optional.ofNullable(modelObject.getJobDelegate()).ifPresent(this::setConf);
        Configuration configuration = new Configuration();
        wizardModel.add((IWizardStep)new Profile(modelObject, configuration));
        wizardModel.add((IWizardStep)configuration);
        wizardModel.add((IWizardStep)new Schedule(modelObject));
        return wizardModel;
    }

    protected class Schedule
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Schedule(ReportTO modelObject) {
            ReportWizardBuilder.this.crontabPanel = new CrontabPanel("schedule", (PropertyModel<String>)new PropertyModel((Object)modelObject, "cronExpression"), modelObject.getCronExpression());
            this.add(new Component[]{ReportWizardBuilder.this.crontabPanel});
        }
    }

    protected class Configuration
    extends WizardStep
    implements WizardModel.ICondition {
        private static final long serialVersionUID = -785981096328637758L;

        public Configuration() {
            this.update();
        }

        protected void update() {
            if (ReportWizardBuilder.this.conf.getObject() == null) {
                this.addOrReplace(new Component[]{new Label("bean", (IModel)Model.of())});
            } else {
                this.addOrReplace(new Component[]{new BeanPanel("bean", new PropertyModel((Object)ReportWizardBuilder.this.conf.getObject(), "conf"), ((ReportConfWrapper)ReportWizardBuilder.this.conf.getObject()).getSCondWrapper(), ReportWizardBuilder.this.pageRef, new String[0]).setRenderBodyOnly(true)});
            }
        }

        public boolean evaluate() {
            return ReportWizardBuilder.this.conf.getObject() != null;
        }
    }

    protected class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;
        private final IModel<List<String>> reportJobDelegates = SyncopeWebApplication.get().getImplementationInfoProvider().getReportJobDelegates();

        public Profile(ReportTO modelObject, final Configuration configuration) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)modelObject, "name"), false);
            this.add(new Component[]{name.addRequiredLabel().setEnabled(true)});
            AjaxCheckBoxPanel active = new AjaxCheckBoxPanel("active", "active", (IModel)new PropertyModel((Object)modelObject, "active"), false);
            this.add(new Component[]{active});
            final AjaxTextFieldPanel mimeType = new AjaxTextFieldPanel("mimeType", "mimeType", (IModel)new PropertyModel((Object)modelObject, "mimeType"));
            mimeType.setChoices(ReportWizardBuilder.this.mimeTypesLoader.getMimeTypes());
            this.add(new Component[]{mimeType.addRequiredLabel()});
            final AjaxTextFieldPanel fileExt = new AjaxTextFieldPanel("fileExt", "fileExt", (IModel)new PropertyModel((Object)modelObject, "fileExt"));
            this.add(new Component[]{fileExt.addRequiredLabel()});
            mimeType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -6139318907146065915L;

                protected void onUpdate(AjaxRequestTarget target) {
                    Optional.ofNullable(ReportWizardBuilder.this.mimeTypesLoader.getFileExt((String)((Object)mimeType.getModelObject()))).ifPresent(arg_0 -> ((AjaxTextFieldPanel)fileExt).setModelObject(arg_0));
                    target.add(new Component[]{fileExt});
                }
            }});
            final AjaxDropDownChoicePanel jobDelegate = new AjaxDropDownChoicePanel("jobDelegate", "jobDelegate", (IModel)new PropertyModel((Object)modelObject, "jobDelegate"), false);
            jobDelegate.setChoices((List)this.reportJobDelegates.getObject());
            this.add(new Component[]{jobDelegate.addRequiredLabel().setEnabled(modelObject.getKey() == null)});
            jobDelegate.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -6139318907146065915L;

                protected void onUpdate(AjaxRequestTarget target) {
                    ReportWizardBuilder.this.setConf((String)((Object)jobDelegate.getModelObject()));
                    configuration.update();
                }
            }});
        }
    }
}

