/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.notifications;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.notifications.NotificationTasks;
import org.apache.syncope.client.console.notifications.NotificationWizardBuilder;
import org.apache.syncope.client.console.notifications.NotificationWrapper;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CollectionPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.audit.EventCategory;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class NotificationDirectoryPanel
extends DirectoryPanel<NotificationTO, NotificationWrapper, NotificationProvider, NotificationRestClient> {
    private static final long serialVersionUID = -3789392431954221446L;
    @SpringBean
    protected NotificationRestClient notificationRestClient;
    @SpringBean
    protected AuditRestClient auditRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    @SpringBean
    protected ImplementationRestClient implementationRestClient;
    @SpringBean
    protected SchemaRestClient schemaRestClient;
    protected final IModel<List<EventCategory>> eventCategories = new LoadableDetachableModel<List<EventCategory>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<EventCategory> load() {
            return NotificationDirectoryPanel.this.auditRestClient.listEvents().stream().filter(c -> c.getType() != AuditElements.EventCategoryType.WA).collect(Collectors.toList());
        }
    };
    protected final BaseModal<String> utilityModal = new BaseModal("outer");

    public NotificationDirectoryPanel(String id, NotificationRestClient restClient, PageReference pageRef) {
        super(id, restClient, pageRef, true);
        this.disableCheckBoxes();
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.utilityModal.size(Modal.Size.Large);
        this.modal.size(Modal.Size.Large);
        this.altDefaultModal.size(Modal.Size.Large);
        this.addNewItemPanelBuilder(new NotificationWizardBuilder(new NotificationTO(), this.notificationRestClient, this.anyTypeRestClient, this.implementationRestClient, this.schemaRestClient, this.eventCategories, pageRef), true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"NOTIFICATION_CREATE");
    }

    @Override
    protected List<IColumn<NotificationTO, String>> getColumns() {
        ArrayList<IColumn<NotificationTO, String>> columns = new ArrayList<IColumn<NotificationTO, String>>();
        columns.add((IColumn<NotificationTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<NotificationTO, String>)new PropertyColumn((IModel)new StringResourceModel("sender", (Component)this), (Object)"sender", "sender"));
        columns.add((IColumn<NotificationTO, String>)new PropertyColumn((IModel)new StringResourceModel("subject", (Component)this), (Object)"subject", "subject"));
        columns.add((IColumn<NotificationTO, String>)new PropertyColumn((IModel)new StringResourceModel("template", (Component)this), (Object)"template", "template"));
        columns.add((IColumn<NotificationTO, String>)new CollectionPropertyColumn((IModel<String>)new StringResourceModel("events", (Component)this), "events"));
        columns.add((IColumn<NotificationTO, String>)new BooleanPropertyColumn((IModel<String>)new StringResourceModel("active", (Component)this), "active", "active"));
        return columns;
    }

    @Override
    public ActionsPanel<NotificationTO> getActions(final IModel<NotificationTO> model) {
        ActionsPanel<NotificationTO> actions = super.getActions(model);
        actions.add(new ActionLink<NotificationTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTO ignore) {
                NotificationDirectoryPanel.this.send((IEventSink)NotificationDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((Object)new NotificationWrapper(((NotificationRestClient)NotificationDirectoryPanel.this.restClient).read(((NotificationTO)model.getObject()).getKey()))), target));
            }
        }, ActionLink.ActionType.EDIT, "NOTIFICATION_UPDATE");
        actions.add(new ActionLink<NotificationTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTO ignore) {
                target.add(new Component[]{NotificationDirectoryPanel.this.utilityModal.setContent(new NotificationTasks(((NotificationTO)model.getObject()).getKey(), NotificationDirectoryPanel.this.pageRef))});
                NotificationDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("notification.tasks", model));
                NotificationDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{NotificationDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.NOTIFICATION_TASKS, "TASK_LIST");
        actions.add(new ActionLink<NotificationTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, NotificationTO ignore) {
                try {
                    ((NotificationRestClient)NotificationDirectoryPanel.this.restClient).delete(((NotificationTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)NotificationDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{NotificationDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting object {}", (Object)((NotificationTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)NotificationDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "NOTIFICATION_DELETE", true);
        return actions;
    }

    @Override
    protected NotificationProvider dataProvider() {
        return new NotificationProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "notification.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected class NotificationProvider
    extends DirectoryDataProvider<NotificationTO> {
        private static final long serialVersionUID = -276043813563988590L;
        protected final SortableDataProviderComparator<NotificationTO> comparator;

        public NotificationProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<NotificationTO>(this);
        }

        public Iterator<NotificationTO> iterator(long first, long count) {
            List<NotificationTO> notifications = ((NotificationRestClient)NotificationDirectoryPanel.this.restClient).list();
            notifications.sort(this.comparator);
            return notifications.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((NotificationRestClient)NotificationDirectoryPanel.this.restClient).list().size();
        }

        public IModel<NotificationTO> model(NotificationTO notification) {
            return Model.of((Serializable)notification);
        }
    }
}

