// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// automatically generated by the FlatBuffers compiler, do not modify
// swiftlint:disable all
// swiftformat:disable all

import FlatBuffers

/// @nodoc
public struct org_apache_arrow_flatbuf_Block: NativeStruct, Verifiable, FlatbuffersInitializable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }

  ///  Index to the start of the RecordBlock (note this is past the Message header)
  private var _offset: Int64
  ///  Length of the metadata
  private var _metaDataLength: Int32
  private let padding0__: UInt32 = 0
  ///  Length of the data (this is aligned so there can be a gap between this and
  ///  the metadata).
  private var _bodyLength: Int64

  public init(_ bb: ByteBuffer, o: Int32) {
    let _accessor = Struct(bb: bb, position: o)
    _offset = _accessor.readBuffer(of: Int64.self, at: 0)
    _metaDataLength = _accessor.readBuffer(of: Int32.self, at: 8)
    _bodyLength = _accessor.readBuffer(of: Int64.self, at: 16)
  }

  public init(offset: Int64, metaDataLength: Int32, bodyLength: Int64) {
    _offset = offset
    _metaDataLength = metaDataLength
    _bodyLength = bodyLength
  }

  public init() {
    _offset = 0
    _metaDataLength = 0
    _bodyLength = 0
  }

  ///  Index to the start of the RecordBlock (note this is past the Message header)
  public var offset: Int64 { _offset }
  ///  Length of the metadata
  public var metaDataLength: Int32 { _metaDataLength }
  ///  Length of the data (this is aligned so there can be a gap between this and
  ///  the metadata).
  public var bodyLength: Int64 { _bodyLength }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    try verifier.inBuffer(position: position, of: org_apache_arrow_flatbuf_Block.self)
  }
}

/// @nodoc
public struct org_apache_arrow_flatbuf_Block_Mutable: FlatBufferStruct {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Struct

  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Struct(bb: bb, position: o) }

  public var offset: Int64 { return _accessor.readBuffer(of: Int64.self, at: 0) }
  public var metaDataLength: Int32 { return _accessor.readBuffer(of: Int32.self, at: 8) }
  public var bodyLength: Int64 { return _accessor.readBuffer(of: Int64.self, at: 16) }
}

///  ----------------------------------------------------------------------
///  Arrow File metadata
///
/// @nodoc
public struct org_apache_arrow_flatbuf_Footer: FlatBufferTable, Verifiable {

  static func validateVersion() { FlatBuffersVersion_23_1_4() }
  public var __buffer: ByteBuffer! { return _accessor.bb }
  private var _accessor: Table

  public static func getRootAsFooter(bb: ByteBuffer) -> org_apache_arrow_flatbuf_Footer {
    return org_apache_arrow_flatbuf_Footer(
      Table(
        bb: bb, position: Int32(bb.read(def: UOffset.self, position: bb.reader)) + Int32(bb.reader))
    )
  }

  private init(_ t: Table) { _accessor = t }
  public init(_ bb: ByteBuffer, o: Int32) { _accessor = Table(bb: bb, position: o) }

  private enum VTOFFSET: VOffset {
    case version = 4
    case schema = 6
    case dictionaries = 8
    case recordBatches = 10
    case customMetadata = 12
    var v: Int32 { Int32(self.rawValue) }
    var p: VOffset { self.rawValue }
  }

  public var version: org_apache_arrow_flatbuf_MetadataVersion {
    let o = _accessor.offset(VTOFFSET.version.v)
    return o == 0
      ? .v1
      : org_apache_arrow_flatbuf_MetadataVersion(
        rawValue: _accessor.readBuffer(of: Int16.self, at: o)) ?? .v1
  }
  public var schema: org_apache_arrow_flatbuf_Schema? {
    let o = _accessor.offset(VTOFFSET.schema.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_Schema(_accessor.bb, o: _accessor.indirect(o + _accessor.position))
  }
  public var hasDictionaries: Bool {
    let o = _accessor.offset(VTOFFSET.dictionaries.v)
    return o == 0 ? false : true
  }
  public var dictionariesCount: Int32 {
    let o = _accessor.offset(VTOFFSET.dictionaries.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func dictionaries(at index: Int32) -> org_apache_arrow_flatbuf_Block? {
    let o = _accessor.offset(VTOFFSET.dictionaries.v)
    return o == 0
      ? nil
      : _accessor.bb.read(
        def: org_apache_arrow_flatbuf_Block.self, position: Int(_accessor.vector(at: o) + index * 24))
  }
  public func mutableDictionaries(at index: Int32) -> org_apache_arrow_flatbuf_Block_Mutable? {
    let o = _accessor.offset(VTOFFSET.dictionaries.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_Block_Mutable(
        _accessor.bb, o: _accessor.vector(at: o) + index * 24)
  }
  public var hasRecordBatches: Bool {
    let o = _accessor.offset(VTOFFSET.recordBatches.v)
    return o == 0 ? false : true
  }
  public var recordBatchesCount: Int32 {
    let o = _accessor.offset(VTOFFSET.recordBatches.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func recordBatches(at index: Int32) -> org_apache_arrow_flatbuf_Block? {
    let o = _accessor.offset(VTOFFSET.recordBatches.v)
    return o == 0
      ? nil
      : _accessor.bb.read(
        def: org_apache_arrow_flatbuf_Block.self, position: Int(_accessor.vector(at: o) + index * 24))
  }
  public func mutableRecordBatches(at index: Int32) -> org_apache_arrow_flatbuf_Block_Mutable? {
    let o = _accessor.offset(VTOFFSET.recordBatches.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_Block_Mutable(
        _accessor.bb, o: _accessor.vector(at: o) + index * 24)
  }
  ///  User-defined metadata
  public var hasCustomMetadata: Bool {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? false : true
  }
  public var customMetadataCount: Int32 {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0 ? 0 : _accessor.vector(count: o)
  }
  public func customMetadata(at index: Int32) -> org_apache_arrow_flatbuf_KeyValue? {
    let o = _accessor.offset(VTOFFSET.customMetadata.v)
    return o == 0
      ? nil
      : org_apache_arrow_flatbuf_KeyValue(
        _accessor.bb, o: _accessor.indirect(_accessor.vector(at: o) + index * 4))
  }
  public static func startFooter(_ fbb: inout FlatBufferBuilder) -> UOffset {
    fbb.startTable(with: 5)
  }
  public static func add(
    version: org_apache_arrow_flatbuf_MetadataVersion, _ fbb: inout FlatBufferBuilder
  ) { fbb.add(element: version.rawValue, def: 0, at: VTOFFSET.version.p) }
  public static func add(schema: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: schema, at: VTOFFSET.schema.p)
  }
  public static func addVectorOf(dictionaries: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: dictionaries, at: VTOFFSET.dictionaries.p)
  }
  public static func startVectorOfDictionaries(_ size: Int, in builder: inout FlatBufferBuilder) {
    builder.startVector(
      size * MemoryLayout<org_apache_arrow_flatbuf_Block>.size,
      elementSize: MemoryLayout<org_apache_arrow_flatbuf_Block>.alignment)
  }
  public static func addVectorOf(recordBatches: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: recordBatches, at: VTOFFSET.recordBatches.p)
  }
  public static func startVectorOfRecordBatches(_ size: Int, in builder: inout FlatBufferBuilder) {
    builder.startVector(
      size * MemoryLayout<org_apache_arrow_flatbuf_Block>.size,
      elementSize: MemoryLayout<org_apache_arrow_flatbuf_Block>.alignment)
  }
  public static func addVectorOf(customMetadata: Offset, _ fbb: inout FlatBufferBuilder) {
    fbb.add(offset: customMetadata, at: VTOFFSET.customMetadata.p)
  }
  public static func endFooter(_ fbb: inout FlatBufferBuilder, start: UOffset) -> Offset {
    let end = Offset(offset: fbb.endTable(at: start))
    return end
  }
  public static func createFooter(
    _ fbb: inout FlatBufferBuilder,
    version: org_apache_arrow_flatbuf_MetadataVersion = .v1,
    schemaOffset schema: Offset = Offset(),
    dictionariesVectorOffset dictionaries: Offset = Offset(),
    recordBatchesVectorOffset recordBatches: Offset = Offset(),
    customMetadataVectorOffset customMetadata: Offset = Offset()
  ) -> Offset {
    let __start = org_apache_arrow_flatbuf_Footer.startFooter(&fbb)
    org_apache_arrow_flatbuf_Footer.add(version: version, &fbb)
    org_apache_arrow_flatbuf_Footer.add(schema: schema, &fbb)
    org_apache_arrow_flatbuf_Footer.addVectorOf(dictionaries: dictionaries, &fbb)
    org_apache_arrow_flatbuf_Footer.addVectorOf(recordBatches: recordBatches, &fbb)
    org_apache_arrow_flatbuf_Footer.addVectorOf(customMetadata: customMetadata, &fbb)
    return org_apache_arrow_flatbuf_Footer.endFooter(&fbb, start: __start)
  }

  public static func verify<T>(_ verifier: inout Verifier, at position: Int, of type: T.Type) throws
  where T: Verifiable {
    var _v = try verifier.visitTable(at: position)
    try _v.visit(
      field: VTOFFSET.version.p, fieldName: "version", required: false,
      type: org_apache_arrow_flatbuf_MetadataVersion.self)
    try _v.visit(
      field: VTOFFSET.schema.p, fieldName: "schema", required: false,
      type: ForwardOffset<org_apache_arrow_flatbuf_Schema>.self)
    try _v.visit(
      field: VTOFFSET.dictionaries.p, fieldName: "dictionaries", required: false,
      type: ForwardOffset<Vector<org_apache_arrow_flatbuf_Block, org_apache_arrow_flatbuf_Block>>
        .self)
    try _v.visit(
      field: VTOFFSET.recordBatches.p, fieldName: "recordBatches", required: false,
      type: ForwardOffset<Vector<org_apache_arrow_flatbuf_Block, org_apache_arrow_flatbuf_Block>>
        .self)
    try _v.visit(
      field: VTOFFSET.customMetadata.p, fieldName: "customMetadata", required: false,
      type: ForwardOffset<
        Vector<ForwardOffset<org_apache_arrow_flatbuf_KeyValue>, org_apache_arrow_flatbuf_KeyValue>
      >.self)
    _v.finish()
  }
}
