/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetNBase;
import org.apache.spark.sql.catalyst.expressions.KllSketchGetNBigint$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the number of items collected in the sketch.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(kll_sketch_agg_bigint(col)) FROM VALUES (1), (2), (3), (4), (5) tab(col);\n       5\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\f\u0019\u0001\u0016B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!)!\t\u0001C\u0001\u0007\")a\t\u0001C)\u000f\")!\n\u0001C!\u0017\")A\u000b\u0001C!+\"91\fAA\u0001\n\u0003a\u0006b\u00020\u0001#\u0003%\ta\u0018\u0005\bU\u0002\t\t\u0011\"\u0011l\u0011\u001d\u0019\b!!A\u0005\u0002QDq\u0001\u001f\u0001\u0002\u0002\u0013\u0005\u0011\u0010C\u0004}\u0001\u0005\u0005I\u0011I?\t\u0013\u0005%\u0001!!A\u0005\u0002\u0005-\u0001\"CA\u000b\u0001\u0005\u0005I\u0011IA\f\u0011%\tY\u0002AA\u0001\n\u0003\nibB\u0005\u0002Ba\t\t\u0011#\u0001\u0002D\u0019Aq\u0003GA\u0001\u0012\u0003\t)\u0005\u0003\u0004C#\u0011\u0005\u0011Q\f\u0005\n\u0003?\n\u0012\u0011!C#\u0003CB\u0011\"a\u0019\u0012\u0003\u0003%\t)!\u001a\t\u0013\u0005%\u0014#!A\u0005\u0002\u0006-\u0004\"CA<#\u0005\u0005I\u0011BA=\u0005MYE\u000e\\*lKR\u001c\u0007nR3u\u001d\nKw-\u001b8u\u0015\tI\"$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000e\u001d\u0003!\u0019\u0017\r^1msN$(BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011\u0003\u0002\u0001'UA\u0002\"a\n\u0015\u000e\u0003aI!!\u000b\r\u0003#-cGnU6fi\u000eDw)\u001a;O\u0005\u0006\u001cX\r\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCFA\u0004Qe>$Wo\u0019;\u0011\u0005EJdB\u0001\u001a8\u001d\t\u0019d'D\u00015\u0015\t)D%\u0001\u0004=e>|GOP\u0005\u0002[%\u0011\u0001\bL\u0001\ba\u0006\u001c7.Y4f\u0013\tQ4H\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00029Y\u0005)1\r[5mIV\ta\b\u0005\u0002(\u007f%\u0011\u0001\t\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\t\u0016\u0003\"a\n\u0001\t\u000bq\u001a\u0001\u0019\u0001 \u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\t!\u0005\nC\u0003J\t\u0001\u0007a(\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u0019B\u0011Q*\u0015\b\u0003\u001d>\u0003\"a\r\u0017\n\u0005Ac\u0013A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001\u0015\u0017\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0005YK\u0006CA\u0016X\u0013\tAFFA\u0002B]fDQA\u0017\u0004A\u0002Y\u000bQ!\u001b8qkR\fAaY8qsR\u0011A)\u0018\u0005\by\u001d\u0001\n\u00111\u0001?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u0019\u0016\u0003}\u0005\\\u0013A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u001dd\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011\u000e\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001m!\ti'/D\u0001o\u0015\ty\u0007/\u0001\u0003mC:<'\"A9\u0002\t)\fg/Y\u0005\u0003%:\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012!\u001e\t\u0003WYL!a\u001e\u0017\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005YS\bbB>\f\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003y\u0004Ba`A\u0003-6\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007a\u0013AC2pY2,7\r^5p]&!\u0011qAA\u0001\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u00055\u00111\u0003\t\u0004W\u0005=\u0011bAA\tY\t9!i\\8mK\u0006t\u0007bB>\u000e\u0003\u0003\u0005\rAV\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\rF\u0002m\u00033Aqa\u001f\b\u0002\u0002\u0003\u0007Q/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\ty\u0002C\u0004|\u001f\u0005\u0005\t\u0019\u0001,)'\u0001\t\u0019#!\u000b\u0002,\u0005=\u0012\u0011GA\u001b\u0003o\tY$!\u0010\u0011\u0007\u001d\n)#C\u0002\u0002(a\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002.\u0005Y%\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u0004\u0013\u000e^3ng\u0002\u001aw\u000e\u001c7fGR,G\rI5oAQDW\rI:lKR\u001c\u0007N\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u00024\u0005Q(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK6mY~\u001b8.\u001a;dQ~\u000bwmZ0cS\u001eLg\u000e\u001e\u0015d_2L\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&M\u0015-A!\u0012\u0014\u0006\f\u0011)g%b\u0003\u0005\u000b\u001b*Y\u0001BS'\u000b\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001*$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005e\u0012AC7jg\u000e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011qH\u0001\u0006i9\nd\u0006M\u0001\u0014\u00172d7k[3uG\"<U\r\u001e(CS\u001eLg\u000e\u001e\t\u0003OE\u0019R!EA$\u0003'\u0002b!!\u0013\u0002Py\"UBAA&\u0015\r\ti\u0005L\u0001\beVtG/[7f\u0013\u0011\t\t&a\u0013\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002V\u0005mSBAA,\u0015\r\tI\u0006]\u0001\u0003S>L1AOA,)\t\t\u0019%\u0001\u0005u_N#(/\u001b8h)\u0005a\u0017!B1qa2LHc\u0001#\u0002h!)A\b\u0006a\u0001}\u00059QO\\1qa2LH\u0003BA7\u0003g\u0002BaKA8}%\u0019\u0011\u0011\u000f\u0017\u0003\r=\u0003H/[8o\u0011!\t)(FA\u0001\u0002\u0004!\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111\u0010\t\u0004[\u0006u\u0014bAA@]\n1qJ\u00196fGR\u0004")
public class KllSketchGetNBigint
extends KllSketchGetNBase
implements Serializable {
    private final Expression child;

    public static Option<Expression> unapply(KllSketchGetNBigint x$0) {
        return KllSketchGetNBigint$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<KllSketchGetNBigint, A> g) {
        return KllSketchGetNBigint$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, KllSketchGetNBigint> compose(Function1<A$, Expression> g) {
        return KllSketchGetNBigint$.MODULE$.compose(g);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public KllSketchGetNBigint withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public String prettyName() {
        return "kll_sketch_get_n_bigint";
    }

    @Override
    public Object nullSafeEval(Object input) {
        Long l;
        try {
            byte[] buffer = (byte[])input;
            KllLongsSketch sketch = KllLongsSketch.heapify((Memory)Memory.wrap((byte[])buffer));
            l = BoxesRunTime.boxToLong((long)sketch.getN());
        }
        catch (Exception e) {
            throw QueryExecutionErrors$.MODULE$.kllSketchInvalidInputError(this.prettyName(), e.getMessage());
        }
        return l;
    }

    public KllSketchGetNBigint copy(Expression child) {
        return new KllSketchGetNBigint(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "KllSketchGetNBigint";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllSketchGetNBigint;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllSketchGetNBigint)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllSketchGetNBigint kllSketchGetNBigint = (KllSketchGetNBigint)x$1;
        Expression expression = this.child();
        Expression expression2 = kllSketchGetNBigint.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!kllSketchGetNBigint.canEqual(this)) return false;
        return true;
    }

    public KllSketchGetNBigint(Expression child) {
        this.child = child;
    }
}

