/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.execution.streaming.state.BatchCommitTracker;
import org.apache.spark.sql.execution.streaming.state.CheckIfShouldForceSnapshotUploadForTesting;
import org.apache.spark.sql.execution.streaming.state.DeactivateInstances;
import org.apache.spark.sql.execution.streaming.state.GetLaggingStoresForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLatestSnapshotVersionForTesting;
import org.apache.spark.sql.execution.streaming.state.GetLocation;
import org.apache.spark.sql.execution.streaming.state.LogLaggingStateStores;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstance;
import org.apache.spark.sql.execution.streaming.state.ReportActiveInstanceResponse;
import org.apache.spark.sql.execution.streaming.state.ReportSnapshotUploaded;
import org.apache.spark.sql.execution.streaming.state.ReportStateStoreCommit;
import org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent;
import org.apache.spark.sql.execution.streaming.state.StartStateStoreCommitTrackingForBatch;
import org.apache.spark.sql.execution.streaming.state.StateStoreCommitValidationFailed;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StopCoordinator$;
import org.apache.spark.sql.execution.streaming.state.ValidateStateStoreCommitForBatch;
import org.apache.spark.sql.execution.streaming.state.VerifyIfInstanceActive;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001\u0002\r\u001a\t!B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0005\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001dy\u0005A1A\u0005\nACaA\u0019\u0001!\u0002\u0013\t\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007c\u0002\u0001\u000b\u0011B3\t\u000fI\u0004!\u0019!C\u0005g\"1\u0001\u0010\u0001Q\u0001\nQDq!\u001f\u0001C\u0002\u0013%!\u0010\u0003\u0004|\u0001\u0001\u0006I!\u001e\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\t\t\u0002\u0001Q\u0001\nyD\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005e\u0001\u0001)A\u0005\u0003/Aq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002&\u0001!I!!\b\t\u000f\u0005\u001d\u0002\u0001\"\u0003\u0002*!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003'\u0002A\u0011BA+\u0005U\u0019F/\u0019;f'R|'/Z\"p_J$\u0017N\\1u_JT!AG\u000e\u0002\u000bM$\u0018\r^3\u000b\u0005qi\u0012!C:ue\u0016\fW.\u001b8h\u0015\tqr$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M!\u0001!K\u00186!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001gM\u0007\u0002c)\u0011!'I\u0001\u0004eB\u001c\u0017B\u0001\u001b2\u0005U!\u0006N]3bIN\u000bg-\u001a*qG\u0016sG\r]8j]R\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u0011\u0002\u0011%tG/\u001a:oC2L!AO\u001c\u0003\u000f1{wmZ5oO\u00061!\u000f]2F]Z,\u0012!\u0010\t\u0003ayJ!aP\u0019\u0003\rI\u00038-\u00128w\u0003\u001d\u0011\boY#om\u0002\nqa]9m\u0007>tg-F\u0001D!\t!e)D\u0001F\u0015\tAt$\u0003\u0002H\u000b\n91+\u0015'D_:4\u0017\u0001C:rY\u000e{gN\u001a\u0011\u0002\rqJg.\u001b;?)\rYUJ\u0014\t\u0003\u0019\u0002i\u0011!\u0007\u0005\u0006w\u0015\u0001\r!\u0010\u0005\u0006\u0003\u0016\u0001\raQ\u0001\nS:\u001cH/\u00198dKN,\u0012!\u0015\t\u0005%^KF,D\u0001T\u0015\t!V+A\u0004nkR\f'\r\\3\u000b\u0005Y[\u0013AC2pY2,7\r^5p]&\u0011\u0001l\u0015\u0002\b\u0011\u0006\u001c\b.T1q!\ta%,\u0003\u0002\\3\t!2\u000b^1uKN#xN]3Qe>4\u0018\u000eZ3s\u0013\u0012\u0004\"!\u00181\u000e\u0003yS!aX\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA1_\u0005e)\u00050Z2vi>\u00148)Y2iKR\u000b7o\u001b'pG\u0006$\u0018n\u001c8\u0002\u0015%t7\u000f^1oG\u0016\u001c\b%A\u000et]\u0006\u00048\u000f[8u+Bdw.\u00193MC\u001e<\u0017N\\4Ti>\u0014Xm]\u000b\u0002KB!!k\u00164o!\t9G.D\u0001i\u0015\tI'.\u0001\u0003vi&d'\"A6\u0002\t)\fg/Y\u0005\u0003[\"\u0014A!V+J\tB\u0019!k\\-\n\u0005A\u001c&a\u0002%bg\"\u001cV\r^\u0001\u001dg:\f\u0007o\u001d5piV\u0003Hn\\1e\u0019\u0006<w-\u001b8h'R|'/Z:!\u0003\u0001\u001aH/\u0019;f'R|'/\u001a'bi\u0016\u001cH/\u00169m_\u0006$W\rZ*oCB\u001c\bn\u001c;\u0016\u0003Q\u0004BAU,ZkB\u0011AJ^\u0005\u0003of\u00111c\u00158baNDw\u000e^+qY>\fG-\u0012<f]R\f\u0011e\u001d;bi\u0016\u001cFo\u001c:f\u0019\u0006$Xm\u001d;Va2|\u0017\rZ3e':\f\u0007o\u001d5pi\u0002\n!\u0004Z3gCVdGo\u00158baNDw\u000e^+qY>\fG-\u0012<f]R,\u0012!^\u0001\u001cI\u00164\u0017-\u001e7u':\f\u0007o\u001d5piV\u0003Hn\\1e\u000bZ,g\u000e\u001e\u0011\u0002'\t\fGo\u00195D_6l\u0017\u000e\u001e+sC\u000e\\WM]:\u0016\u0003y\u0004RAU,\u0000\u0003\u0017\u0001bAKA\u0001M\u0006\u0015\u0011bAA\u0002W\t1A+\u001e9mKJ\u00022AKA\u0004\u0013\r\tIa\u000b\u0002\u0005\u0019>tw\rE\u0002M\u0003\u001bI1!a\u0004\u001a\u0005I\u0011\u0015\r^2i\u0007>lW.\u001b;Ue\u0006\u001c7.\u001a:\u0002)\t\fGo\u00195D_6l\u0017\u000e\u001e+sC\u000e\\WM]:!\u0003}a\u0017m\u001d;Gk2d7K\\1qg\"|G\u000fT1h%\u0016\u0004xN\u001d;US6,Wj]\u000b\u0003\u0003/\u0001RAU,g\u0003\u000b\t\u0001\u0005\\1ti\u001a+H\u000e\\*oCB\u001c\bn\u001c;MC\u001e\u0014V\r]8siRKW.Z'tA\u0005\u00113\u000f[8vY\u0012\u001cun\u001c:eS:\fGo\u001c:SKB|'\u000f^*oCB\u001c\bn\u001c;MC\u001e,\"!a\b\u0011\u0007)\n\t#C\u0002\u0002$-\u0012qAQ8pY\u0016\fg.\u0001\rg_J\u001cWm\u00158baNDw\u000e^+qY>\fGm\u00148MC\u001e\fAdY8pe\u0012Lg.\u0019;pe2\u000bwMU3q_J$\u0018J\u001c;feZ\fG.\u0006\u0002\u0002\u0006\u0005y!/Z2fSZ,\u0017I\u001c3SKBd\u0017\u0010\u0006\u0003\u00020\u0005\u0005\u0003c\u0002\u0016\u00022\u0005U\u00121H\u0005\u0004\u0003gY#a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\u0011\u0007)\n9$C\u0002\u0002:-\u00121!\u00118z!\rQ\u0013QH\u0005\u0004\u0003\u007fY#\u0001B+oSRDq!a\u0011\u0016\u0001\u0004\t)%A\u0004d_:$X\r\u001f;\u0011\u0007A\n9%C\u0002\u0002JE\u0012aB\u00159d\u0007\u0006dGnQ8oi\u0016DH/\u0001\u0013tQ>,H\u000e\u001a$pe\u000e,7K\\1qg\"|G/\u00169m_\u0006$gi\u001c:Qe>4\u0018\u000eZ3s)\u0011\ty\"a\u0014\t\r\u0005Ec\u00031\u0001Z\u0003)\u0001(o\u001c<jI\u0016\u0014\u0018\nZ\u0001\u0012M&tG\rT1hO&twm\u0015;pe\u0016\u001cHCCA,\u0003_\n\u0019(a\u001e\u0002|A)\u0011\u0011LA53:!\u00111LA3\u001d\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1O\u00051AH]8pizJ\u0011\u0001L\u0005\u0004\u0003OZ\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003W\niGA\u0002TKFT1!a\u001a,\u0011\u0019\t\th\u0006a\u0001M\u0006Q\u0011/^3ssJ+h.\u00133\t\u000f\u0005Ut\u00031\u0001\u0002\u0006\u0005\u0001\"/\u001a4fe\u0016t7-\u001a,feNLwN\u001c\u0005\b\u0003s:\u0002\u0019AA\u0003\u0003I\u0011XMZ3sK:\u001cW\rV5nKN$\u0018-\u001c9\t\u000f\u0005ut\u00031\u0001\u0002 \u0005!\u0012n\u001d+fe6Lg.\u0019;j]\u001e$&/[4hKJ\u0004")
public class StateStoreCoordinator
implements ThreadSafeRpcEndpoint,
Logging {
    private final RpcEnv rpcEnv;
    private final SQLConf sqlConf;
    private final HashMap<StateStoreProviderId, ExecutorCacheTaskLocation> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances;
    private final HashMap<UUID, HashSet<StateStoreProviderId>> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$snapshotUploadLaggingStores;
    private final HashMap<StateStoreProviderId, SnapshotUploadEvent> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot;
    private final SnapshotUploadEvent org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent;
    private final HashMap<Tuple2<UUID, Object>, BatchCommitTracker> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers;
    private final HashMap<UUID, Object> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public final RpcEndpointRef self() {
        return RpcEndpoint.self$((RpcEndpoint)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return RpcEndpoint.receive$((RpcEndpoint)this);
    }

    public void onError(Throwable cause) {
        RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
    }

    public void onConnected(RpcAddress remoteAddress) {
        RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onDisconnected(RpcAddress remoteAddress) {
        RpcEndpoint.onDisconnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
    }

    public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
        RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
    }

    public void onStart() {
        RpcEndpoint.onStart$((RpcEndpoint)this);
    }

    public void onStop() {
        RpcEndpoint.onStop$((RpcEndpoint)this);
    }

    public final void stop() {
        RpcEndpoint.stop$((RpcEndpoint)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public SQLConf sqlConf() {
        return this.sqlConf;
    }

    public HashMap<StateStoreProviderId, ExecutorCacheTaskLocation> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances;
    }

    public HashMap<UUID, HashSet<StateStoreProviderId>> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$snapshotUploadLaggingStores() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$snapshotUploadLaggingStores;
    }

    public HashMap<StateStoreProviderId, SnapshotUploadEvent> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot;
    }

    public SnapshotUploadEvent org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent;
    }

    public HashMap<Tuple2<UUID, Object>, BatchCommitTracker> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers;
    }

    public HashMap<UUID, Object> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs() {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs;
    }

    public boolean org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag() {
        return this.sqlConf().stateStoreCoordinatorReportSnapshotUploadLag();
    }

    public boolean org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$forceSnapshotUploadOnLag() {
        return this.sqlConf().stateStoreForceSnapshotUploadOnLag();
    }

    public long org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$coordinatorLagReportInterval() {
        return this.sqlConf().stateStoreCoordinatorSnapshotLagReportInterval();
    }

    public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
        return new Serializable(this, context){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StateStoreCoordinator $outer;
            private final RpcCallContext context$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ReportActiveInstance) {
                    ReportActiveInstance reportActiveInstance = (ReportActiveInstance)A1;
                    StateStoreProviderId id = reportActiveInstance.storeId();
                    String host = reportActiveInstance.host();
                    String executorId = reportActiveInstance.executorId();
                    Seq<StateStoreProviderId> providerIdsToCheck = reportActiveInstance.providerIdsToCheck();
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Reported state store " + id + " is active at " + executorId);
                    ExecutorCacheTaskLocation taskLocation = new ExecutorCacheTaskLocation(host, executorId);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().put((Object)id, (Object)taskLocation);
                    Seq providerIdsToUnload = (Seq)providerIdsToCheck.filter((Function1 & Serializable)providerId -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$2(this, taskLocation, providerId)));
                    boolean shouldForceSnapshotUpload = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldForceSnapshotUploadForProvider(id);
                    this.context$1.reply((Object)new ReportActiveInstanceResponse(shouldForceSnapshotUpload, (Seq<StateStoreProviderId>)providerIdsToUnload));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof VerifyIfInstanceActive) {
                    boolean bl;
                    VerifyIfInstanceActive verifyIfInstanceActive = (VerifyIfInstanceActive)A1;
                    StateStoreProviderId id = verifyIfInstanceActive.storeId();
                    String execId = verifyIfInstanceActive.executorId();
                    Option option = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)id);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        ExecutorCacheTaskLocation location = (ExecutorCacheTaskLocation)some.value();
                        String string = location.executorId();
                        String string2 = execId;
                        bl = !(string != null ? !string.equals(string2) : string2 != null);
                    } else if (None$.MODULE$.equals(option)) {
                        bl = false;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boolean response = bl;
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Verified that state store " + id + " is active: " + response);
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)response));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLocation) {
                    GetLocation getLocation = (GetLocation)A1;
                    StateStoreProviderId id = getLocation.storeId();
                    Option executorId = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)id).map((Function1 & Serializable)x$2 -> x$2.toString());
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got location of the state store " + id + ": " + executorId);
                    this.context$1.reply((Object)executorId);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof DeactivateInstances) {
                    DeactivateInstances deactivateInstances = (DeactivateInstances)A1;
                    UUID runId = deactivateInstances.runId();
                    Seq storeIdsToRemove = ((IterableOnceOps)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().keys().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$8(runId, x$3)))).toSeq();
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().$minus$minus$eq((IterableOnce)storeIdsToRemove);
                    Iterable runIdsToRemove = (Iterable)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().keys().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$9(runId, x$4)));
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().$minus$minus$eq((IterableOnce)runIdsToRemove);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().$minus$minus$eq((IterableOnce)storeIdsToRemove);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().$minus$eq((Object)runId);
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$snapshotUploadLaggingStores().remove((Object)runId);
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deactivating instances related to checkpoint location " + runId + ": " + storeIdsToRemove.mkString(", "));
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ReportSnapshotUploaded) {
                    ReportSnapshotUploaded reportSnapshotUploaded = (ReportSnapshotUploaded)A1;
                    StateStoreProviderId providerId2 = reportSnapshotUploaded.providerId();
                    long version = reportSnapshotUploaded.version();
                    long timestamp = reportSnapshotUploaded.timestamp();
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Snapshot version " + version + " was uploaded for state store " + providerId2);
                    Object object = !this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId2).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$12(version, x$5))) ? this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().put((Object)providerId2, (Object)new SnapshotUploadEvent(version, timestamp)) : BoxedUnit.UNIT;
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof LogLaggingStateStores) {
                    LogLaggingStateStores logLaggingStateStores = (LogLaggingStateStores)A1;
                    UUID queryRunId = logLaggingStateStores.queryRunId();
                    long latestVersion = logLaggingStateStores.latestVersion();
                    boolean isTerminatingTrigger = logLaggingStateStores.isTerminatingTrigger();
                    long currentTimestamp = System.currentTimeMillis();
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag()) {
                        Seq<StateStoreProviderId> laggingStores = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(queryRunId, latestVersion, currentTimestamp, isTerminatingTrigger);
                        Object object = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$forceSnapshotUploadOnLag() ? this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$snapshotUploadLaggingStores().put((Object)queryRunId, HashSet$.MODULE$.apply(laggingStores)) : BoxedUnit.UNIT;
                        if (laggingStores.nonEmpty()) {
                            this.$outer.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"StateStoreCoordinator Snapshot Lag Report for "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.QUERY_RUN_ID, queryRunId)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Number of state stores falling behind: "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.NUM_LAGGING_STORES, BoxesRunTime.boxToInteger((int)laggingStores.size()))})))));
                            long timeSinceLastReport = currentTimestamp - BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().getOrElse((Object)queryRunId, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                            if (timeSinceLastReport > this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$coordinatorLagReportInterval()) {
                                this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs().put((Object)queryRunId, (Object)BoxesRunTime.boxToLong((long)currentTimestamp));
                                ((IterableOnceOps)((IterableOps)laggingStores.sortBy((Function1 & Serializable)x$6 -> (SnapshotUploadEvent)$this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().getOrElse(x$6, (Function0 & Serializable)() -> $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent()), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).take(this.$outer.sqlConf().stateStoreCoordinatorMaxLaggingStoresToReport())).foreach((Function1 & Serializable)providerId -> {
                                    $anonfun$receiveAndReply$1.$anonfun$applyOrElse$17(this, queryRunId, latestVersion, currentTimestamp, providerId);
                                    return BoxedUnit.UNIT;
                                });
                            }
                        }
                    }
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof StartStateStoreCommitTrackingForBatch) {
                    StartStateStoreCommitTrackingForBatch startStateStoreCommitTrackingForBatch = (StartStateStoreCommitTrackingForBatch)A1;
                    UUID runId = startStateStoreCommitTrackingForBatch.runId();
                    long batchId = startStateStoreCommitTrackingForBatch.batchId();
                    scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> expectedStores = startStateStoreCommitTrackingForBatch.expectedStores();
                    Tuple2 key = new Tuple2((Object)runId, (Object)BoxesRunTime.boxToLong((long)batchId));
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().contains((Object)key)) {
                        this.context$1.sendFailure((Throwable)new IllegalStateException("Batch commit tracker already exists for runId=" + runId + ", batchId=" + batchId));
                        return (B1)BoxedUnit.UNIT;
                    }
                    this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().put((Object)key, (Object)new BatchCommitTracker(runId, batchId, expectedStores));
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "Started tracking commits for batch " + batchId + " with " + ((IterableOnceOps)expectedStores.values().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$20(x$7)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$) + " expected stores");
                    this.context$1.reply((Object)BoxedUnit.UNIT);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ReportStateStoreCommit) {
                    ReportStateStoreCommit reportStateStoreCommit = (ReportStateStoreCommit)A1;
                    StateStoreProviderId storeId = reportStateStoreCommit.storeId();
                    long version = reportStateStoreCommit.version();
                    String storeName = reportStateStoreCommit.storeName();
                    long batchId = version - 1L;
                    Tuple2 key = new Tuple2((Object)storeId.queryRunId(), (Object)BoxesRunTime.boxToLong((long)batchId));
                    Option option = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().get((Object)key);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BatchCommitTracker tracker = (BatchCommitTracker)some.value();
                        tracker.recordCommit(storeId, storeName);
                        this.context$1.reply((Object)BoxedUnit.UNIT);
                    } else if (None$.MODULE$.equals(option)) {
                        this.context$1.reply((Object)BoxedUnit.UNIT);
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ValidateStateStoreCommitForBatch) {
                    ValidateStateStoreCommitForBatch validateStateStoreCommitForBatch = (ValidateStateStoreCommitForBatch)A1;
                    UUID runId = validateStateStoreCommitForBatch.runId();
                    long batchId = validateStateStoreCommitForBatch.batchId();
                    Tuple2 key = new Tuple2((Object)runId, (Object)BoxesRunTime.boxToLong((long)batchId));
                    Option option = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().get((Object)key);
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        BatchCommitTracker tracker = (BatchCommitTracker)some.value();
                        try {
                            tracker.validateAllCommitted();
                            this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().remove((Object)key);
                            this.context$1.reply((Object)BoxedUnit.UNIT);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (StateStoreCommitValidationFailed e) {
                            this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers().remove((Object)key);
                            this.context$1.sendFailure((Throwable)((Object)e));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else if (None$.MODULE$.equals(option)) {
                        this.context$1.sendFailure((Throwable)new IllegalStateException("No commit tracker found for runId=" + runId + ", batchId=" + batchId));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLatestSnapshotVersionForTesting) {
                    GetLatestSnapshotVersionForTesting getLatestSnapshotVersionForTesting = (GetLatestSnapshotVersionForTesting)A1;
                    StateStoreProviderId providerId3 = getLatestSnapshotVersionForTesting.providerId();
                    Option version = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId3).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$21(x$8)));
                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got latest snapshot version of the state store " + providerId3 + ": " + version);
                    this.context$1.reply((Object)version);
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof GetLaggingStoresForTesting) {
                    GetLaggingStoresForTesting getLaggingStoresForTesting = (GetLaggingStoresForTesting)A1;
                    UUID queryRunId = getLaggingStoresForTesting.queryRunId();
                    long latestVersion = getLaggingStoresForTesting.latestVersion();
                    boolean isTerminatingTrigger = getLaggingStoresForTesting.isTerminatingTrigger();
                    long currentTimestamp = System.currentTimeMillis();
                    if (this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldCoordinatorReportSnapshotLag()) {
                        Seq<StateStoreProviderId> laggingStores = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(queryRunId, latestVersion, currentTimestamp, isTerminatingTrigger);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got lagging state stores: " + laggingStores.mkString(", "));
                        this.context$1.reply(laggingStores);
                        return (B1)BoxedUnit.UNIT;
                    }
                    this.context$1.reply((Object)package$.MODULE$.Seq().empty());
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof CheckIfShouldForceSnapshotUploadForTesting) {
                    CheckIfShouldForceSnapshotUploadForTesting checkIfShouldForceSnapshotUploadForTesting = (CheckIfShouldForceSnapshotUploadForTesting)A1;
                    StateStoreProviderId providerId4 = checkIfShouldForceSnapshotUploadForTesting.providerId();
                    boolean shouldForceSnapshotUpload = this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldForceSnapshotUploadForProvider(providerId4);
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)shouldForceSnapshotUpload));
                    return (B1)BoxedUnit.UNIT;
                }
                if (StopCoordinator$.MODULE$.equals(A1)) {
                    this.$outer.stop();
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable)() -> "StateStoreCoordinator stopped");
                    this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof ReportActiveInstance) {
                    return true;
                }
                if (object instanceof VerifyIfInstanceActive) {
                    return true;
                }
                if (object instanceof GetLocation) {
                    return true;
                }
                if (object instanceof DeactivateInstances) {
                    return true;
                }
                if (object instanceof ReportSnapshotUploaded) {
                    return true;
                }
                if (object instanceof LogLaggingStateStores) {
                    return true;
                }
                if (object instanceof StartStateStoreCommitTrackingForBatch) {
                    return true;
                }
                if (object instanceof ReportStateStoreCommit) {
                    return true;
                }
                if (object instanceof ValidateStateStoreCommitForBatch) {
                    return true;
                }
                if (object instanceof GetLatestSnapshotVersionForTesting) {
                    return true;
                }
                if (object instanceof GetLaggingStoresForTesting) {
                    return true;
                }
                if (object instanceof CheckIfShouldForceSnapshotUploadForTesting) {
                    return true;
                }
                return StopCoordinator$.MODULE$.equals(object);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(ExecutorCacheTaskLocation taskLocation$1, ExecutorCacheTaskLocation x$1) {
                ExecutorCacheTaskLocation executorCacheTaskLocation = x$1;
                ExecutorCacheTaskLocation executorCacheTaskLocation2 = taskLocation$1;
                return executorCacheTaskLocation == null ? executorCacheTaskLocation2 != null : !executorCacheTaskLocation.equals(executorCacheTaskLocation2);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2($anonfun$receiveAndReply$1 $this, ExecutorCacheTaskLocation taskLocation$1, StateStoreProviderId providerId) {
                Option providerLoc = $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().get((Object)providerId);
                return BoxesRunTime.unboxToBoolean((Object)providerLoc.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anonfun$receiveAndReply$1.$anonfun$applyOrElse$3(taskLocation$1, x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$8(UUID runId$1, StateStoreProviderId x$3) {
                UUID uUID = x$3.queryRunId();
                UUID uUID2 = runId$1;
                return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$9(UUID runId$1, Tuple2 x$4) {
                Object object = x$4._1();
                UUID uUID = runId$1;
                return !(object != null ? !object.equals(uUID) : uUID != null);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$12(long version$1, SnapshotUploadEvent x$5) {
                return x$5.version() >= version$1;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$17($anonfun$receiveAndReply$1 $this, UUID queryRunId$1, long latestVersion$1, long currentTimestamp$1, StateStoreProviderId providerId) {
                MessageWithContext messageWithContext;
                MessageWithContext baseLogMessage = $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"StateStoreCoordinator Snapshot Lag Detected for "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"queryRunId=", " - "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.QUERY_RUN_ID, queryRunId$1)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Store ID: ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.STATE_STORE_ID, providerId.storeId())}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(Latest batch ID: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)latestVersion$1))})));
                Option option = $this.$outer.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().get((Object)providerId);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SnapshotUploadEvent snapshotEvent = (SnapshotUploadEvent)some.value();
                    long versionDelta = latestVersion$1 - snapshotEvent.version();
                    long timeDelta = currentTimestamp$1 - snapshotEvent.timestamp();
                    messageWithContext = baseLogMessage.$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{", "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"latest snapshot: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.SNAPSHOT_EVENT, snapshotEvent)}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"version delta: "}))).log((Seq)Nil$.MODULE$)).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.SNAPSHOT_EVENT_VERSION_DELTA, BoxesRunTime.boxToLong((long)versionDelta))}))).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time delta: ", "ms)"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.SNAPSHOT_EVENT_TIME_DELTA, BoxesRunTime.boxToLong((long)timeDelta))})));
                } else if (None$.MODULE$.equals(option)) {
                    messageWithContext = baseLogMessage.$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{", latest snapshot: no upload for query run)"}))).log((Seq)Nil$.MODULE$));
                } else {
                    throw new MatchError((Object)option);
                }
                MessageWithContext logMessage = messageWithContext;
                $this.$outer.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> logMessage));
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$20(scala.collection.immutable.Map x$7) {
                return BoxesRunTime.unboxToInt((Object)x$7.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }

            public static final /* synthetic */ long $anonfun$applyOrElse$21(SnapshotUploadEvent x$8) {
                return x$8.version();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.context$1 = context$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId java.lang.String ), $anonfun$applyOrElse$10(java.util.UUID scala.collection.immutable.Seq ), $anonfun$applyOrElse$11(long org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$12$adapted(long org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent ), $anonfun$applyOrElse$13(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 java.util.UUID scala.collection.immutable.Seq ), $anonfun$applyOrElse$14(), $anonfun$applyOrElse$15(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$16(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 ), $anonfun$applyOrElse$17$adapted(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 java.util.UUID long long org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$18(org.apache.spark.internal.MessageWithContext ), $anonfun$applyOrElse$19(long scala.collection.immutable.Map ), $anonfun$applyOrElse$2$adapted(org.apache.spark.sql.execution.streaming.state.StateStoreCoordinator$$anonfun$receiveAndReply$1 org.apache.spark.scheduler.ExecutorCacheTaskLocation org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$20$adapted(scala.collection.immutable.Map ), $anonfun$applyOrElse$21$adapted(org.apache.spark.sql.execution.streaming.state.SnapshotUploadEvent ), $anonfun$applyOrElse$22(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId scala.Option ), $anonfun$applyOrElse$23(scala.collection.immutable.Seq ), $anonfun$applyOrElse$24(), $anonfun$applyOrElse$3$adapted(org.apache.spark.scheduler.ExecutorCacheTaskLocation org.apache.spark.scheduler.ExecutorCacheTaskLocation ), $anonfun$applyOrElse$4(), $anonfun$applyOrElse$5(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId boolean ), $anonfun$applyOrElse$6(org.apache.spark.scheduler.ExecutorCacheTaskLocation ), $anonfun$applyOrElse$7(org.apache.spark.sql.execution.streaming.state.StateStoreProviderId scala.Option ), $anonfun$applyOrElse$8$adapted(java.util.UUID org.apache.spark.sql.execution.streaming.state.StateStoreProviderId ), $anonfun$applyOrElse$9$adapted(java.util.UUID scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public boolean org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$shouldForceSnapshotUploadForProvider(StateStoreProviderId providerId) {
        return this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$forceSnapshotUploadOnLag() && ((HashSet)this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$snapshotUploadLaggingStores().getOrElse((Object)providerId.queryRunId(), (Function0 & Serializable)() -> HashSet$.MODULE$.empty())).contains((Object)providerId);
    }

    public Seq<StateStoreProviderId> org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$findLaggingStores(UUID queryRunId, long referenceVersion, long referenceTimestamp, boolean isTerminatingTrigger) {
        long snapshotVersionDeltaMultiplier = this.sqlConf().stateStoreCoordinatorMultiplierForMinVersionDiffToLog();
        long maintenanceIntervalMultiplier = this.sqlConf().stateStoreCoordinatorMultiplierForMinTimeDiffToLog();
        int minDeltasForSnapshot = this.sqlConf().stateStoreMinDeltasForSnapshot();
        long maintenanceInterval = this.sqlConf().streamingMaintenanceInterval();
        long minVersionDeltaForLogging = snapshotVersionDeltaMultiplier * (long)minDeltasForSnapshot;
        long minTimeDeltaForLogging = maintenanceIntervalMultiplier * maintenanceInterval;
        return ((IterableOnceOps)((IterableOps)this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances().view().keys().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StateStoreCoordinator.$anonfun$findLaggingStores$1(queryRunId, x$9)))).filter((Function1 & Serializable)storeProviderId -> BoxesRunTime.boxToBoolean((boolean)StateStoreCoordinator.$anonfun$findLaggingStores$2(this, referenceVersion, minVersionDeltaForLogging, referenceTimestamp, minTimeDeltaForLogging, isTerminatingTrigger, storeProviderId)))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$findLaggingStores$1(UUID queryRunId$2, StateStoreProviderId x$9) {
        UUID uUID = x$9.queryRunId();
        UUID uUID2 = queryRunId$2;
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findLaggingStores$2(StateStoreCoordinator $this, long referenceVersion$1, long minVersionDeltaForLogging$1, long referenceTimestamp$1, long minTimeDeltaForLogging$1, boolean isTerminatingTrigger$1, StateStoreProviderId storeProviderId) {
        SnapshotUploadEvent latestSnapshot = (SnapshotUploadEvent)$this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot().getOrElse((Object)storeProviderId, (Function0 & Serializable)() -> $this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent());
        boolean isBehindOnVersions = referenceVersion$1 - latestSnapshot.version() > minVersionDeltaForLogging$1;
        boolean isBehindOnTime = referenceTimestamp$1 - latestSnapshot.timestamp() > minTimeDeltaForLogging$1;
        return isBehindOnVersions && (isTerminatingTrigger$1 || isBehindOnTime);
    }

    public StateStoreCoordinator(RpcEnv rpcEnv, SQLConf sqlConf) {
        this.rpcEnv = rpcEnv;
        this.sqlConf = sqlConf;
        RpcEndpoint.$init$((RpcEndpoint)this);
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$instances = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$snapshotUploadLaggingStores = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$stateStoreLatestUploadedSnapshot = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$defaultSnapshotUploadEvent = new SnapshotUploadEvent(0L, 0L);
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$batchCommitTrackers = new HashMap();
        this.org$apache$spark$sql$execution$streaming$state$StateStoreCoordinator$$lastFullSnapshotLagReportTimeMs = new HashMap();
    }
}

