/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index.bitmap;

import org.apache.hadoop.hive.ql.index.bitmap.BitmapQuery;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;

public class BitmapInnerQuery
implements BitmapQuery {
    private String tableName;
    private ExprNodeDesc predicate;
    private String alias;
    private String queryStr;

    public BitmapInnerQuery(String tableName, ExprNodeDesc predicate, String alias) {
        this.tableName = tableName;
        this.predicate = predicate;
        this.alias = alias;
        this.constructQueryStr();
    }

    @Override
    public String toString() {
        return this.queryStr;
    }

    private void constructQueryStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("(SELECT * FROM ");
        sb.append(HiveUtils.unparseIdentifier(this.tableName));
        sb.append(" WHERE ");
        sb.append(this.predicate.getExprString());
        sb.append(") ");
        sb.append(this.alias);
        this.queryStr = sb.toString();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }
}

