/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkRuntimeException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.variant.ArrayExtraction;
import org.apache.spark.sql.catalyst.expressions.variant.ObjectExtraction;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet;
import org.apache.spark.sql.catalyst.expressions.variant.VariantPathParser$;
import org.apache.spark.sql.catalyst.expressions.variant.VariantPathSegment;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DatetimeType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantBuilder;
import org.apache.spark.types.variant.VariantUtil;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class VariantGet$
implements Product,
Serializable {
    public static final VariantGet$ MODULE$ = new VariantGet$();

    static {
        Product.$init$((Product)MODULE$);
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public boolean checkDataType(DataType dataType, boolean allowStructsAndMaps) {
        DataType dataType2;
        while (true) {
            if ((dataType2 = dataType) instanceof CharType ? true : dataType2 instanceof VarcharType) {
                return false;
            }
            if (dataType2 instanceof NumericType ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof StringType ? true : (BinaryType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof DatetimeType ? true : VariantType$.MODULE$.equals(dataType2)))))) {
                return true;
            }
            if (dataType2 instanceof ArrayType) {
                DataType elementType;
                ArrayType arrayType = (ArrayType)dataType2;
                dataType = elementType = arrayType.elementType();
                continue;
            }
            if (!(dataType2 instanceof MapType)) break;
            MapType mapType = (MapType)dataType2;
            DataType valueType = mapType.valueType();
            if (!(mapType.keyType() instanceof StringType) || !allowStructsAndMaps) break;
            dataType = valueType;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            if (allowStructsAndMaps) {
                return ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)VariantGet$.MODULE$.checkDataType(f.dataType(), allowStructsAndMaps)));
            }
        }
        return false;
    }

    public boolean checkDataType$default$2() {
        return true;
    }

    public VariantPathSegment[] getParsedPath(String pathValue, String prettyName) {
        return (VariantPathSegment[])VariantPathParser$.MODULE$.parse(pathValue).getOrElse((Function0 & Serializable)() -> {
            throw QueryExecutionErrors$.MODULE$.invalidVariantGetPath(pathValue, prettyName);
        });
    }

    public Object variantGet(VariantVal input, VariantPathSegment[] parsedPath, DataType dataType, VariantCastArgs castArgs) {
        Object object;
        Object object2 = new Object();
        try {
            ObjectRef v = ObjectRef.create((Object)new Variant(input.getValue(), input.getMetadata()));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])parsedPath), (Function1 & Serializable)path -> {
                VariantGet$.$anonfun$variantGet$1(v, object2, path);
                return BoxedUnit.UNIT;
            });
            object = this.cast((Variant)v.elem, dataType, castArgs);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    public Object variantGet(VariantVal input, UTF8String path, DataType dataType, VariantCastArgs castArgs, String prettyName) {
        String pathValue = path.toString();
        VariantPathSegment[] parsedPath = this.getParsedPath(pathValue, prettyName);
        return this.variantGet(input, parsedPath, dataType, castArgs);
    }

    public Object cast(VariantVal input, DataType dataType, VariantCastArgs castArgs) {
        Variant v = new Variant(input.getValue(), input.getMetadata());
        return this.cast(v, dataType, castArgs);
    }

    public Object cast(Variant v, DataType dataType, VariantCastArgs castArgs) {
        VariantUtil.Type variantType;
        DataType dataType2 = dataType;
        VariantType$ variantType$ = VariantType$.MODULE$;
        if (!(dataType2 != null ? !dataType2.equals(variantType$) : variantType$ != null)) {
            VariantBuilder builder = new VariantBuilder(false);
            builder.appendVariant(v);
            Variant result = builder.result();
            return new VariantVal(result.getValue(), result.getMetadata());
        }
        VariantUtil.Type type = variantType = v.getType();
        VariantUtil.Type type2 = VariantUtil.Type.NULL;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            return null;
        }
        VariantUtil.Type type3 = variantType;
        VariantUtil.Type type4 = VariantUtil.Type.UUID;
        if (!(type3 != null ? !type3.equals(type4) : type4 != null)) {
            DataType dataType3 = dataType;
            StringType$ stringType$ = StringType$.MODULE$;
            if (!(dataType3 != null ? !dataType3.equals(stringType$) : stringType$ != null)) {
                return UTF8String.fromString((String)v.getUuid().toString());
            }
            return VariantGet$.invalidCast$1(castArgs, v, dataType);
        }
        DataType dataType4 = dataType;
        if (dataType4 instanceof AtomicType) {
            Literal literal;
            VariantUtil.Type type5 = variantType;
            if (VariantUtil.Type.OBJECT.equals(type5) ? true : VariantUtil.Type.ARRAY.equals(type5)) {
                if (dataType instanceof StringType) {
                    return UTF8String.fromString((String)v.toJson(castArgs.zoneId()));
                }
                return VariantGet$.invalidCast$1(castArgs, v, dataType);
            }
            if (VariantUtil.Type.BOOLEAN.equals(type5)) {
                literal = new Literal(BoxesRunTime.boxToBoolean((boolean)v.getBoolean()), (DataType)BooleanType$.MODULE$);
            } else if (VariantUtil.Type.LONG.equals(type5)) {
                literal = new Literal(BoxesRunTime.boxToLong((long)v.getLong()), (DataType)LongType$.MODULE$);
            } else if (VariantUtil.Type.STRING.equals(type5)) {
                literal = new Literal(UTF8String.fromString((String)v.getString()), (DataType)StringType$.MODULE$);
            } else if (VariantUtil.Type.DOUBLE.equals(type5)) {
                literal = new Literal(BoxesRunTime.boxToDouble((double)v.getDouble()), (DataType)DoubleType$.MODULE$);
            } else if (VariantUtil.Type.DECIMAL.equals(type5)) {
                Decimal d = Decimal$.MODULE$.apply(v.getDecimal());
                literal = new Literal(d, (DataType)new DecimalType(d.precision(), d.scale()));
            } else if (VariantUtil.Type.DATE.equals(type5)) {
                literal = new Literal(BoxesRunTime.boxToInteger((int)((int)v.getLong())), (DataType)DateType$.MODULE$);
            } else if (VariantUtil.Type.TIMESTAMP.equals(type5)) {
                literal = new Literal(BoxesRunTime.boxToLong((long)v.getLong()), (DataType)TimestampType$.MODULE$);
            } else if (VariantUtil.Type.TIMESTAMP_NTZ.equals(type5)) {
                literal = new Literal(BoxesRunTime.boxToLong((long)v.getLong()), (DataType)TimestampNTZType$.MODULE$);
            } else if (VariantUtil.Type.FLOAT.equals(type5)) {
                literal = new Literal(BoxesRunTime.boxToFloat((float)v.getFloat()), (DataType)FloatType$.MODULE$);
            } else if (VariantUtil.Type.BINARY.equals(type5)) {
                literal = new Literal(v.getBinary(), (DataType)BinaryType$.MODULE$);
            } else {
                throw new SparkRuntimeException("UNKNOWN_PRIMITIVE_TYPE_IN_VARIANT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Integer.toString(v.getTypeInfo()))})), SparkRuntimeException$.MODULE$.$lessinit$greater$default$3(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$4(), SparkRuntimeException$.MODULE$.$lessinit$greater$default$5());
            }
            Literal input = literal;
            DataType dataType5 = input.dataType();
            if (LongType$.MODULE$.equals(dataType5)) {
                DataType dataType6 = dataType;
                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                if (!(dataType6 != null ? !dataType6.equals(timestampType$) : timestampType$ != null)) {
                    Object object;
                    try {
                        object = BoxesRunTime.boxToLong((long)this.castLongToTimestamp(BoxesRunTime.unboxToLong((Object)input.value())));
                    }
                    catch (ArithmeticException arithmeticException) {
                        object = VariantGet$.invalidCast$1(castArgs, v, dataType);
                    }
                    return object;
                }
            }
            if (dataType5 instanceof DecimalType) {
                DataType dataType7 = dataType;
                TimestampType$ timestampType$ = TimestampType$.MODULE$;
                if (!(dataType7 != null ? !dataType7.equals(timestampType$) : timestampType$ != null)) {
                    Object object;
                    try {
                        object = BoxesRunTime.boxToLong((long)this.castDecimalToTimestamp((Decimal)input.value()));
                    }
                    catch (ArithmeticException arithmeticException) {
                        object = VariantGet$.invalidCast$1(castArgs, v, dataType);
                    }
                    return object;
                }
            }
            if (Cast$.MODULE$.canAnsiCast(input.dataType(), dataType)) {
                InternalRow x$1;
                Cast qual$1 = new Cast(input, dataType, castArgs.zoneStr(), EvalMode$.MODULE$.TRY());
                Object result = qual$1.eval(x$1 = qual$1.eval$default$1());
                if (result == null) {
                    return VariantGet$.invalidCast$1(castArgs, v, dataType);
                }
                return result;
            }
            return VariantGet$.invalidCast$1(castArgs, v, dataType);
        }
        if (dataType4 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType4;
            DataType elementType = arrayType.elementType();
            VariantUtil.Type type6 = variantType;
            VariantUtil.Type type7 = VariantUtil.Type.ARRAY;
            if (!(type6 != null ? !type6.equals(type7) : type7 != null)) {
                int size = v.arraySize();
                Object[] array = new Object[size];
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    array$1[i] = MODULE$.cast(v.getElementAtIndex(i), elementType, castArgs);
                });
                return new GenericArrayData(array);
            }
            return VariantGet$.invalidCast$1(castArgs, v, dataType);
        }
        if (dataType4 instanceof MapType) {
            MapType mapType = (MapType)dataType4;
            DataType valueType = mapType.valueType();
            if (mapType.keyType() instanceof StringType) {
                VariantUtil.Type type8 = variantType;
                VariantUtil.Type type9 = VariantUtil.Type.OBJECT;
                if (!(type8 != null ? !type8.equals(type9) : type9 != null)) {
                    int size = v.objectSize();
                    Object[] keyArray = new Object[size];
                    Object[] valueArray = new Object[size];
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                        Variant.ObjectField field = v.getFieldAtIndex(i);
                        keyArray$1[i] = UTF8String.fromString((String)field.key);
                        valueArray$1[i] = MODULE$.cast(field.value, valueType, castArgs);
                    });
                    return ArrayBasedMapData$.MODULE$.apply(keyArray, valueArray);
                }
                return VariantGet$.invalidCast$1(castArgs, v, dataType);
            }
        }
        if (dataType4 instanceof StructType) {
            StructType structType = (StructType)dataType4;
            StructField[] fields = structType.fields();
            VariantUtil.Type type10 = variantType;
            VariantUtil.Type type11 = VariantUtil.Type.OBJECT;
            if (!(type10 != null ? !type10.equals(type11) : type11 != null)) {
                GenericInternalRow row = new GenericInternalRow(fields.length);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), v.objectSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    Variant.ObjectField field = v.getFieldAtIndex(i);
                    Option option = structType.getFieldIndex(field.key);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int idx = BoxesRunTime.unboxToInt((Object)some.value());
                        row.update(idx, MODULE$.cast(field.value, fields[idx].dataType(), castArgs));
                        return;
                    }
                });
                return row;
            }
            return VariantGet$.invalidCast$1(castArgs, v, dataType);
        }
        throw new MatchError((Object)dataType4);
    }

    public long castLongToTimestamp(long input) {
        return Math.multiplyExact(input, 1000000L);
    }

    public long castDecimalToTimestamp(Decimal input) {
        BigDecimal multiplier = new BigDecimal(1000000L);
        return input.toJavaBigDecimal().multiply(multiplier).toBigInteger().longValueExact();
    }

    public UTF8String castDecimalToString(Decimal input) {
        return UTF8String.fromString((String)input.toJavaBigDecimal().stripTrailingZeros().toPlainString());
    }

    public VariantGet apply(Expression child, Expression path, DataType targetType, boolean failOnError, Option<String> timeZoneId) {
        return new VariantGet(child, path, targetType, failOnError, timeZoneId);
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<Tuple5<Expression, Expression, DataType, Object, Option<String>>> unapply(VariantGet x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.child(), (Object)x$0.path(), (Object)x$0.targetType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.failOnError()), x$0.timeZoneId()));
    }

    public String productPrefix() {
        return "VariantGet";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof VariantGet$;
    }

    public int hashCode() {
        return -552052559;
    }

    public String toString() {
        return "VariantGet";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VariantGet$.class);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ void $anonfun$variantGet$1(ObjectRef v$1, Object nonLocalReturnKey1$1, VariantPathSegment path) {
        block4: {
            block3: {
                var4_3 = path;
                if (!(var4_3 instanceof ObjectExtraction)) break block3;
                var5_4 = (ObjectExtraction)var4_3;
                key = var5_4.key();
                v0 = ((Variant)v$1.elem).getType();
                var7_6 = VariantUtil.Type.OBJECT;
                if (v0 != null ? v0.equals(var7_6) == false : var7_6 != null) break block3;
                v1 /* !! */  = ((Variant)v$1.elem).getFieldByKey(key);
                break block4;
            }
            if (!(var4_3 instanceof ArrayExtraction)) ** GOTO lbl-1000
            var8_7 = (ArrayExtraction)var4_3;
            index = var8_7.index();
            v2 = ((Variant)v$1.elem).getType();
            var10_9 = VariantUtil.Type.ARRAY;
            if (!(v2 != null ? v2.equals(var10_9) == false : var10_9 != null)) {
                v1 /* !! */  = ((Variant)v$1.elem).getElementAtIndex(index);
            } else lbl-1000:
            // 2 sources

            {
                v1 /* !! */  = v$1.elem = null;
            }
        }
        if ((Variant)v$1.elem == null) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, null);
        }
    }

    private static final Object invalidCast$1(VariantCastArgs castArgs$1, Variant v$2, DataType dataType$1) {
        if (castArgs$1.failOnError()) {
            throw QueryExecutionErrors$.MODULE$.invalidVariantCast(v$2.toJson(castArgs$1.zoneId()), dataType$1);
        }
        return null;
    }

    private VariantGet$() {
    }
}

