/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.CreateOrReplaceable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.Waitable;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.ReadOnlySparkConf;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpec;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.k8s.AbstractPodsAllocator;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsAllocator$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodPending;
import org.apache.spark.scheduler.cluster.k8s.PodRunning;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\reb\u0001\u0002&L\u0001aC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"AA\u000e\u0001B\u0001B\u0003%Q\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!i\bA!A!\u0002\u0013q\bBCA\u0002\u0001\t\u0005\t\u0015!\u0003\u0002\u0006!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001\"CA\u0012\u0001\t\u0007I\u0011CA\u0013\u0011!\ti\u0004\u0001Q\u0001\n\u0005\u001d\u0002\"CA \u0001\t\u0007I\u0011CA\u0013\u0011!\t\t\u0005\u0001Q\u0001\n\u0005\u001d\u0002\"CA\"\u0001\t\u0007I\u0011CA#\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005\u001d\u0003\"CA+\u0001\t\u0007I\u0011CA,\u0011!\ty\u0006\u0001Q\u0001\n\u0005e\u0003\"CA1\u0001\t\u0007I\u0011CA2\u0011!\ti\u0007\u0001Q\u0001\n\u0005\u0015\u0004\"CA8\u0001\t\u0007I\u0011CA9\u0011!\ty\t\u0001Q\u0001\n\u0005M\u0004\"CAI\u0001\t\u0007I\u0011CA#\u0011!\t\u0019\n\u0001Q\u0001\n\u0005\u001d\u0003\"CAK\u0001\t\u0007I\u0011CAL\u0011!\ty\n\u0001Q\u0001\n\u0005e\u0005\"CAQ\u0001\t\u0007I\u0011CA#\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005\u001d\u0003\"CAS\u0001\t\u0007I\u0011CA#\u0011!\t9\u000b\u0001Q\u0001\n\u0005\u001d\u0003\"CAU\u0001\t\u0007I\u0011CA#\u0011!\tY\u000b\u0001Q\u0001\n\u0005\u001d\u0003\"CAW\u0001\t\u0007I\u0011CAL\u0011!\ty\u000b\u0001Q\u0001\n\u0005e\u0005\"CAY\u0001\t\u0007I\u0011CAL\u0011!\t\u0019\f\u0001Q\u0001\n\u0005e\u0005\"CA[\u0001\t\u0007I\u0011CAL\u0011!\t9\f\u0001Q\u0001\n\u0005e\u0005\"CA]\u0001\t\u0007I\u0011CA^\u0011!\t\u0019\u000e\u0001Q\u0001\n\u0005u\u0006\"CAk\u0001\t\u0007I\u0011CAl\u0011!\ty\u000e\u0001Q\u0001\n\u0005e\u0007\"CAq\u0001\t\u0007I\u0011CA,\u0011!\t\u0019\u000f\u0001Q\u0001\n\u0005e\u0003\"CAs\u0001\t\u0007I\u0011AAt\u0011!\tY\u0010\u0001Q\u0001\n\u0005%\b\"CA\u007f\u0001\t\u0007I\u0011CA\u0000\u0011!\u0011i\u0001\u0001Q\u0001\n\t\u0005\u0001\"\u0003B\b\u0001\t\u0007I\u0011\u0003B\t\u0011!\u0011)\u0002\u0001Q\u0001\n\tM\u0001\"\u0003B\f\u0001\t\u0007I\u0011CA,\u0011!\u0011I\u0002\u0001Q\u0001\n\u0005e\u0003\"\u0003B\u000e\u0001\t\u0007I\u0011CA\u0013\u0011!\u0011i\u0002\u0001Q\u0001\n\u0005\u001d\u0002\"\u0003B\u0010\u0001\u0001\u0007I\u0011\u0003B\u0011\u0011%\u0011I\u0003\u0001a\u0001\n#\u0011Y\u0003\u0003\u0005\u00038\u0001\u0001\u000b\u0015\u0002B\u0012\u0011-\u0011I\u0004\u0001a\u0001\u0002\u0004%\t\"a/\t\u0017\tm\u0002\u00011AA\u0002\u0013E!Q\b\u0005\f\u0005\u0003\u0002\u0001\u0019!A!B\u0013\ti\fC\u0005\u0003D\u0001\u0001\r\u0011\"\u0005\u0003F!I!1\u000b\u0001A\u0002\u0013E!Q\u000b\u0005\t\u00053\u0002\u0001\u0015)\u0003\u0003H!9!1\r\u0001\u0005\u0002\t\u0015\u0004b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u0011\u001d\u0011Y\t\u0001C\t\u0005\u001bCqA!+\u0001\t#\u0011Y\u000bC\u0004\u0003B\u0002!\tBa1\t\u000f\tE\u0007\u0001\"\u0005\u0003T\"9!\u0011\u001e\u0001\u0005\u0012\t-\bb\u0002B~\u0001\u0011\u0005#Q`\u0004\t\u0007\u0003Y\u0005\u0012A)\u0004\u0004\u00199!j\u0013E\u0001#\u000e\u0015\u0001bBA\t\u000f\u0012\u00051Q\u0002\u0005\b\u0007\u001f9E\u0011AB\t\u0005U)\u00050Z2vi>\u0014\bk\u001c3t\u00032dwnY1u_JT!\u0001T'\u0002\u0007-D4O\u0003\u0002O\u001f\u000691\r\\;ti\u0016\u0014(B\u0001)R\u0003%\u00198\r[3ek2,'O\u0003\u0002S'\u0006)1\u000f]1sW*\u0011A+V\u0001\u0007CB\f7\r[3\u000b\u0003Y\u000b1a\u001c:h\u0007\u0001\u00192\u0001A-^!\tQ6,D\u0001L\u0013\ta6JA\u000bBEN$(/Y2u!>$7/\u00117m_\u000e\fGo\u001c:\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\f\u0016\u0001C5oi\u0016\u0014h.\u00197\n\u0005\t|&a\u0002'pO\u001eLgnZ\u0001\u0005G>tg\r\u0005\u0002fM6\t\u0011+\u0003\u0002h#\nI1\u000b]1sW\u000e{gNZ\u0001\u0007g\u0016\u001cWj\u001a:\u0011\u0005\u0015T\u0017BA6R\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\u0018aD3yK\u000e,Ho\u001c:Ck&dG-\u001a:\u0011\u0005is\u0017BA8L\u0005eYUOY3s]\u0016$Xm]#yK\u000e,Ho\u001c:Ck&dG-\u001a:\u0002!-,(-\u001a:oKR,7o\u00117jK:$\bC\u0001:|\u001b\u0005\u0019(B\u0001;v\u0003\u0019\u0019G.[3oi*\u0011ao^\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001=z\u0003\u001d1\u0017M\u0019:jGbR\u0011A_\u0001\u0003S>L!\u0001`:\u0003!-+(-\u001a:oKR,7o\u00117jK:$\u0018AD:oCB\u001c\bn\u001c;t'R|'/\u001a\t\u00035~L1!!\u0001L\u0005i)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u0003\u0015\u0019Gn\\2l!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006#\u0006!Q\u000f^5m\u0013\u0011\ty!!\u0003\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)9\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\u0001\"A\u0017\u0001\t\u000b\r<\u0001\u0019\u00013\t\u000b!<\u0001\u0019A5\t\u000b1<\u0001\u0019A7\t\u000bA<\u0001\u0019A9\t\u000bu<\u0001\u0019\u0001@\t\u000f\u0005\rq\u00011\u0001\u0002\u0006\u0005\u0019R\tW#D+R{%kX%E?\u000e{UK\u0014+F%V\u0011\u0011q\u0005\t\u0005\u0003S\tI$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0019\tGo\\7jG*!\u0011\u0011GA\u001a\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u0017\t)D\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\u0011\tY$a\u000b\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003Q)\u0005,R\"V)>\u0013v,\u0013#`\u0007>+f\nV#SA\u0005Y\u0001KV\"`\u0007>+f\nV#S\u00031\u0001fkQ0D\u001fVsE+\u0012*!\u0003\u001di\u0017\r\u001f)W\u0007N,\"!a\u0012\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R!!!\u0014\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005E\u00131\n\u0002\u0004\u0013:$\u0018\u0001C7bqB36i\u001d\u0011\u0002\u001bA|G-\u00117m_\u000e|e\u000e\u0015,D+\t\tI\u0006\u0005\u0003\u0002J\u0005m\u0013\u0002BA/\u0003\u0017\u0012qAQ8pY\u0016\fg.\u0001\bq_\u0012\fE\u000e\\8d\u001f:\u0004fk\u0011\u0011\u0002UQ|G/\u00197FqB,7\r^3e\u000bb,7-\u001e;peN\u0004VM\u001d*fg>,(oY3Qe>4\u0017\u000e\\3JIV\u0011\u0011Q\r\t\t\u0003O\nI'a\u0012\u0002H5\u0011\u0011qF\u0005\u0005\u0003W\nyCA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\f1\u0006^8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o\u001d)feJ+7o\\;sG\u0016\u0004&o\u001c4jY\u0016LE\rI\u0001\u0016eBLE\rV8SKN|WO]2f!J|g-\u001b7f+\t\t\u0019\b\u0005\u0005\u0002v\u0005}\u0014qIAB\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0003{\nY%\u0001\u0006d_2dWm\u0019;j_:LA!!!\u0002x\t9\u0001*Y:i\u001b\u0006\u0004\b\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%\u0015+\u0001\u0005sKN|WO]2f\u0013\u0011\ti)a\"\u0003\u001fI+7o\\;sG\u0016\u0004&o\u001c4jY\u0016\faC\u001d9JIR{'+Z:pkJ\u001cW\r\u0015:pM&dW\rI\u0001\u0012a>$\u0017\t\u001c7pG\u0006$\u0018n\u001c8TSj,\u0017A\u00059pI\u0006cGn\\2bi&|gnU5{K\u0002\n!\u0003]8e\u00032dwnY1uS>tG)\u001a7bsV\u0011\u0011\u0011\u0014\t\u0005\u0003\u0013\nY*\u0003\u0003\u0002\u001e\u0006-#\u0001\u0002'p]\u001e\f1\u0003]8e\u00032dwnY1uS>tG)\u001a7bs\u0002\nA\u0003]8e\u00032dwnY1uS>tW*\u0019=j[Vl\u0017!\u00069pI\u0006cGn\\2bi&|g.T1yS6,X\u000eI\u0001\u000f[\u0006D\b+\u001a8eS:<\u0007k\u001c3t\u0003=i\u0017\r\u001f)f]\u0012Lgn\u001a)pIN\u0004\u0013!F7bqB+g\u000eZ5oOB{Gm\u001d)feJ\u0003\u0018\u000eZ\u0001\u0017[\u0006D\b+\u001a8eS:<\u0007k\u001c3t!\u0016\u0014(\u000b]5eA\u0005\u0011\u0002o\u001c3De\u0016\fG/[8o)&lWm\\;u\u0003M\u0001x\u000eZ\"sK\u0006$\u0018n\u001c8US6,w.\u001e;!\u0003e!'/\u001b<feB{GMU3bI&tWm]:US6,w.\u001e;\u00025\u0011\u0014\u0018N^3s!>$'+Z1eS:,7o\u001d+j[\u0016|W\u000f\u001e\u0011\u0002'\u0015DXmY;u_JLE\r\\3US6,w.\u001e;\u0002)\u0015DXmY;u_JLE\r\\3US6,w.\u001e;!\u0003%q\u0017-\\3ta\u0006\u001cW-\u0006\u0002\u0002>B!\u0011qXAg\u001d\u0011\t\t-!3\u0011\t\u0005\r\u00171J\u0007\u0003\u0003\u000bT1!a2X\u0003\u0019a$o\\8u}%!\u00111ZA&\u0003\u0019\u0001&/\u001a3fM&!\u0011qZAi\u0005\u0019\u0019FO]5oO*!\u00111ZA&\u0003)q\u0017-\\3ta\u0006\u001cW\rI\u0001\u0018WV\u0014WM\u001d8fi\u0016\u001cHI]5wKJ\u0004v\u000e\u001a(b[\u0016,\"!!7\u0011\r\u0005%\u00131\\A_\u0013\u0011\ti.a\u0013\u0003\r=\u0003H/[8o\u0003aYWOY3s]\u0016$Xm\u001d#sSZ,'\u000fU8e\u001d\u0006lW\rI\u0001\u0016g\"|W\u000f\u001c3EK2,G/Z#yK\u000e,Ho\u001c:t\u0003Y\u0019\bn\\;mI\u0012+G.\u001a;f\u000bb,7-\u001e;peN\u0004\u0013!\u00033sSZ,'\u000fU8e+\t\tI\u000f\u0005\u0004\u0002J\u0005m\u00171\u001e\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003\u0015iw\u000eZ3m\u0015\r\t)0^\u0001\u0004CBL\u0017\u0002BA}\u0003_\u00141\u0001U8e\u0003)!'/\u001b<feB{G\rI\u0001\u0016]\u0016<H._\"sK\u0006$X\rZ#yK\u000e,Ho\u001c:t+\t\u0011\t\u0001\u0005\u0005\u0002v\t\r\u0011\u0011\u0014B\u0004\u0013\u0011\u0011)!a\u001e\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!!\tIE!\u0003\u0002H\u0005e\u0015\u0002\u0002B\u0006\u0003\u0017\u0012a\u0001V;qY\u0016\u0014\u0014A\u00068fo2L8I]3bi\u0016$W\t_3dkR|'o\u001d\u0011\u0002?M\u001c\u0007.\u001a3vY\u0016\u00148J\\8x]:+w\u000f\\=De\u0016\fG/\u001a3Fq\u0016\u001c7/\u0006\u0002\u0003\u0014AA\u0011Q\u000fB\u0002\u00033\u000b9%\u0001\u0011tG\",G-\u001e7fe.swn\u001e8OK^d\u0017p\u0011:fCR,G-\u0012=fGN\u0004\u0013\u0001\u00073z]\u0006l\u0017nY!mY>\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0006IB-\u001f8b[&\u001c\u0017\t\u001c7pG\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3!\u0003IqW/\\(viN$\u0018M\u001c3j]\u001e\u0004v\u000eZ:\u0002'9,XnT;ugR\fg\u000eZ5oOB{Gm\u001d\u0011\u0002\u00191\f7\u000f^*oCB\u001c\bn\u001c;\u0016\u0005\t\r\u0002c\u0001.\u0003&%\u0019!qE&\u0003)\u0015CXmY;u_J\u0004v\u000eZ:T]\u0006\u00048\u000f[8u\u0003Aa\u0017m\u001d;T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000f\u0006\u0003\u0003.\tM\u0002\u0003BA%\u0005_IAA!\r\u0002L\t!QK\\5u\u0011%\u0011)$NA\u0001\u0002\u0004\u0011\u0019#A\u0002yIE\nQ\u0002\\1tiNs\u0017\r]:i_R\u0004\u0013!B1qa&#\u0017!C1qa&#w\fJ3r)\u0011\u0011iCa\u0010\t\u0013\tU\u0002(!AA\u0002\u0005u\u0016AB1qa&#\u0007%\u0001\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001cXC\u0001B$!\u0019\u0011IEa\u0014\u0002\u001a6\u0011!1\n\u0006\u0005\u0005\u001b\nY(A\u0005j[6,H/\u00192mK&!!\u0011\u000bB&\u0005\r\u0019V\r^\u0001\u0017I\u0016dW\r^3e\u000bb,7-\u001e;pe&#7o\u0018\u0013fcR!!Q\u0006B,\u0011%\u0011)dOA\u0001\u0002\u0004\u00119%A\neK2,G/\u001a3Fq\u0016\u001cW\u000f^8s\u0013\u0012\u001c\b\u0005K\u0002=\u0005;\u0002B!!\u0013\u0003`%!!\u0011MA&\u0005!1x\u000e\\1uS2,\u0017!B:uCJ$HC\u0002B\u0017\u0005O\u0012Y\u0007C\u0004\u0003ju\u0002\r!!0\u0002\u001b\u0005\u0004\b\u000f\\5dCRLwN\\%e\u0011\u001d\u0011i'\u0010a\u0001\u0005_\n\u0001c]2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0007i\u0013\t(C\u0002\u0003t-\u0013\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\f\u0011d]3u)>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sgR!!Q\u0006B=\u0011\u001d\u0011YH\u0010a\u0001\u0005{\n1D]3t_V\u00148-\u001a)s_\u001aLG.\u001a+p)>$\u0018\r\\#yK\u000e\u001c\b\u0003CA`\u0005\u007f\n\u0019)a\u0012\n\t\t\u0005\u0015\u0011\u001b\u0002\u0004\u001b\u0006\u0004\u0018!C5t\t\u0016dW\r^3e)\u0011\tIFa\"\t\u000f\t%u\b1\u0001\u0002>\u0006QQ\r_3dkR|'/\u00133\u0002\u001d=tg*Z<T]\u0006\u00048\u000f[8ugRA!Q\u0006BH\u0005#\u0013\u0019\nC\u0004\u0003j\u0001\u0003\r!!0\t\u000f\t5\u0004\t1\u0001\u0003p!9!Q\u0013!A\u0002\t]\u0015!C:oCB\u001c\bn\u001c;t!\u0019\u0011IJa)\u0003$9!!1\u0014BP\u001d\u0011\t\u0019M!(\n\u0005\u00055\u0013\u0002\u0002BQ\u0003\u0017\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003&\n\u001d&aA*fc*!!\u0011UA&\u0003=9W\r\u001e*fkN\f'\r\\3Q-\u000e\u001bHC\u0002BW\u0005s\u0013Y\f\u0005\u0004\u0002v\t=&1W\u0005\u0005\u0005c\u000b9H\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003[\u0014),\u0003\u0003\u00038\u0006=(!\u0006)feNL7\u000f^3oiZ{G.^7f\u00072\f\u0017.\u001c\u0005\b\u0005S\n\u0005\u0019AA_\u0011\u001d\u0011i,\u0011a\u0001\u0005\u007f\u000b\u0011\u0002\u001d<dg&sWk]3\u0011\r\te%1UA_\u0003M\u0011X-];fgRtUm^#yK\u000e,Ho\u001c:t))\u0011iC!2\u0003J\n-'q\u001a\u0005\b\u0005\u000f\u0014\u0005\u0019AA$\u0003YqW/\\#yK\u000e,Ho\u001c:t)>\fE\u000e\\8dCR,\u0007b\u0002B5\u0005\u0002\u0007\u0011Q\u0018\u0005\b\u0005\u001b\u0014\u0005\u0019AA$\u0003E\u0011Xm]8ve\u000e,\u0007K]8gS2,\u0017\n\u001a\u0005\b\u0005{\u0013\u0005\u0019\u0001B`\u0003M\u0011X\r\u001d7bG\u0016\u0004fkQ:JM:+W\rZ3e)!\u0011)N!8\u0003b\n\u0015\bC\u0002BM\u0005G\u00139\u000e\u0005\u0003\u0002n\ne\u0017\u0002\u0002Bn\u0003_\u00141\u0002S1t\u001b\u0016$\u0018\rZ1uC\"9!q\\\"A\u0002\u0005-\u0018a\u00019pI\"9!1]\"A\u0002\tU\u0017!\u0003:fg>,(oY3t\u0011\u001d\u00119o\u0011a\u0001\u0005[\u000bAB]3vg\u0006\u0014G.\u001a)W\u0007N\fa#[:Fq\u0016\u001cW\u000f^8s\u0013\u0012dW\rV5nK\u0012|U\u000f\u001e\u000b\u0007\u00033\u0012iOa>\t\u000f\t=H\t1\u0001\u0003r\u0006)1\u000f^1uKB\u0019!La=\n\u0007\tU8J\u0001\tFq\u0016\u001cW\u000f^8s!>$7\u000b^1uK\"9!\u0011 #A\u0002\u0005e\u0015aC2veJ,g\u000e\u001e+j[\u0016\fAa\u001d;paR!!Q\u0006B\u0000\u0011\u001d\u0011I'\u0012a\u0001\u0003{\u000bQ#\u0012=fGV$xN\u001d)pIN\fE\u000e\\8dCR|'\u000f\u0005\u0002[\u000fN\u0019qia\u0002\u0011\t\u0005%3\u0011B\u0005\u0005\u0007\u0017\tYE\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007\u0007\t!b\u001d9mSR\u001cFn\u001c;t+\u0011\u0019\u0019b!\b\u0015\r\rU1qFB\u001b!\u0019\u0011IJa)\u0004\u0018AA\u0011\u0011\nB\u0005\u00073\t9\u0005\u0005\u0003\u0004\u001c\ruA\u0002\u0001\u0003\b\u0007?I%\u0019AB\u0011\u0005\u0005!\u0016\u0003BB\u0012\u0007S\u0001B!!\u0013\u0004&%!1qEA&\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0013\u0004,%!1QFA&\u0005\r\te.\u001f\u0005\b\u0007cI\u0005\u0019AB\u001a\u0003%\u0019wN\\:v[\u0016\u00148\u000f\u0005\u0004\u0003\u001a\n\r6\u0011\u0004\u0005\b\u0007oI\u0005\u0019AA$\u0003\u0015\u0019Hn\u001c;t\u0001")
public class ExecutorPodsAllocator
extends AbstractPodsAllocator
implements Logging {
    private final SparkConf conf;
    private final SecurityManager secMgr;
    private final KubernetesExecutorBuilder executorBuilder;
    private final KubernetesClient kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    private final Clock clock;
    private final AtomicInteger EXECUTOR_ID_COUNTER;
    private final AtomicInteger PVC_COUNTER;
    private final int maxPVCs;
    private final boolean podAllocOnPVC;
    private final ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId;
    private final HashMap<Object, ResourceProfile> rpIdToResourceProfile;
    private final int podAllocationSize;
    private final long podAllocationDelay;
    private final int podAllocationMaximum;
    private final int maxPendingPods;
    private final int maxPendingPodsPerRpid;
    private final long podCreationTimeout;
    private final long driverPodReadinessTimeout;
    private final long executorIdleTimeout;
    private final String namespace;
    private final Option<String> kubernetesDriverPodName;
    private final boolean shouldDeleteExecutors;
    private final Option<Pod> driverPod;
    private final LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors;
    private final LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs;
    private final boolean dynamicAllocationEnabled;
    private final AtomicInteger numOutstandingPods;
    private ExecutorPodsSnapshot lastSnapshot;
    private String appId;
    private volatile scala.collection.immutable.Set<Object> deletedExecutorIds;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <T> Seq<Tuple2<T, Object>> splitSlots(Seq<T> consumers, int slots) {
        return ExecutorPodsAllocator$.MODULE$.splitSlots(consumers, slots);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public AtomicInteger EXECUTOR_ID_COUNTER() {
        return this.EXECUTOR_ID_COUNTER;
    }

    public AtomicInteger PVC_COUNTER() {
        return this.PVC_COUNTER;
    }

    public int maxPVCs() {
        return this.maxPVCs;
    }

    public boolean podAllocOnPVC() {
        return this.podAllocOnPVC;
    }

    public ConcurrentHashMap<Object, Object> totalExpectedExecutorsPerResourceProfileId() {
        return this.totalExpectedExecutorsPerResourceProfileId;
    }

    public HashMap<Object, ResourceProfile> rpIdToResourceProfile() {
        return this.rpIdToResourceProfile;
    }

    public int podAllocationSize() {
        return this.podAllocationSize;
    }

    public long podAllocationDelay() {
        return this.podAllocationDelay;
    }

    public int podAllocationMaximum() {
        return this.podAllocationMaximum;
    }

    public int maxPendingPods() {
        return this.maxPendingPods;
    }

    public int maxPendingPodsPerRpid() {
        return this.maxPendingPodsPerRpid;
    }

    public long podCreationTimeout() {
        return this.podCreationTimeout;
    }

    public long driverPodReadinessTimeout() {
        return this.driverPodReadinessTimeout;
    }

    public long executorIdleTimeout() {
        return this.executorIdleTimeout;
    }

    public String namespace() {
        return this.namespace;
    }

    public Option<String> kubernetesDriverPodName() {
        return this.kubernetesDriverPodName;
    }

    public boolean shouldDeleteExecutors() {
        return this.shouldDeleteExecutors;
    }

    @Override
    public Option<Pod> driverPod() {
        return this.driverPod;
    }

    public LinkedHashMap<Object, Tuple2<Object, Object>> newlyCreatedExecutors() {
        return this.newlyCreatedExecutors;
    }

    public LinkedHashMap<Object, Object> schedulerKnownNewlyCreatedExecs() {
        return this.schedulerKnownNewlyCreatedExecs;
    }

    public boolean dynamicAllocationEnabled() {
        return this.dynamicAllocationEnabled;
    }

    public AtomicInteger numOutstandingPods() {
        return this.numOutstandingPods;
    }

    public ExecutorPodsSnapshot lastSnapshot() {
        return this.lastSnapshot;
    }

    public void lastSnapshot_$eq(ExecutorPodsSnapshot x$1) {
        this.lastSnapshot = x$1;
    }

    public String appId() {
        return this.appId;
    }

    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    public scala.collection.immutable.Set<Object> deletedExecutorIds() {
        return this.deletedExecutorIds;
    }

    public void deletedExecutorIds_$eq(scala.collection.immutable.Set<Object> x$1) {
        this.deletedExecutorIds = x$1;
    }

    @Override
    public void start(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend) {
        this.appId_$eq(applicationId);
        this.driverPod().foreach((Function1 & Serializable)pod -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Waitable)((Nameable)this.kubernetesClient.pods().inNamespace(this.namespace())).withName(pod.getMetadata().getName())).waitUntilReady(this.driverPodReadinessTimeout(), TimeUnit.SECONDS));
            return BoxedUnit.UNIT;
        });
        this.snapshotsStore.addSubscriber(this.podAllocationDelay(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)(Function1 & Serializable)executorPodsSnapshot -> {
            this.onNewSnapshots(applicationId, schedulerBackend, (Seq<ExecutorPodsSnapshot>)executorPodsSnapshot);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void setTotalExpectedExecutors(scala.collection.immutable.Map<ResourceProfile, Object> resourceProfileToTotalExecs) {
        resourceProfileToTotalExecs.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$setTotalExpectedExecutors$1(this, x0$1)));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Set total expected execs to " + this.totalExpectedExecutorsPerResourceProfileId());
        if (this.numOutstandingPods().get() == 0) {
            this.snapshotsStore.notifySubscribers();
            return;
        }
    }

    @Override
    public boolean isDeleted(String executorId) {
        return this.deletedExecutorIds().contains((Object)BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executorId))));
    }

    public void onNewSnapshots(String applicationId, KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Received " + snapshots.size() + " snapshots");
        Seq k8sKnownExecIds = (Seq)((SeqOps)snapshots.flatMap((Function1 & Serializable)x$2 -> x$2.executorPods().keys())).distinct();
        this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)k8sKnownExecIds);
        this.schedulerKnownNewlyCreatedExecs().$minus$minus$eq((IterableOnce)k8sKnownExecIds);
        Seq k8sKnownPVCNames = (Seq)((SeqOps)((IterableOps)snapshots.flatMap((Function1 & Serializable)x$3 -> (Iterable)x$3.executorPods().values().map((Function1 & Serializable)x$4 -> x$4.pod()))).flatMap((Function1 & Serializable)pod -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(pod.getSpec().getVolumes()).asScala().flatMap((Function1 & Serializable)v -> Option$.MODULE$.apply((Object)v.getPersistentVolumeClaim()).map((Function1 & Serializable)x$5 -> x$5.getClaimName())))).distinct();
        scala.collection.immutable.Set schedulerKnownExecs = ((IterableOnceOps)schedulerBackend.getExecutorIds().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$6))))).toSet();
        this.schedulerKnownNewlyCreatedExecs().$plus$plus$eq((IterableOnce)((StrictOptimizedMapOps)this.newlyCreatedExecutors().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$9(schedulerKnownExecs, x0$1)))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                long k = tuple2._1$mcJ$sp();
                Tuple2 v = (Tuple2)tuple2._2();
                return new Tuple2.mcJI.sp(k, v._1$mcI$sp());
            }
            throw new MatchError((Object)tuple2);
        }));
        this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)this.schedulerKnownNewlyCreatedExecs().keySet());
        long currentTime = this.clock.getTimeMillis();
        scala.collection.mutable.Iterable timedOut = (scala.collection.mutable.Iterable)this.newlyCreatedExecutors().flatMap((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                long execId = tuple2._1$mcJ$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    long timeCreated = tuple22._2$mcJ$sp();
                    if (currentTime - timeCreated > this.podCreationTimeout()) {
                        return new Some((Object)BoxesRunTime.boxToLong((long)execId));
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Executor with id " + execId + " was not found in the Kubernetes cluster since it was created " + (currentTime - timeCreated) + " milliseconds ago.");
                    return None$.MODULE$;
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (timedOut.nonEmpty()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Executors with ids ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXECUTOR_IDS, timedOut.mkString(","))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"were not detected in the Kubernetes cluster after "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms despite the fact that a previous "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TIMEOUT, BoxesRunTime.boxToLong((long)this.podCreationTimeout()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"allocation attempt tried to create them. The executors may have been deleted but the "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application missed the deletion event."}))).log((Seq)Nil$.MODULE$))));
            this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)timedOut);
            if (this.shouldDeleteExecutors()) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((IterableOnceOps)timedOut.toSeq().map((Function1 & Serializable)x$7 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$15(BoxesRunTime.unboxToLong((Object)x$7)))).toArray(ClassTag$.MODULE$.apply(String.class)))).delete());
            }
        }
        if (snapshots.nonEmpty()) {
            this.lastSnapshot_$eq((ExecutorPodsSnapshot)snapshots.last());
        }
        ObjectRef _deletedExecutorIds = ObjectRef.create(this.deletedExecutorIds());
        if (snapshots.nonEmpty()) {
            scala.collection.immutable.Set existingExecs = this.lastSnapshot().executorPods().keySet();
            _deletedExecutorIds.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds.elem).intersect((Set)existingExecs);
        }
        scala.collection.immutable.Map notDeletedPods = (scala.collection.immutable.Map)this.lastSnapshot().executorPods().filter((Function1 & Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$16(_deletedExecutorIds, x0$4)));
        HashMap rpIdToExecsAndPodState = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.totalExpectedExecutorsPerResourceProfileId().size() <= 1) {
            rpIdToExecsAndPodState.update((Object)BoxesRunTime.boxToInteger((int)ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID()), (Object)HashMap$.MODULE$.empty().$plus$plus$eq((IterableOnce)notDeletedPods));
        } else {
            notDeletedPods.foreach((Function1 & Serializable)x0$5 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$17(rpIdToExecsAndPodState, x0$5);
                return BoxedUnit.UNIT;
            });
        }
        IntRef totalPendingCount = IntRef.create((int)0);
        IntRef totalNotRunningPodCount = IntRef.create((int)0);
        Seq podsToAllocateWithRpId = (Seq)((IterableOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.totalExpectedExecutorsPerResourceProfileId()).asScala().toSeq().sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).flatMap((Function1 & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                int rpId = tuple2._1$mcI$sp();
                int targetNum = tuple2._2$mcI$sp();
                HashMap podsForRpId = (HashMap)rpIdToExecsAndPodState.getOrElse((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable)() -> HashMap$.MODULE$.empty());
                int currentRunningCount = podsForRpId.values().count((Function1 & Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$22(x0$7)));
                Tuple2 tuple22 = ((StrictOptimizedIterableOps)podsForRpId.filter((Function1 & Serializable)x0$8 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$23(x0$8)))).partition((Function1 & Serializable)x0$9 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$24(schedulerKnownExecs, x0$9)));
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                HashMap schedulerKnownPendingExecsForRpId = (HashMap)tuple22._1();
                HashMap currentPendingExecutorsForRpId = (HashMap)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)schedulerKnownPendingExecsForRpId, (Object)currentPendingExecutorsForRpId);
                HashMap schedulerKnownPendingExecsForRpId2 = (HashMap)tuple23._1();
                HashMap currentPendingExecutorsForRpId2 = (HashMap)tuple23._2();
                IntRef pendingCountForRpId = IntRef.create((int)currentPendingExecutorsForRpId2.size());
                LinkedHashMap newlyCreatedExecutorsForRpId = (LinkedHashMap)this.newlyCreatedExecutors().filter((Function1 & Serializable)x0$10 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$25(rpId, x0$10)));
                LinkedHashMap schedulerKnownNewlyCreatedExecsForRpId = (LinkedHashMap)this.schedulerKnownNewlyCreatedExecs().filter((Function1 & Serializable)x0$11 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$26(rpId, x0$11)));
                if (podsForRpId.nonEmpty()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "ResourceProfile Id: " + rpId + " (pod allocation status: " + currentRunningCount + " running, " + currentPendingExecutorsForRpId2.size() + " unknown pending, " + schedulerKnownPendingExecsForRpId2.size() + " scheduler backend known pending, " + newlyCreatedExecutorsForRpId.size() + " unknown newly created, " + schedulerKnownNewlyCreatedExecsForRpId.size() + " scheduler backend known newly created)");
                }
                IntRef notRunningPodCountForRpId = IntRef.create((int)(currentPendingExecutorsForRpId2.size() + schedulerKnownPendingExecsForRpId2.size() + newlyCreatedExecutorsForRpId.size() + schedulerKnownNewlyCreatedExecsForRpId.size()));
                int podCountForRpId = currentRunningCount + notRunningPodCountForRpId.elem;
                if (podCountForRpId > targetNum) {
                    scala.collection.mutable.Iterable pendingToDelete;
                    int excess = podCountForRpId - targetNum;
                    List newlyCreatedToDelete = ((IterableOnceOps)((MapOps)newlyCreatedExecutorsForRpId.filter((Function1 & Serializable)x0$12 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$onNewSnapshots$28(this, currentTime, x0$12)))).keys().take(excess)).toList();
                    List toDelete = (List)newlyCreatedToDelete.$plus$plus((IterableOnce)(pendingToDelete = (scala.collection.mutable.Iterable)((StrictOptimizedIterableOps)((IterableOps)currentPendingExecutorsForRpId2.filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)this.isExecutorIdleTimedOut((ExecutorPodState)x._2(), currentTime)))).take(excess - newlyCreatedToDelete.size())).map((Function1 & Serializable)x0$13 -> BoxesRunTime.boxToLong((long)ExecutorPodsAllocator.$anonfun$onNewSnapshots$30(x0$13)))));
                    if (toDelete.nonEmpty()) {
                        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", " excess pod requests "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)toDelete.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.RESOURCE_PROFILE_IDS, toDelete.mkString(","))})))));
                        _deletedExecutorIds$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).$plus$plus((IterableOnce)toDelete);
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                            ((Deletable)((Filterable)((Filterable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withField("status.phase", "Pending")).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).withLabelIn(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL(), (String[])((List)toDelete.sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)x$10 -> ExecutorPodsAllocator.$anonfun$onNewSnapshots$33(BoxesRunTime.unboxToLong((Object)x$10))).toArray(ClassTag$.MODULE$.apply(String.class)))).delete();
                            this.newlyCreatedExecutors().$minus$minus$eq((IterableOnce)newlyCreatedToDelete);
                            pendingCountForRpId$1.elem -= pendingToDelete.size();
                            notRunningPodCountForRpId$1.elem -= toDelete.size();
                        });
                    }
                }
                totalPendingCount$1.elem += pendingCountForRpId.elem;
                totalNotRunningPodCount$1.elem += notRunningPodCountForRpId.elem;
                if (this.log().isDebugEnabled() && snapshots.nonEmpty()) {
                    if (currentRunningCount >= targetNum && !this.dynamicAllocationEnabled()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Current number of running executors for ResourceProfile Id " + rpId + " is equal to the number of requested executors. Not scaling up further.");
                    } else if (newlyCreatedExecutorsForRpId.nonEmpty()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Still waiting for " + newlyCreatedExecutorsForRpId.size() + " executors for ResourceProfile Id " + rpId + " before requesting more.");
                    }
                }
                if (newlyCreatedExecutorsForRpId.isEmpty() && podCountForRpId < targetNum) {
                    return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)rpId), (Object)BoxesRunTime.boxToInteger((int)podCountForRpId), (Object)BoxesRunTime.boxToInteger((int)targetNum), (Object)BoxesRunTime.boxToInteger((int)notRunningPodCountForRpId.elem)));
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        });
        int remainingSlotFromPendingPods = this.maxPendingPods() - totalNotRunningPodCount.elem;
        if (!(remainingSlotFromPendingPods <= 0 || podsToAllocateWithRpId.size() <= 0 || snapshots.isEmpty() && this.podAllocOnPVC() && this.maxPVCs() <= this.PVC_COUNTER().get())) {
            ExecutorPodsAllocator$.MODULE$.splitSlots(podsToAllocateWithRpId, remainingSlotFromPendingPods).foreach((Function1 & Serializable)x0$14 -> {
                ExecutorPodsAllocator.$anonfun$onNewSnapshots$36(this, applicationId, k8sKnownPVCNames, x0$14);
                return BoxedUnit.UNIT;
            });
        }
        this.deletedExecutorIds_$eq((scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)_deletedExecutorIds.elem));
        this.numOutstandingPods().set(totalPendingCount.elem + this.newlyCreatedExecutors().size());
    }

    public Buffer<PersistentVolumeClaim> getReusablePVCs(String applicationId, Seq<String> pvcsInUse) {
        if (BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && this.driverPod().nonEmpty()) {
            Buffer buffer;
            try {
                Buffer createdPVCs = CollectionConverters$.MODULE$.ListHasAsScala(((PersistentVolumeClaimList)((Listable)((Filterable)this.kubernetesClient.persistentVolumeClaims().inNamespace(this.namespace())).withLabel("spark-app-selector", applicationId)).list()).getItems()).asScala();
                long now = Instant.now().toEpochMilli();
                Buffer reusablePVCs = (Buffer)((IterableOps)createdPVCs.filterNot((Function1 & Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)pvcsInUse.contains((Object)pvc.getMetadata().getName())))).filter((Function1 & Serializable)pvc -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$getReusablePVCs$2(this, now, pvc)));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " reusable PVCs from "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)reusablePVCs.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " PVCs"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TOTAL, BoxesRunTime.boxToInteger((int)createdPVCs.size()))})))));
                buffer = reusablePVCs;
            }
            catch (KubernetesClientException kubernetesClientException) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Cannot list PVC resources. Please check account permissions.");
                buffer = (Buffer)Buffer$.MODULE$.empty();
            }
            return buffer;
        }
        return (Buffer)Buffer$.MODULE$.empty();
    }

    public void requestNewExecutors(int numExecutorsToAllocate, String applicationId, int resourceProfileId, Seq<String> pvcsInUse) {
        Object object = new Object();
        try {
            Buffer<PersistentVolumeClaim> reusablePVCs = this.getReusablePVCs(applicationId, pvcsInUse);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numExecutorsToAllocate).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$12 -> {
                int n = x$12;
                if (reusablePVCs.isEmpty() && this.podAllocOnPVC() && this.maxPVCs() <= this.PVC_COUNTER().get()) {
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Wait to reuse one of the existing ", " PVCs."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)this.PVC_COUNTER().get()))}))));
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                int newExecutorId = this.EXECUTOR_ID_COUNTER().incrementAndGet();
                if (newExecutorId >= this.podAllocationMaximum()) {
                    throw new SparkException("Exceed the pod creation limit: " + this.podAllocationMaximum());
                }
                KubernetesExecutorConf executorConf = KubernetesConf$.MODULE$.createExecutorConf($this.conf, Integer.toString(newExecutorId), applicationId, this.driverPod(), resourceProfileId);
                KubernetesExecutorSpec resolvedExecutorSpec = $this.executorBuilder.buildFromFeatures(executorConf, $this.secMgr, $this.kubernetesClient, (ResourceProfile)this.rpIdToResourceProfile().apply((Object)BoxesRunTime.boxToInteger((int)resourceProfileId)));
                SparkPod executorPod = resolvedExecutorSpec.pod();
                Pod podWithAttachedContainer = ((PodBuilder)((PodFluent.SpecNested)new PodBuilder(executorPod.pod()).editOrNewSpec().addToContainers(new Container[]{executorPod.container()})).endSpec()).build();
                Seq<HasMetadata> resources = this.replacePVCsIfNeeded(podWithAttachedContainer, resolvedExecutorSpec.executorKubernetesResources(), reusablePVCs);
                Pod createdExecutorPod = (Pod)((CreateOrReplaceable)((AnyNamespaceOperation)$this.kubernetesClient.pods().inNamespace(this.namespace())).resource((Object)podWithAttachedContainer)).create();
                try {
                    KubernetesUtils$.MODULE$.addOwnerReference(createdExecutorPod, resources);
                    ((IterableOnceOps)resources.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$requestNewExecutors$3(x$11)))).foreach((Function1 & Serializable)resource -> BoxesRunTime.boxToInteger((int)ExecutorPodsAllocator.$anonfun$requestNewExecutors$4(this, resource)));
                    this.newlyCreatedExecutors().update((Object)BoxesRunTime.boxToLong((long)newExecutorId), (Object)new Tuple2.mcIJ.sp(resourceProfileId, $this.clock.getTimeMillis()));
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Requested executor with id " + newExecutorId + " from Kubernetes.");
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        ((Deletable)((AnyNamespaceOperation)$this.kubernetesClient.pods().inNamespace(this.namespace())).resource((Object)createdExecutorPod)).delete();
                        throw throwable2;
                    }
                    throw throwable;
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Seq<HasMetadata> replacePVCsIfNeeded(Pod pod, Seq<HasMetadata> resources, Buffer<PersistentVolumeClaim> reusablePVCs) {
        scala.collection.mutable.Set replacedResources = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        resources.foreach((Function1 & Serializable)x0$1 -> {
            ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$1(this, reusablePVCs, pod, replacedResources, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)resources.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)replacedResources.contains((Object)elem)));
    }

    public boolean isExecutorIdleTimedOut(ExecutorPodState state, long currentTime) {
        boolean bl;
        block3: {
            try {
                long creationTime = Instant.parse(state.pod().getMetadata().getCreationTimestamp()).toEpochMilli();
                if (currentTime - creationTime > this.executorIdleTimeout()) {
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            catch (Exception e) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot get the creationTimestamp of the pod: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.POD_ID, state.pod())})))), (Throwable)e);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void stop(String applicationId) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable)() -> ((Deletable)((Filterable)((Filterable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withLabel(Constants$.MODULE$.SPARK_APP_ID_LABEL(), applicationId)).withLabel(Constants$.MODULE$.SPARK_ROLE_LABEL(), Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())).delete());
    }

    public static final /* synthetic */ int $anonfun$setTotalExpectedExecutors$1(ExecutorPodsAllocator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ResourceProfile rp = (ResourceProfile)tuple2._1();
            int numExecs = tuple2._2$mcI$sp();
            $this.rpIdToResourceProfile().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rp.id()), (Function0 & Serializable)() -> rp);
            return BoxesRunTime.unboxToInt((Object)$this.totalExpectedExecutorsPerResourceProfileId().put(BoxesRunTime.boxToInteger((int)rp.id()), BoxesRunTime.boxToInteger((int)numExecs)));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$9(scala.collection.immutable.Set schedulerKnownExecs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long k = tuple2._1$mcJ$sp();
            return schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$15(long x$7) {
        return Long.toString(x$7);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$16(ObjectRef _deletedExecutorIds$1, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 != null) {
            long k = tuple2._1$mcJ$sp();
            return !((scala.collection.immutable.Set)_deletedExecutorIds$1.elem).contains((Object)BoxesRunTime.boxToLong((long)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$17(HashMap rpIdToExecsAndPodState$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            long execId = tuple2._1$mcJ$sp();
            ExecutorPodState execPodState = (ExecutorPodState)tuple2._2();
            int rpId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)execPodState.pod().getMetadata().getLabels().get(Constants$.MODULE$.SPARK_RESOURCE_PROFILE_ID_LABEL())));
            HashMap execPods = (HashMap)rpIdToExecsAndPodState$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rpId), (Function0 & Serializable)() -> (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$));
            execPods.update((Object)BoxesRunTime.boxToLong((long)execId), (Object)execPodState);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$22(ExecutorPodState x0$7) {
        ExecutorPodState executorPodState = x0$7;
        return executorPodState instanceof PodRunning;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$23(Tuple2 x0$8) {
        ExecutorPodState executorPodState;
        Tuple2 tuple2 = x0$8;
        return tuple2 != null && (executorPodState = (ExecutorPodState)tuple2._2()) instanceof PodPending;
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$24(scala.collection.immutable.Set schedulerKnownExecs$1, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 != null) {
            long k = tuple2._1$mcJ$sp();
            return schedulerKnownExecs$1.contains((Object)BoxesRunTime.boxToLong((long)k));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$25(int rpId$1, Tuple2 x0$10) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$10;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            int waitingRpId = tuple2._1$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$26(int rpId$1, Tuple2 x0$11) {
        Tuple2 tuple2 = x0$11;
        if (tuple2 != null) {
            int waitingRpId = tuple2._2$mcI$sp();
            return rpId$1 == waitingRpId;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$onNewSnapshots$28(ExecutorPodsAllocator $this, long currentTime$1, Tuple2 x0$12) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$12;
        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
            long createTime = tuple2._2$mcJ$sp();
            return currentTime$1 - createTime > $this.executorIdleTimeout();
        }
        throw new MatchError((Object)tuple22);
    }

    public static final /* synthetic */ long $anonfun$onNewSnapshots$30(Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 != null) {
            long id = tuple2._1$mcJ$sp();
            return id;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$onNewSnapshots$33(long x$10) {
        return Long.toString(x$10);
    }

    public static final /* synthetic */ void $anonfun$onNewSnapshots$36(ExecutorPodsAllocator $this, String applicationId$2, Seq k8sKnownPVCNames$1, Tuple2 x0$14) {
        Tuple2 tuple2 = x0$14;
        if (tuple2 != null) {
            Tuple4 tuple4 = (Tuple4)tuple2._1();
            int sharedSlotFromPendingPods = tuple2._2$mcI$sp();
            if (tuple4 != null) {
                int rpId = BoxesRunTime.unboxToInt((Object)tuple4._1());
                int podCountForRpId = BoxesRunTime.unboxToInt((Object)tuple4._2());
                int targetNum = BoxesRunTime.unboxToInt((Object)tuple4._3());
                int pendingPodCountForRpId = BoxesRunTime.unboxToInt((Object)tuple4._4());
                int remainingSlotsForRpId = $this.maxPendingPodsPerRpid() - pendingPodCountForRpId;
                int numMissingPodsForRpId = targetNum - podCountForRpId;
                int numExecutorsToAllocate = BoxesRunTime.unboxToInt((Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{numMissingPodsForRpId, $this.podAllocationSize(), sharedSlotFromPendingPods, remainingSlotsForRpId})).min((Ordering)Ordering.Int$.MODULE$));
                $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Going to request ", " executors from"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)numExecutorsToAllocate))})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" Kubernetes for ResourceProfile Id: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.RESOURCE_PROFILE_ID, BoxesRunTime.boxToInteger((int)rpId))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"target: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.NUM_POD_TARGET, BoxesRunTime.boxToInteger((int)targetNum))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"known: ", ", sharedSlotFromPendingPods: "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.NUM_POD, BoxesRunTime.boxToInteger((int)podCountForRpId))}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.NUM_POD_SHARED_SLOT, BoxesRunTime.boxToInteger((int)sharedSlotFromPendingPods))})))));
                $this.requestNewExecutors(numExecutorsToAllocate, applicationId$2, rpId, (Seq<String>)k8sKnownPVCNames$1);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getReusablePVCs$2(ExecutorPodsAllocator $this, long now$1, PersistentVolumeClaim pvc) {
        return now$1 - Instant.parse(pvc.getMetadata().getCreationTimestamp()).toEpochMilli() > $this.podCreationTimeout();
    }

    public static final /* synthetic */ boolean $anonfun$requestNewExecutors$3(HasMetadata x$11) {
        String string = x$11.getKind();
        String string2 = "PersistentVolumeClaim";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$requestNewExecutors$4(ExecutorPodsAllocator $this, HasMetadata resource) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && $this.driverPod().nonEmpty()) {
            KubernetesUtils$.MODULE$.addOwnerReference((Pod)$this.driverPod().get(), (Seq<HasMetadata>)new .colon.colon((Object)resource, (List)Nil$.MODULE$));
        }
        PersistentVolumeClaim pvc = (PersistentVolumeClaim)resource;
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to create PersistentVolumeClaim "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.PVC_METADATA_NAME, pvc.getMetadata().getName())}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"StorageClass ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.CLASS_NAME, pvc.getSpec().getStorageClassName())})))));
        ((CreateOrReplaceable)((AnyNamespaceOperation)$this.kubernetesClient.persistentVolumeClaims().inNamespace($this.namespace())).resource((Object)pvc)).create();
        return $this.PVC_COUNTER().incrementAndGet();
    }

    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$2(PersistentVolumeClaim x2$1, PersistentVolumeClaim p) {
        String string = p.getSpec().getStorageClassName();
        String string2 = x2$1.getSpec().getStorageClassName();
        return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.equals(p.getSpec().getResources().getRequests().get("storage"), x2$1.getSpec().getResources().getRequests().get("storage"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replacePVCsIfNeeded$3(PersistentVolumeClaim x2$1, Volume v) {
        if (v.getPersistentVolumeClaim() == null) return false;
        String string = v.getPersistentVolumeClaim().getClaimName();
        String string2 = x2$1.getMetadata().getName();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$replacePVCsIfNeeded$1(ExecutorPodsAllocator $this, Buffer reusablePVCs$3, Pod pod$2, scala.collection.mutable.Set replacedResources$1, HasMetadata x0$1) {
        HasMetadata hasMetadata = x0$1;
        if (hasMetadata instanceof PersistentVolumeClaim) {
            PersistentVolumeClaim persistentVolumeClaim = (PersistentVolumeClaim)hasMetadata;
            int index = reusablePVCs$3.indexWhere((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$2(persistentVolumeClaim, p)));
            if (index >= 0) {
                Option volume = CollectionConverters$.MODULE$.ListHasAsScala(pod$2.getSpec().getVolumes()).asScala().find((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)ExecutorPodsAllocator.$anonfun$replacePVCsIfNeeded$3(persistentVolumeClaim, v)));
                if (volume.nonEmpty()) {
                    PersistentVolumeClaim matchedPVC = (PersistentVolumeClaim)reusablePVCs$3.remove(index);
                    replacedResources$1.add((Object)persistentVolumeClaim);
                    $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reuse PersistentVolumeClaim "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.PVC_METADATA_NAME, matchedPVC.getMetadata().getName())})))));
                    ((Volume)volume.get()).getPersistentVolumeClaim().setClaimName(matchedPVC.getMetadata().getName());
                    return;
                }
                return;
            }
            return;
        }
    }

    public ExecutorPodsAllocator(SparkConf conf, SecurityManager secMgr, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Clock clock) {
        this.conf = conf;
        this.secMgr = secMgr;
        this.executorBuilder = executorBuilder;
        this.kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.clock = clock;
        Logging.$init$((Logging)this);
        this.EXECUTOR_ID_COUNTER = new AtomicInteger(0);
        this.PVC_COUNTER = new AtomicInteger(0);
        this.maxPVCs = Utils$.MODULE$.isDynamicAllocationEnabled((ReadOnlySparkConf)conf) ? BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_MAX_EXECUTORS())) : conf.getInt(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_INSTANCES().key(), SchedulerBackendUtils$.MODULE$.DEFAULT_NUMBER_EXECUTORS());
        this.podAllocOnPVC = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_OWN_PVC())) && BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_REUSE_PVC())) && BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_WAIT_TO_REUSE_PVC()));
        this.totalExpectedExecutorsPerResourceProfileId = new ConcurrentHashMap();
        this.rpIdToResourceProfile = new HashMap();
        this.podAllocationSize = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_SIZE()));
        this.podAllocationDelay = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_BATCH_DELAY()));
        this.podAllocationMaximum = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_MAXIMUM()));
        this.maxPendingPods = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS()));
        this.maxPendingPodsPerRpid = BoxesRunTime.unboxToInt((Object)conf.get(Config$.MODULE$.KUBERNETES_MAX_PENDING_PODS_PER_RPID()));
        if (this.maxPendingPodsPerRpid() != Integer.MAX_VALUE) {
            Predef$.MODULE$.require(this.maxPendingPodsPerRpid() <= this.maxPendingPods(), (Function0 & Serializable)() -> "Maximum pending pods per resource profile ID (" + this.maxPendingPodsPerRpid() + ") must be less than or equal to maximum pending pods (" + this.maxPendingPods() + ").");
        }
        this.podCreationTimeout = package$.MODULE$.max(this.podAllocationDelay() * 5L, BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_EXECUTOR_TIMEOUT())));
        this.driverPodReadinessTimeout = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_ALLOCATION_DRIVER_READINESS_TIMEOUT()));
        this.executorIdleTimeout = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DYN_ALLOCATION_EXECUTOR_IDLE_TIMEOUT())) * 1000L;
        this.namespace = (String)conf.get(Config$.MODULE$.KUBERNETES_NAMESPACE());
        this.kubernetesDriverPodName = (Option)conf.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME());
        this.shouldDeleteExecutors = BoxesRunTime.unboxToBoolean((Object)conf.get(Config$.MODULE$.KUBERNETES_DELETE_EXECUTORS()));
        this.driverPod = this.kubernetesDriverPodName().map((Function1 & Serializable)name -> (Pod)Option$.MODULE$.apply(((Gettable)((Nameable)$this.kubernetesClient.pods().inNamespace(this.namespace())).withName(name)).get()).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException("No pod was found named " + name + " in the cluster in the namespace " + this.namespace() + " (this was supposed to be the driver pod.).");
        }));
        this.newlyCreatedExecutors = LinkedHashMap$.MODULE$.empty();
        this.schedulerKnownNewlyCreatedExecs = LinkedHashMap$.MODULE$.empty();
        this.dynamicAllocationEnabled = Utils$.MODULE$.isDynamicAllocationEnabled((ReadOnlySparkConf)conf);
        this.numOutstandingPods = new AtomicInteger();
        this.lastSnapshot = ExecutorPodsSnapshot$.MODULE$.apply();
        this.deletedExecutorIds = Predef$.MODULE$.Set().empty();
    }
}

