/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.leader;

import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.CancelLeadershipException;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.utils.CloseableExecutorService;
import org.apache.curator.utils.PathUtils;
import org.apache.curator.utils.ThreadUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderSelector
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    private final LeaderSelectorListener listener;
    private final CloseableExecutorService executorService;
    private final InterProcessMutex mutex;
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final AtomicBoolean autoRequeue = new AtomicBoolean(false);
    private Future<?> ourTask = null;
    private Thread ourThread = null;
    private volatile boolean hasLeadership;
    private volatile String id = "";
    @VisibleForTesting
    volatile CountDownLatch debugLeadershipLatch = null;
    volatile CountDownLatch debugLeadershipWaitLatch = null;
    private static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory((String)"LeaderSelector");
    @VisibleForTesting
    volatile AtomicInteger failedMutexReleaseCount = null;

    public LeaderSelector(CuratorFramework client, String leaderPath, LeaderSelectorListener listener) {
        this(client, leaderPath, new CloseableExecutorService(Executors.newSingleThreadExecutor(defaultThreadFactory), true), listener);
    }

    @Deprecated
    public LeaderSelector(CuratorFramework client, String leaderPath, ThreadFactory threadFactory, Executor executor, LeaderSelectorListener listener) {
        this(client, leaderPath, new CloseableExecutorService(LeaderSelector.wrapExecutor(executor), true), listener);
    }

    public LeaderSelector(CuratorFramework client, String leaderPath, ExecutorService executorService, LeaderSelectorListener listener) {
        this(client, leaderPath, new CloseableExecutorService(executorService), listener);
    }

    public LeaderSelector(CuratorFramework client, String leaderPath, CloseableExecutorService executorService, LeaderSelectorListener listener) {
        Preconditions.checkNotNull((Object)client, (Object)"client cannot be null");
        PathUtils.validatePath((String)leaderPath);
        Preconditions.checkNotNull((Object)listener, (Object)"listener cannot be null");
        this.client = client;
        this.listener = new WrappedListener(this, listener);
        this.hasLeadership = false;
        this.executorService = executorService;
        this.mutex = new InterProcessMutex(client, leaderPath){

            @Override
            protected byte[] getLockNodeBytes() {
                return LeaderSelector.this.id.length() > 0 ? LeaderSelector.getIdBytes(LeaderSelector.this.id) : null;
            }
        };
    }

    static byte[] getIdBytes(String id) {
        try {
            return id.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public void autoRequeue() {
        this.autoRequeue.set(true);
    }

    public void setId(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void start() {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Cannot be started more than once");
        Preconditions.checkState((!this.executorService.isShutdown() ? 1 : 0) != 0, (Object)"Already started");
        Preconditions.checkState((!this.hasLeadership ? 1 : 0) != 0, (Object)"Already has leadership");
        this.client.getConnectionStateListenable().addListener((Object)this.listener);
        this.requeue();
    }

    public boolean requeue() {
        Preconditions.checkState((this.state.get() == State.STARTED ? 1 : 0) != 0, (Object)"close() has already been called");
        return this.internalRequeue();
    }

    private synchronized boolean internalRequeue() {
        if (this.ourTask == null && this.state.get() == State.STARTED) {
            this.ourTask = this.executorService.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LeaderSelector.this.doWorkLoop();
                    return null;
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.STARTED, State.CLOSED), (Object)"Already closed or has not been started");
        this.client.getConnectionStateListenable().removeListener((Object)this.listener);
        this.executorService.close();
        this.ourTask = null;
    }

    public Collection<Participant> getParticipants() throws Exception {
        Collection<String> participantNodes = this.mutex.getParticipantNodes();
        return LeaderSelector.getParticipants(this.client, participantNodes);
    }

    static Collection<Participant> getParticipants(CuratorFramework client, Collection<String> participantNodes) throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean isLeader = true;
        for (String path : participantNodes) {
            Participant participant = LeaderSelector.participantForPath(client, path, isLeader);
            if (participant == null) continue;
            builder.add((Object)participant);
            isLeader = false;
        }
        return builder.build();
    }

    public Participant getLeader() throws Exception {
        Collection<String> participantNodes = this.mutex.getParticipantNodes();
        return LeaderSelector.getLeader(this.client, participantNodes);
    }

    static Participant getLeader(CuratorFramework client, Collection<String> participantNodes) throws Exception {
        Participant result = null;
        if (participantNodes.size() > 0) {
            Iterator<String> iter = participantNodes.iterator();
            while (iter.hasNext() && (result = LeaderSelector.participantForPath(client, iter.next(), true)) == null) {
            }
        }
        if (result == null) {
            result = new Participant();
        }
        return result;
    }

    public boolean hasLeadership() {
        return this.hasLeadership;
    }

    private synchronized void taskStarted() {
        this.ourThread = Thread.currentThread();
    }

    private synchronized boolean taskDone() {
        this.ourTask = null;
        this.ourThread = null;
        boolean leadership = this.hasLeadership;
        if (leadership) {
            this.hasLeadership = false;
        }
        if (this.autoRequeue.get()) {
            this.internalRequeue();
        }
        return leadership;
    }

    private synchronized void cancelElection() {
        if (this.ourThread != null) {
            this.ourThread.interrupt();
        }
    }

    public synchronized void interruptLeadership() {
        if (this.hasLeadership) {
            this.cancelElection();
        }
    }

    private static Participant participantForPath(CuratorFramework client, String path, boolean markAsLeader) throws Exception {
        try {
            byte[] bytes = (byte[])client.getData().forPath(path);
            String thisId = new String(bytes, "UTF-8");
            return new Participant(thisId, markAsLeader);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    void doWork() throws Exception {
        this.taskStarted();
        this.hasLeadership = false;
        try {
            this.mutex.acquire();
            this.hasLeadership = true;
            try {
                if (this.debugLeadershipLatch != null) {
                    this.debugLeadershipLatch.countDown();
                }
                if (this.debugLeadershipWaitLatch != null) {
                    this.debugLeadershipWaitLatch.await();
                }
                this.listener.takeLeadership(this.client);
                return;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            catch (Throwable e) {
                ThreadUtils.checkInterrupted((Throwable)e);
                return;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        finally {
            if (this.taskDone()) {
                boolean wasInterrupted = Thread.interrupted();
                try {
                    this.mutex.release();
                }
                catch (Exception e) {
                    if (this.failedMutexReleaseCount != null) {
                        this.failedMutexReleaseCount.incrementAndGet();
                    }
                    ThreadUtils.checkInterrupted((Throwable)e);
                    this.log.error("The leader threw an exception", (Throwable)e);
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    private void doWorkLoop() throws Exception {
        Throwable exception = null;
        try {
            this.doWork();
        }
        catch (KeeperException.ConnectionLossException e) {
            exception = e;
        }
        catch (KeeperException.SessionExpiredException e) {
            exception = e;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        if (exception != null && !this.autoRequeue.get()) {
            throw exception;
        }
    }

    private static ExecutorService wrapExecutor(final Executor executor) {
        return new AbstractExecutorService(){
            private volatile boolean isShutdown = false;
            private volatile boolean isTerminated = false;

            @Override
            public void shutdown() {
                this.isShutdown = true;
            }

            @Override
            public List<Runnable> shutdownNow() {
                return Lists.newArrayList();
            }

            @Override
            public boolean isShutdown() {
                return this.isShutdown;
            }

            @Override
            public boolean isTerminated() {
                return this.isTerminated;
            }

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void execute(Runnable command) {
                try {
                    executor.execute(command);
                }
                finally {
                    this.isShutdown = true;
                    this.isTerminated = true;
                }
            }
        };
    }

    private static class WrappedListener
    implements LeaderSelectorListener {
        private final LeaderSelector leaderSelector;
        private final LeaderSelectorListener listener;

        public WrappedListener(LeaderSelector leaderSelector, LeaderSelectorListener listener) {
            this.leaderSelector = leaderSelector;
            this.listener = listener;
        }

        @Override
        public void takeLeadership(CuratorFramework client) throws Exception {
            this.listener.takeLeadership(client);
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            try {
                this.listener.stateChanged(client, newState);
            }
            catch (CancelLeadershipException dummy) {
                this.leaderSelector.cancelElection();
            }
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

