/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.io.grpc.services;

import java.util.Map;
import org.sparkproject.connect.guava.base.MoreObjects;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.io.grpc.ExperimentalApi;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9381")
public final class MetricReport {
    private double cpuUtilization;
    private double applicationUtilization;
    private double memoryUtilization;
    private double qps;
    private double eps;
    private Map<String, Double> requestCostMetrics;
    private Map<String, Double> utilizationMetrics;
    private Map<String, Double> namedMetrics;

    MetricReport(double cpuUtilization, double applicationUtilization, double memoryUtilization, double qps, double eps, Map<String, Double> requestCostMetrics, Map<String, Double> utilizationMetrics, Map<String, Double> namedMetrics) {
        this.cpuUtilization = cpuUtilization;
        this.applicationUtilization = applicationUtilization;
        this.memoryUtilization = memoryUtilization;
        this.qps = qps;
        this.eps = eps;
        this.requestCostMetrics = Preconditions.checkNotNull(requestCostMetrics, "requestCostMetrics");
        this.utilizationMetrics = Preconditions.checkNotNull(utilizationMetrics, "utilizationMetrics");
        this.namedMetrics = Preconditions.checkNotNull(namedMetrics, "namedMetrics");
    }

    public double getCpuUtilization() {
        return this.cpuUtilization;
    }

    public double getApplicationUtilization() {
        return this.applicationUtilization;
    }

    public double getMemoryUtilization() {
        return this.memoryUtilization;
    }

    public Map<String, Double> getRequestCostMetrics() {
        return this.requestCostMetrics;
    }

    public Map<String, Double> getUtilizationMetrics() {
        return this.utilizationMetrics;
    }

    public Map<String, Double> getNamedMetrics() {
        return this.namedMetrics;
    }

    public double getQps() {
        return this.qps;
    }

    public double getEps() {
        return this.eps;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("cpuUtilization", this.cpuUtilization).add("applicationUtilization", this.applicationUtilization).add("memoryUtilization", this.memoryUtilization).add("requestCost", this.requestCostMetrics).add("utilization", this.utilizationMetrics).add("named", this.namedMetrics).add("qps", this.qps).add("eps", this.eps).toString();
    }
}

