/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.jdbc.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;

public final class JdbcTypeUtils$ {
    public static final JdbcTypeUtils$ MODULE$ = new JdbcTypeUtils$();

    public int getColumnType(StructField field) {
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return 0;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return 16;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return -6;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return 5;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return 4;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return -5;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return 6;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 8;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return 12;
        }
        if (dataType instanceof DecimalType) {
            return 3;
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return 91;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return 93;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return 93;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return -3;
        }
        if (dataType instanceof TimeType) {
            return 92;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public String getColumnTypeClassName(StructField field) {
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return "null";
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Boolean.class.getName();
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Byte.class.getName();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Short.class.getName();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return Integer.class.getName();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return Long.class.getName();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return Float.class.getName();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return Double.class.getName();
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return String.class.getName();
        }
        if (dataType instanceof DecimalType) {
            return BigDecimal.class.getName();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return Date.class.getName();
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return Timestamp.class.getName();
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return Timestamp.class.getName();
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return byte[].class.getName();
        }
        if (dataType instanceof TimeType) {
            return Time.class.getName();
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public boolean isSigned(StructField field) {
        DataType dataType = field.dataType();
        if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : dataType instanceof DecimalType)))))) {
            return true;
        }
        if (NullType$.MODULE$.equals(dataType) ? true : (BooleanType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (BinaryType$.MODULE$.equals(dataType) ? true : (dataType instanceof TimeType ? true : (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)))))))) {
            return false;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public int getPrecision(StructField field) {
        DecimalType decimalType;
        Option option;
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return 0;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return 1;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return 3;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return 5;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return 10;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return 19;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return 7;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 15;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return Integer.MAX_VALUE;
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int p = ((Tuple2)option.get())._1$mcI$sp();
            return p;
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return 10;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return 29;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return 29;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Integer.MAX_VALUE;
        }
        if (dataType instanceof TimeType) {
            TimeType timeType = (TimeType)dataType;
            int precision = timeType.precision();
            return precision;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public int getScale(StructField field) {
        DecimalType decimalType;
        Option option;
        DataType dataType = field.dataType();
        if (FloatType$.MODULE$.equals(dataType)) {
            return 7;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 15;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return 6;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return 6;
        }
        if (NullType$.MODULE$.equals(dataType) ? true : (BooleanType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (BinaryType$.MODULE$.equals(dataType) ? true : dataType instanceof TimeType))))))))) {
            return 0;
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int s = ((Tuple2)option.get())._2$mcI$sp();
            return s;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public int getDisplaySize(StructField field) {
        Option option;
        Option option2;
        boolean bl = false;
        TimeType timeType = null;
        boolean bl2 = false;
        DecimalType decimalType = null;
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return 4;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return 5;
        }
        if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) {
            return this.getPrecision(field) + 1;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return 14;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 24;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return this.getPrecision(field);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return 10;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return 29;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return 29;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Integer.MAX_VALUE;
        }
        if (dataType instanceof TimeType) {
            bl = true;
            timeType = (TimeType)dataType;
            int precision = timeType.precision();
            if (precision > 0) {
                return 9 + precision;
            }
        }
        if (bl) {
            return 8;
        }
        if (dataType instanceof DecimalType) {
            int s;
            int p;
            bl2 = true;
            decimalType = (DecimalType)dataType;
            Option option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option3.isEmpty() && (p = ((Tuple2)option3.get())._1$mcI$sp()) == (s = ((Tuple2)option3.get())._2$mcI$sp())) {
                return p + 3;
            }
        }
        if (bl2 && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int p = ((Tuple2)option2.get())._1$mcI$sp();
            int s = ((Tuple2)option2.get())._2$mcI$sp();
            if (s == 0) {
                return p + 1;
            }
        }
        if (bl2 && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int p = ((Tuple2)option.get())._1$mcI$sp();
            return p + 2;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public Integer getDecimalDigits(StructField field) {
        DataType dataType = field.dataType();
        if (BooleanType$.MODULE$.equals(dataType) ? true : dataType instanceof IntegralType) {
            return Predef$.MODULE$.int2Integer(0);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(7);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(15);
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return Predef$.MODULE$.int2Integer(decimalType.scale());
        }
        if (dataType instanceof TimeType) {
            TimeType timeType = (TimeType)dataType;
            int scale = timeType.precision();
            return Predef$.MODULE$.int2Integer(scale);
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)) {
            return Predef$.MODULE$.int2Integer(6);
        }
        return null;
    }

    public Integer getNumPrecRadix(StructField field) {
        DataType dataType = field.dataType();
        if (dataType instanceof NumericType) {
            return Predef$.MODULE$.int2Integer(10);
        }
        return null;
    }

    private JdbcTypeUtils$() {
    }
}

