/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.mllib.linalg.LAPACK$;
import org.netlib.util.intW;

public final class CholeskyDecomposition$ {
    public static final CholeskyDecomposition$ MODULE$ = new CholeskyDecomposition$();

    public double[] solve(double[] A, double[] bx) {
        int k = bx.length;
        intW info = new intW(0);
        LAPACK$.MODULE$.nativeLAPACK().dppsv("U", k, 1, A, bx, k, info);
        this.checkReturnValue(info, "dppsv");
        return bx;
    }

    public double[] inverse(double[] UAi, int k) {
        intW info = new intW(0);
        LAPACK$.MODULE$.nativeLAPACK().dpptri("U", k, UAi, info);
        this.checkReturnValue(info, "dpptri");
        return UAi;
    }

    private void checkReturnValue(intW info, String method) {
        int n = info.val;
        switch (n) {
            default: 
        }
        if (n < 0) {
            throw new IllegalStateException("LAPACK." + method + " returned " + n + "; arg " + -n + " is illegal");
        }
        if (n > 0) {
            throw new SingularMatrixException("LAPACK." + method + " returned " + n + " because A is not positive definite. Is A derived from a singular matrix (e.g. collinear column values)?");
        }
    }

    private CholeskyDecomposition$() {
    }
}

