/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.Serializable;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class IDFModel$
implements Serializable {
    public static final IDFModel$ MODULE$ = new IDFModel$();

    public Vector transform(Vector idf, Vector v) {
        DenseVector denseVector;
        Option<double[]> option;
        SparseVector sparseVector;
        Option<Tuple3<Object, int[], double[]>> option2;
        Vector vector = v;
        if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
            double[] values;
            int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
            int[] indices = (int[])((Tuple3)option2.get())._2();
            Tuple2<int[], double[]> tuple2 = this.transformSparse(idf, indices, values = (double[])((Tuple3)option2.get())._3());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int[] newIndices = (int[])tuple2._1();
            double[] newValues = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)newIndices, (Object)newValues);
            int[] newIndices2 = (int[])tuple22._1();
            double[] newValues2 = (double[])tuple22._2();
            return Vectors$.MODULE$.sparse(size, newIndices2, newValues2);
        }
        if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
            double[] values = (double[])option.get();
            double[] newValues = this.transformDense(idf, values);
            return Vectors$.MODULE$.dense(newValues);
        }
        throw new UnsupportedOperationException("Only sparse and dense vectors are supported but got " + vector.getClass() + ".");
    }

    public double[] transformDense(Vector idf, double[] values) {
        int n = values.length;
        double[] newValues = new double[n];
        for (int j = 0; j < n; ++j) {
            newValues[j] = values[j] * idf.apply(j);
        }
        return newValues;
    }

    public Tuple2<int[], double[]> transformSparse(Vector idf, int[] indices, double[] values) {
        int nnz = indices.length;
        double[] newValues = new double[nnz];
        for (int k = 0; k < nnz; ++k) {
            newValues[k] = values[k] * idf.apply(indices[k]);
        }
        return new Tuple2((Object)indices, (Object)newValues);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(IDFModel$.class);
    }

    private IDFModel$() {
    }
}

