/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.security.UserGroupInformation;

public class ProxyUserAuthenticator
extends HadoopDefaultAuthenticator {
    private static final String PROXY_USER_NAME = "proxy.user.name";

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        UserGroupInformation ugi = null;
        String proxyUser = conf.get(PROXY_USER_NAME);
        if (proxyUser == null) {
            super.setConf(conf);
            return;
        }
        try {
            ugi = UserGroupInformation.createRemoteUser((String)proxyUser);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ugi == null) {
            throw new RuntimeException("Can not initialize ProxyUserAuthenticator for user [" + proxyUser + "]");
        }
        this.userName = ugi.getShortUserName();
        if (ugi.getGroupNames() != null) {
            this.groupNames = Arrays.asList(ugi.getGroupNames());
        }
    }
}

