/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.spark;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPartitionPruningSinkOperator
extends Operator<SparkPartitionPruningSinkDesc> {
    protected transient Serializer serializer;
    protected transient DataOutputBuffer buffer;
    protected static final Logger LOG = LoggerFactory.getLogger(SparkPartitionPruningSinkOperator.class);

    @VisibleForTesting
    public SparkPartitionPruningSinkOperator() {
    }

    public SparkPartitionPruningSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.serializer = (Serializer)ReflectionUtils.newInstance(((SparkPartitionPruningSinkDesc)this.conf).getTable().getDeserializerClass(), null);
        this.buffer = new DataOutputBuffer();
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        ObjectInspector rowInspector = this.inputObjInspectors[0];
        try {
            Writable writableRow = this.serializer.serialize(row, rowInspector);
            writableRow.write((DataOutput)this.buffer);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!abort) {
            try {
                this.flushToFile();
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }

    private void flushToFile() throws IOException {
        Path path = ((SparkPartitionPruningSinkDesc)this.conf).getPath();
        FileSystem fs = path.getFileSystem(this.getConfiguration());
        fs.mkdirs(path);
        while (fs.exists(path = new Path(path, String.valueOf(Utilities.randGen.nextInt())))) {
        }
        short numOfRepl = fs.getDefaultReplication(path);
        ObjectOutputStream out = null;
        FSDataOutputStream fsout = null;
        try {
            fsout = fs.create(path, numOfRepl);
            out = new ObjectOutputStream(new BufferedOutputStream((OutputStream)fsout, 4096));
            out.writeUTF(((SparkPartitionPruningSinkDesc)this.conf).getTargetColumnName());
            this.buffer.writeTo((OutputStream)out);
        }
        catch (Exception e) {
            try {
                fs.delete(path, false);
            }
            catch (Exception ex) {
                LOG.warn("Exception happened while trying to clean partial file.");
            }
            throw e;
        }
        finally {
            if (out != null) {
                LOG.info("Flushed to file: " + path);
                out.close();
            } else if (fsout != null) {
                fsout.close();
            }
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SPARKPRUNINGSINK;
    }

    @Override
    public String getName() {
        return SparkPartitionPruningSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "SPARKPRUNINGSINK";
    }
}

