/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUtils {
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    private static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);
    private static String HDFS_ID_PATH_PREFIX = "/.reserved/.inodes/";

    public static Object getFileId(FileSystem fileSystem, Path path, boolean allowSynthetic) throws IOException {
        if (fileSystem instanceof DistributedFileSystem) {
            return SHIMS.getFileId(fileSystem, path.toUri().getPath());
        }
        if (!allowSynthetic) {
            LOG.warn("Cannot get unique file ID from " + fileSystem.getClass().getSimpleName() + "; returning null");
            return null;
        }
        FileStatus fs = fileSystem.getFileStatus(path);
        return new SyntheticFileId(path, fs.getLen(), fs.getModificationTime());
    }

    public static long createFileId(String pathStr, FileStatus fs, boolean doLog, String fsName) {
        int nameHash = pathStr.hashCode();
        long fileSize = fs.getLen();
        long modTime = fs.getModificationTime();
        int fileSizeHash = (int)(fileSize ^ fileSize >>> 32);
        int modTimeHash = (int)(modTime ^ modTime >>> 32);
        int combinedHash = modTimeHash ^ fileSizeHash;
        long id = ((long)nameHash & 0xFFFFFFFFL) << 32 | (long)combinedHash & 0xFFFFFFFFL;
        if (doLog) {
            LOG.warn("Cannot get unique file ID from " + fsName + "; using " + id + " (" + pathStr + "," + nameHash + "," + fileSize + ")");
        }
        return id;
    }

    public static List<FileStatus> listLocatedStatus(FileSystem fs, Path path, PathFilter filter) throws IOException {
        RemoteIterator itr = fs.listLocatedStatus(path);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            FileStatus stat = (FileStatus)itr.next();
            if (filter != null && !filter.accept(stat.getPath())) continue;
            result.add(stat);
        }
        return result;
    }

    public static Path getFileIdPath(FileSystem fileSystem, Path path, long fileId) {
        return fileSystem instanceof DistributedFileSystem ? new Path(HDFS_ID_PATH_PREFIX + fileId) : path;
    }
}

